/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

class FilePrims
extends Primitives {
    String readtext;
    int textoffset;
    static String[] primlist = new String[]{"filetostring", "1", "resourcetostring", "1", "load", "1", "reload", "0", "stringtofile", "2", "file?", "1", "setread", "1", "getc", "0", "peek", "0", "readline", "0", "eot?", "0", "lineback", "0", "lineread", "0", "filenamefrompath", "1", "dirnamefrompath", "1", "dir", "1", "setfread", "1", "freadline", "0", "feot?", "0", "fclose", "0", "erfile", "1", "files", "1", "logopen", "1", "logprint", "1", "logclose", "0", "serialize", "2", "bytestofile", "2", "filetobytes", "1", "setmoddate", "2", "mkdir", "1"};
    BufferedReader freader;
    PrintWriter logwriter;

    FilePrims() {
    }

    @Override
    public String[] primlist() {
        return primlist;
    }

    @Override
    public Object dispatch(int n, Object[] objectArray, LContext lContext) {
        switch (n) {
            case 0: {
                return this.prim_filetostring(objectArray[0], lContext);
            }
            case 1: {
                return this.prim_resourcetostring(objectArray[0], lContext);
            }
            case 2: {
                return this.prim_load(objectArray[0], lContext);
            }
            case 3: {
                return this.prim_reload(lContext);
            }
            case 4: {
                return this.prim_stringtofile(objectArray[0], objectArray[1], lContext);
            }
            case 5: {
                return this.prim_file(objectArray[0], lContext);
            }
            case 6: {
                return this.prim_setread(objectArray[0], lContext);
            }
            case 7: {
                return this.prim_getc(lContext);
            }
            case 8: {
                return this.prim_peek(lContext);
            }
            case 9: {
                return this.prim_readline(lContext);
            }
            case 10: {
                return this.prim_eot(lContext);
            }
            case 11: {
                return this.prim_lineback(lContext);
            }
            case 12: {
                return this.prim_lineread(lContext);
            }
            case 13: {
                return this.prim_filenamefrompath(objectArray[0], lContext);
            }
            case 14: {
                return this.prim_dirnamefrompath(objectArray[0], lContext);
            }
            case 15: {
                return this.prim_dir(objectArray[0], lContext);
            }
            case 16: {
                return this.prim_setfread(objectArray[0], lContext);
            }
            case 17: {
                return this.prim_freadline(lContext);
            }
            case 18: {
                return this.prim_feot(lContext);
            }
            case 19: {
                return this.prim_fclose(lContext);
            }
            case 20: {
                return this.prim_erfile(objectArray[0], lContext);
            }
            case 21: {
                return this.prim_files(objectArray[0], lContext);
            }
            case 22: {
                return this.prim_logopen(objectArray[0], lContext);
            }
            case 23: {
                return this.prim_logprint(objectArray[0], lContext);
            }
            case 24: {
                return this.prim_logclose(lContext);
            }
            case 25: {
                return this.prim_serialize(objectArray[0], objectArray[1], lContext);
            }
            case 26: {
                return this.prim_bytestofile(objectArray[0], objectArray[1], lContext);
            }
            case 27: {
                return this.prim_filetobytes(objectArray[0], lContext);
            }
            case 28: {
                return this.prim_setmoddate(objectArray[0], objectArray[1], lContext);
            }
            case 29: {
                return this.prim_mkdir(objectArray[0], lContext);
            }
        }
        return null;
    }

    Object prim_filetostring(Object object, LContext lContext) {
        String string = Logo.prs(object);
        return this.fileToString(string, lContext);
    }

    Object prim_resourcetostring(Object object, LContext lContext) {
        String string = Logo.prs(object);
        return this.resourceToString(string, lContext);
    }

    Object prim_reload(LContext lContext) {
        lContext.tyo.println("reloading " + lContext.filename);
        return this.prim_load(lContext.filename, lContext);
    }

    Object prim_load(Object object, LContext lContext) {
        String string = Logo.prs(object);
        Logo.readAllFunctions(this.fileToString(string + ".logo", lContext), lContext);
        if (lContext.filename == null) {
            lContext.filename = string;
        }
        return null;
    }

    String resourceToString(String string, LContext lContext) {
        InputStream inputStream = FilePrims.class.getResourceAsStream(string);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)new BufferedWriter(stringWriter), true);
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                printWriter.println(string2);
            }
            String string3 = stringWriter.toString();
            return string3;
        }
        catch (IOException iOException) {
            Logo.error("Can't open file " + string, lContext);
            return null;
        }
    }

    String fileToString(String string, LContext lContext) {
        byte[] byArray = null;
        Object var4_4 = null;
        try {
            File file = new File(string);
            int n = (int)file.length();
            FileInputStream fileInputStream = new FileInputStream(file);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            byArray = new byte[n];
            dataInputStream.readFully(byArray);
            fileInputStream.close();
        }
        catch (IOException iOException) {
            Logo.error("Can't open file " + string, lContext);
        }
        return new String(byArray);
    }

    Object prim_stringtofile(Object object, Object object2, LContext lContext) {
        String string = Logo.prs(object);
        String string2 = object2 instanceof String ? (String)object2 : Logo.prs(object2);
        try {
            FileWriter fileWriter = new FileWriter(string);
            fileWriter.write(string2, 0, string2.length());
            fileWriter.close();
        }
        catch (IOException iOException) {
            Logo.error("Can't write file " + string, lContext);
        }
        return null;
    }

    Object prim_file(Object object, LContext lContext) {
        String string = Logo.prs(object);
        return new Boolean(new File(string).exists());
    }

    Object prim_setread(Object object, LContext lContext) {
        this.readtext = Logo.prs(object);
        this.textoffset = 0;
        return null;
    }

    Object prim_getc(LContext lContext) {
        if (this.textoffset >= this.readtext.length()) {
            return "";
        }
        ++this.textoffset;
        return this.readtext.substring(this.textoffset - 1, this.textoffset);
    }

    Object prim_peek(LContext lContext) {
        if (this.textoffset >= this.readtext.length()) {
            return "";
        }
        return this.readtext.substring(this.textoffset, this.textoffset + 1);
    }

    Object prim_readline(LContext lContext) {
        String string = "";
        int n = this.readtext.indexOf("\n", this.textoffset);
        if (n == -1) {
            if (this.textoffset < this.readtext.length()) {
                string = this.readtext.substring(this.textoffset, this.readtext.length());
                this.textoffset = this.readtext.length();
            }
        } else {
            string = this.readtext.substring(this.textoffset, n);
            this.textoffset = n + 1;
        }
        if (string.length() == 0) {
            return string;
        }
        if (string.charAt(string.length() - 1) == '\r') {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    Object prim_eot(LContext lContext) {
        return new Boolean(this.textoffset >= this.readtext.length());
    }

    Object prim_lineback(LContext lContext) {
        int n = this.readtext.lastIndexOf("\n", this.textoffset - 2);
        this.textoffset = n < 0 ? 0 : n + 1;
        return null;
    }

    Object prim_lineread(LContext lContext) {
        return this.readtext;
    }

    Object prim_filenamefrompath(Object object, LContext lContext) {
        return new File(Logo.prs(object)).getName();
    }

    Object prim_dirnamefrompath(Object object, LContext lContext) {
        File file = new File(Logo.prs(object));
        if (file.isDirectory()) {
            return file.getPath();
        }
        return file.getParent();
    }

    Object prim_dir(Object object, LContext lContext) {
        String[] stringArray = new File(Logo.prs(object)).list();
        if (stringArray == null) {
            return new Object[0];
        }
        return stringArray;
    }

    Object prim_setfread(Object object, LContext lContext) {
        String string = Logo.prs(object);
        try {
            this.freader = new BufferedReader(new FileReader(string));
        }
        catch (IOException iOException) {
            Logo.error("Can't fread " + string, lContext);
        }
        return null;
    }

    Object prim_freadline(LContext lContext) {
        try {
            return this.freader.readLine();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    Object prim_feot(LContext lContext) {
        String string = null;
        try {
            this.freader.mark(1000);
            string = this.freader.readLine();
            this.freader.reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new Boolean(string == null);
    }

    Object prim_fclose(LContext lContext) {
        if (this.freader == null) {
            return null;
        }
        try {
            this.freader.close();
            this.freader = null;
        }
        catch (IOException iOException) {
            Logo.error("fclose error", lContext);
        }
        return null;
    }

    Object prim_logopen(Object object, LContext lContext) {
        String string = Logo.prs(object);
        try {
            this.logwriter = new PrintWriter(new BufferedWriter(new FileWriter(string)));
        }
        catch (IOException iOException) {
            Logo.error("Can't open log for " + string, lContext);
        }
        return null;
    }

    Object prim_logprint(Object object, LContext lContext) {
        this.logwriter.println(Logo.prs(object));
        return null;
    }

    Object prim_logclose(LContext lContext) {
        this.logwriter.close();
        this.logwriter = null;
        return null;
    }

    Object prim_erfile(Object object, LContext lContext) {
        String string = Logo.prs(object);
        File file = new File(string);
        try {
            file.delete();
        }
        catch (Exception exception) {
            Logo.error("Can't delete file " + string, lContext);
        }
        return null;
    }

    Object prim_files(Object object, LContext lContext) {
        String string = Logo.prs(object);
        File file = new File(string);
        try {
            File[] fileArray = file.listFiles();
            String[] stringArray = new String[fileArray.length];
            for (int i = 0; i < fileArray.length; ++i) {
                stringArray[i] = fileArray[i].getCanonicalPath();
            }
            return stringArray;
        }
        catch (Exception exception) {
            Logo.error("Can't list directory for " + string, lContext);
            return null;
        }
    }

    Object prim_serialize(Object object, Object object2, LContext lContext) {
        String string = Logo.prs(object);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(object2);
            objectOutputStream.flush();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            Logo.error("Can't write file " + string, lContext);
        }
        return null;
    }

    Object prim_bytestofile(Object object, Object object2, LContext lContext) {
        String string = Logo.prs(object);
        byte[] byArray = (byte[])object2;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            fileOutputStream.write(byArray);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            Logo.error("Can't write file " + string, lContext);
        }
        return null;
    }

    Object prim_filetobytes(Object object, LContext lContext) {
        String string = Logo.prs(object);
        byte[] byArray = null;
        try {
            File file = new File(string);
            int n = (int)file.length();
            FileInputStream fileInputStream = new FileInputStream(file);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            byArray = new byte[n];
            dataInputStream.readFully(byArray);
            fileInputStream.close();
        }
        catch (IOException iOException) {
            Logo.error("Can't open file " + string, lContext);
        }
        return byArray;
    }

    Object prim_setmoddate(Object object, Object object2, LContext lContext) {
        String string = Logo.prs(object);
        long l = Logo.aLong(object2, lContext);
        try {
            File file = new File(string);
            file.setLastModified(l);
        }
        catch (Exception exception) {
            Logo.error("Can't set mod date " + string, lContext);
        }
        return null;
    }

    Object prim_mkdir(Object object, LContext lContext) {
        String string = Logo.prs(object);
        new File(string).mkdir();
        return null;
    }
}

