/*
 * Decompiled with CFR 0.152.
 */
class MathPrims
extends Primitives {
    static String[] primlist = new String[]{"sum", "i2", "remainder", "2", "difference", "2", "diff", "2", "product", "i2", "quotient", "2", "greater?", "2", "less?", "2", "int", "1", "minus", "1", "round", "1", "sqrt", "1", "sin", "1", "cos", "1", "tan", "1", "abs", "1", "power", "2", "arctan", "1", "pi", "0", "exp", "1", "arctan2", "2", "ln", "1", "logand", "2", "logior", "2", "logxor", "2", "lsh", "2", "and", "i2", "or", "i2", "not", "1", "random", "1", "min", "i2", "max", "i2", "number?", "1", "+", "-2", "-", "-2", "*", "-3", "/", "-3", "<", "-1", ">", "-1", "=", "-1", "equal?", "i2", "%", "-3"};
    static final double degtor = 57.29577951308232;

    MathPrims() {
    }

    @Override
    public String[] primlist() {
        return primlist;
    }

    @Override
    public Object dispatch(int n, Object[] objectArray, LContext lContext) {
        switch (n) {
            case 0: {
                return this.prim_sum(objectArray, lContext);
            }
            case 1: {
                return this.prim_remainder(objectArray[0], objectArray[1], lContext);
            }
            case 2: 
            case 3: {
                return this.prim_diff(objectArray[0], objectArray[1], lContext);
            }
            case 4: {
                return this.prim_product(objectArray, lContext);
            }
            case 5: {
                return this.prim_quotient(objectArray[0], objectArray[1], lContext);
            }
            case 6: {
                return this.prim_greaterp(objectArray[0], objectArray[1], lContext);
            }
            case 7: {
                return this.prim_lessp(objectArray[0], objectArray[1], lContext);
            }
            case 8: {
                return this.prim_int(objectArray[0], lContext);
            }
            case 9: {
                return this.prim_minus(objectArray[0], lContext);
            }
            case 10: {
                return this.prim_round(objectArray[0], lContext);
            }
            case 11: {
                return this.prim_sqrt(objectArray[0], lContext);
            }
            case 12: {
                return this.prim_sin(objectArray[0], lContext);
            }
            case 13: {
                return this.prim_cos(objectArray[0], lContext);
            }
            case 14: {
                return this.prim_tan(objectArray[0], lContext);
            }
            case 15: {
                return this.prim_abs(objectArray[0], lContext);
            }
            case 16: {
                return this.prim_power(objectArray[0], objectArray[1], lContext);
            }
            case 17: {
                return this.prim_arctan(objectArray[0], lContext);
            }
            case 18: {
                return this.prim_pi(lContext);
            }
            case 19: {
                return this.prim_exp(objectArray[0], lContext);
            }
            case 20: {
                return this.prim_arctan2(objectArray[0], objectArray[1], lContext);
            }
            case 21: {
                return this.prim_ln(objectArray[0], lContext);
            }
            case 22: {
                return this.prim_logand(objectArray[0], objectArray[1], lContext);
            }
            case 23: {
                return this.prim_logior(objectArray[0], objectArray[1], lContext);
            }
            case 24: {
                return this.prim_logxor(objectArray[0], objectArray[1], lContext);
            }
            case 25: {
                return this.prim_lsh(objectArray[0], objectArray[1], lContext);
            }
            case 26: {
                return this.prim_and(objectArray, lContext);
            }
            case 27: {
                return this.prim_or(objectArray, lContext);
            }
            case 28: {
                return this.prim_not(objectArray[0], lContext);
            }
            case 29: {
                return this.prim_random(objectArray[0], lContext);
            }
            case 30: {
                return this.prim_min(objectArray, lContext);
            }
            case 31: {
                return this.prim_max(objectArray, lContext);
            }
            case 32: {
                return this.prim_numberp(objectArray[0], lContext);
            }
            case 33: {
                return this.prim_sum(objectArray, lContext);
            }
            case 34: {
                return this.prim_diff(objectArray[0], objectArray[1], lContext);
            }
            case 35: {
                return this.prim_product(objectArray, lContext);
            }
            case 36: {
                return this.prim_quotient(objectArray[0], objectArray[1], lContext);
            }
            case 37: {
                return this.prim_lessp(objectArray[0], objectArray[1], lContext);
            }
            case 38: {
                return this.prim_greaterp(objectArray[0], objectArray[1], lContext);
            }
            case 39: 
            case 40: {
                return this.prim_equalp(objectArray, lContext);
            }
            case 41: {
                return this.prim_remainder(objectArray[0], objectArray[1], lContext);
            }
        }
        return null;
    }

    Object prim_sum(Object[] objectArray, LContext lContext) {
        double d = 0.0;
        for (int i = 0; i < objectArray.length; ++i) {
            d += Logo.aDouble(objectArray[i], lContext);
        }
        return new Double(d);
    }

    Object prim_remainder(Object object, Object object2, LContext lContext) {
        return new Double(Logo.aDouble(object, lContext) % Logo.aDouble(object2, lContext));
    }

    Object prim_diff(Object object, Object object2, LContext lContext) {
        return new Double(Logo.aDouble(object, lContext) - Logo.aDouble(object2, lContext));
    }

    Object prim_product(Object[] objectArray, LContext lContext) {
        double d = 1.0;
        for (int i = 0; i < objectArray.length; ++i) {
            d *= Logo.aDouble(objectArray[i], lContext);
        }
        return new Double(d);
    }

    Object prim_quotient(Object object, Object object2, LContext lContext) {
        return new Double(Logo.aDouble(object, lContext) / Logo.aDouble(object2, lContext));
    }

    Object prim_greaterp(Object object, Object object2, LContext lContext) {
        return new Boolean(Logo.aDouble(object, lContext) > Logo.aDouble(object2, lContext));
    }

    Object prim_lessp(Object object, Object object2, LContext lContext) {
        return new Boolean(Logo.aDouble(object, lContext) < Logo.aDouble(object2, lContext));
    }

    Object prim_int(Object object, LContext lContext) {
        return new Double(new Double(Logo.aDouble(object, lContext)).longValue());
    }

    Object prim_minus(Object object, LContext lContext) {
        return new Double(0.0 - Logo.aDouble(object, lContext));
    }

    Object prim_round(Object object, LContext lContext) {
        return new Double(Math.round(Logo.aDouble(object, lContext)));
    }

    Object prim_sqrt(Object object, LContext lContext) {
        return new Double(Math.sqrt(Logo.aDouble(object, lContext)));
    }

    Object prim_sin(Object object, LContext lContext) {
        return new Double(Math.sin(Logo.aDouble(object, lContext) / 57.29577951308232));
    }

    Object prim_cos(Object object, LContext lContext) {
        return new Double(Math.cos(Logo.aDouble(object, lContext) / 57.29577951308232));
    }

    Object prim_tan(Object object, LContext lContext) {
        return new Double(Math.tan(Logo.aDouble(object, lContext) / 57.29577951308232));
    }

    Object prim_abs(Object object, LContext lContext) {
        return new Double(Math.abs(Logo.aDouble(object, lContext)));
    }

    Object prim_power(Object object, Object object2, LContext lContext) {
        return new Double(Math.pow(Logo.aDouble(object, lContext), Logo.aDouble(object2, lContext)));
    }

    Object prim_arctan(Object object, LContext lContext) {
        return new Double(57.29577951308232 * Math.atan(Logo.aDouble(object, lContext)));
    }

    Object prim_pi(LContext lContext) {
        return new Double(Math.PI);
    }

    Object prim_exp(Object object, LContext lContext) {
        return new Double(Math.exp(Logo.aDouble(object, lContext)));
    }

    Object prim_arctan2(Object object, Object object2, LContext lContext) {
        return new Double(57.29577951308232 * Math.atan2(Logo.aDouble(object, lContext), Logo.aDouble(object2, lContext)));
    }

    Object prim_ln(Object object, LContext lContext) {
        return new Double(Math.log(Logo.aDouble(object, lContext)));
    }

    Object prim_logand(Object object, Object object2, LContext lContext) {
        return new Double(Logo.aLong(object, lContext) & Logo.aLong(object2, lContext));
    }

    Object prim_logior(Object object, Object object2, LContext lContext) {
        return new Double(Logo.aLong(object, lContext) | Logo.aLong(object2, lContext));
    }

    Object prim_logxor(Object object, Object object2, LContext lContext) {
        return new Double(Logo.aLong(object, lContext) ^ Logo.aLong(object2, lContext));
    }

    Object prim_lsh(Object object, Object object2, LContext lContext) {
        int n = Logo.anInt(object2, lContext);
        long l = Logo.aLong(object, lContext);
        return n > 0 ? new Double(l << n) : new Double(l >> -n);
    }

    Object prim_and(Object[] objectArray, LContext lContext) {
        boolean bl = true;
        for (int i = 0; i < objectArray.length; ++i) {
            bl &= Logo.aBoolean(objectArray[i], lContext);
        }
        return new Boolean(bl);
    }

    Object prim_or(Object[] objectArray, LContext lContext) {
        boolean bl = false;
        for (int i = 0; i < objectArray.length; ++i) {
            bl |= Logo.aBoolean(objectArray[i], lContext);
        }
        return new Boolean(bl);
    }

    Object prim_not(Object object, LContext lContext) {
        return new Boolean(!Logo.aBoolean(object, lContext));
    }

    Object prim_random(Object object, LContext lContext) {
        return new Double(Math.floor(Math.random() * (double)Logo.anInt(object, lContext)));
    }

    Object prim_min(Object[] objectArray, LContext lContext) {
        if (objectArray.length == 0) {
            Logo.error("Min needs at least one input", lContext);
        }
        double d = Logo.aDouble(objectArray[0], lContext);
        for (int i = 1; i < objectArray.length; ++i) {
            d = Math.min(d, Logo.aDouble(objectArray[i], lContext));
        }
        return new Double(d);
    }

    Object prim_max(Object[] objectArray, LContext lContext) {
        if (objectArray.length == 0) {
            Logo.error("Max needs at least one input", lContext);
        }
        double d = Logo.aDouble(objectArray[0], lContext);
        for (int i = 1; i < objectArray.length; ++i) {
            d = Math.max(d, Logo.aDouble(objectArray[i], lContext));
        }
        return new Double(d);
    }

    Object prim_numberp(Object object, LContext lContext) {
        try {
            double d = Logo.aDouble(object, lContext);
            return new Boolean(true);
        }
        catch (LogoError logoError) {
            return new Boolean(false);
        }
    }

    Object prim_equalp(Object[] objectArray, LContext lContext) {
        if (objectArray.length == 0) {
            Logo.error("Equal needs at least one input", lContext);
        }
        Object object = objectArray[0];
        for (int i = 1; i < objectArray.length; ++i) {
            if (Logo.prs(object).equals(Logo.prs(objectArray[i]))) continue;
            return new Boolean(false);
        }
        return new Boolean(true);
    }
}

