/*
 * linux/<file location within the kernel tree>
 *
 * Copyright (C) 2010 Texas Instruments Incorporated
 * Author: Ganeshan N
 *
 * Based on <Give reference of old kernel file from which this file is derived from>
 *
 *  This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as  published by the
 * Free Software Foundation version 2.
 *
 * This program is distributed "as is" WITHOUT ANY WARRANTY of any kind,
 * whether express or implied; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */

#ifndef _PRU_CAN_API_H_
#define _PRU_CAN_API_H_
#ifdef __cplusplus
extern "C" {
#endif

#include "pru.h"
#include "csl/soc_OMAPL138.h"
#ifdef __KERNEL__
#include <linux/types.h>
#else
	typedef unsigned int u32;
	typedef unsigned short u16;
	typedef unsigned char u8;
	typedef unsigned char bool;
#define true 1
#define false 0
#ifndef NULL
#define NULL 0
#endif
#endif
#define CAN_BIT_TIMINGS     (0x273)

/*Timer Clock is sourced from DDR freq (PLL1 SYS CLK 2)*/
#define	TIMER_CLK_FREQ	132000000

#define TIMER_SETUP_DELAY	14
#define GPIO_SETUP_DELAY	150

//Number of Instruction in the Delay loop
#define DELAY_LOOP_LENGTH		2

/** Macro Defenitions for CAN Transmit ****************************************************************************/

#define PRU_CAN_PRU1_BASE_ADDRESS				0x2000

#define PRU_CAN_TX_GLOBAL_CONTROL_REGISTER  	(PRU_CAN_PRU1_BASE_ADDRESS)
#define PRU_CAN_TX_GLOBAL_STATUS_REGISTER  		(PRU_CAN_PRU1_BASE_ADDRESS	+	0x04)
#define PRU_CAN_TX_INTERRUPT_MASK_REGISTER  	(PRU_CAN_PRU1_BASE_ADDRESS	+	0x08)
#define PRU_CAN_TX_INTERRUPT_STATUS_REGISTER  	(PRU_CAN_PRU1_BASE_ADDRESS	+	0x0C)
#define PRU_CAN_TX_MAILBOX0_STATUS_REGISTER  	(PRU_CAN_PRU1_BASE_ADDRESS	+	0x10)
#define PRU_CAN_TX_MAILBOX1_STATUS_REGISTER  	(PRU_CAN_PRU1_BASE_ADDRESS	+	0x14)
#define PRU_CAN_TX_MAILBOX2_STATUS_REGISTER  	(PRU_CAN_PRU1_BASE_ADDRESS	+	0x18)
#define PRU_CAN_TX_MAILBOX3_STATUS_REGISTER  	(PRU_CAN_PRU1_BASE_ADDRESS	+	0x1C)
#define PRU_CAN_TX_MAILBOX4_STATUS_REGISTER  	(PRU_CAN_PRU1_BASE_ADDRESS	+	0x20)
#define PRU_CAN_TX_MAILBOX5_STATUS_REGISTER  	(PRU_CAN_PRU1_BASE_ADDRESS	+	0x24)
#define PRU_CAN_TX_MAILBOX6_STATUS_REGISTER  	(PRU_CAN_PRU1_BASE_ADDRESS	+	0x28)
#define PRU_CAN_TX_MAILBOX7_STATUS_REGISTER  	(PRU_CAN_PRU1_BASE_ADDRESS	+	0x2C)
#define PRU_CAN_TX_ERROR_COUNTER_REGISTER  		(PRU_CAN_PRU1_BASE_ADDRESS	+	0x30)
#define PRU_CAN_TX_TIMING_REGISTER  			(PRU_CAN_PRU1_BASE_ADDRESS	+	0x34)
#define PRU_CAN_TX_CLOCK_BRP_REGISTER  			(PRU_CAN_PRU1_BASE_ADDRESS	+	0x38)

#define PRU_CAN_TX_MAILBOX0	 					(PRU_CAN_PRU1_BASE_ADDRESS	+	0x40)
#define PRU_CAN_TX_MAILBOX1	 					(PRU_CAN_PRU1_BASE_ADDRESS	+	0x50)
#define PRU_CAN_TX_MAILBOX2	 					(PRU_CAN_PRU1_BASE_ADDRESS	+	0x60)
#define PRU_CAN_TX_MAILBOX3	 					(PRU_CAN_PRU1_BASE_ADDRESS	+	0x70)
#define PRU_CAN_TX_MAILBOX4	 					(PRU_CAN_PRU1_BASE_ADDRESS	+	0x80)
#define PRU_CAN_TX_MAILBOX5	 					(PRU_CAN_PRU1_BASE_ADDRESS	+	0x90)
#define PRU_CAN_TX_MAILBOX6	 					(PRU_CAN_PRU1_BASE_ADDRESS	+	0xA0)
#define PRU_CAN_TX_MAILBOX7	 					(PRU_CAN_PRU1_BASE_ADDRESS	+	0xB0)

#define PRU_CAN_TIMING_VAL_TX					(PRU_CAN_PRU1_BASE_ADDRESS	+	0xC0)
#define PRU_CAN_TIMING_VAL_TX_SJW				(PRU_CAN_PRU1_BASE_ADDRESS	+	0xC4)
#define PRU_CAN_TRANSMIT_FRAME					(PRU_CAN_PRU1_BASE_ADDRESS	+	0xE0)

/** Macro Defenitions for CAN Receive ****************************************************************************/

#define PRU_CAN_PRU0_BASE_ADDRESS					0

#define PRU_CAN_RX_GLOBAL_CONTROL_REGISTER  		(PRU_CAN_PRU0_BASE_ADDRESS)
#define PRU_CAN_RX_GLOBAL_STATUS_REGISTER  			(PRU_CAN_PRU0_BASE_ADDRESS	+	0x04)
#define PRU_CAN_RX_INTERRUPT_MASK_REGISTER  		(PRU_CAN_PRU0_BASE_ADDRESS	+	0x08)
#define PRU_CAN_RX_INTERRUPT_STATUS_REGISTER  		(PRU_CAN_PRU0_BASE_ADDRESS	+	0x0C)
#define PRU_CAN_RX_MAILBOX0_STATUS_REGISTER  		(PRU_CAN_PRU0_BASE_ADDRESS	+	0x10)
#define PRU_CAN_RX_MAILBOX1_STATUS_REGISTER  		(PRU_CAN_PRU0_BASE_ADDRESS	+	0x14)
#define PRU_CAN_RX_MAILBOX2_STATUS_REGISTER  		(PRU_CAN_PRU0_BASE_ADDRESS	+	0x18)
#define PRU_CAN_RX_MAILBOX3_STATUS_REGISTER  		(PRU_CAN_PRU0_BASE_ADDRESS	+	0x1C)
#define PRU_CAN_RX_MAILBOX4_STATUS_REGISTER  		(PRU_CAN_PRU0_BASE_ADDRESS	+	0x20)
#define PRU_CAN_RX_MAILBOX5_STATUS_REGISTER  		(PRU_CAN_PRU0_BASE_ADDRESS	+	0x24)
#define PRU_CAN_RX_MAILBOX6_STATUS_REGISTER  		(PRU_CAN_PRU0_BASE_ADDRESS	+	0x28)
#define PRU_CAN_RX_MAILBOX7_STATUS_REGISTER  		(PRU_CAN_PRU0_BASE_ADDRESS	+	0x2C)
#define PRU_CAN_RX_MAILBOX8_STATUS_REGISTER  		(PRU_CAN_PRU0_BASE_ADDRESS	+	0x30)
#define PRU_CAN_RX_ERROR_COUNTER_REGISTER  			(PRU_CAN_PRU0_BASE_ADDRESS	+	0x34)
#define PRU_CAN_RX_TIMING_REGISTER  				(PRU_CAN_PRU0_BASE_ADDRESS	+	0x38)
#define PRU_CAN_RX_CLOCK_BRP_REGISTER  				(PRU_CAN_PRU0_BASE_ADDRESS	+	0x3C)

#define PRU_CAN_RX_MAILBOX0	 						(PRU_CAN_PRU0_BASE_ADDRESS	+	0x40)
#define PRU_CAN_RX_MAILBOX1	 						(PRU_CAN_PRU0_BASE_ADDRESS 	+ 	0x50)
#define PRU_CAN_RX_MAILBOX2	 						(PRU_CAN_PRU0_BASE_ADDRESS 	+ 	0x60)
#define PRU_CAN_RX_MAILBOX3	 						(PRU_CAN_PRU0_BASE_ADDRESS 	+ 	0x70)
#define PRU_CAN_RX_MAILBOX4	 						(PRU_CAN_PRU0_BASE_ADDRESS 	+ 	0x80)
#define PRU_CAN_RX_MAILBOX5	 						(PRU_CAN_PRU0_BASE_ADDRESS 	+ 	0x90)
#define PRU_CAN_RX_MAILBOX6	 						(PRU_CAN_PRU0_BASE_ADDRESS 	+ 	0xA0)
#define PRU_CAN_RX_MAILBOX7	 						(PRU_CAN_PRU0_BASE_ADDRESS 	+ 	0xB0)
#define PRU_CAN_RX_MAILBOX8	 						(PRU_CAN_PRU0_BASE_ADDRESS	+	0xC0)

#define PRU_CAN_TIMING_VAL_RX						(PRU_CAN_PRU0_BASE_ADDRESS 	+ 	0xD0)
#define PRU_CAN_RECEIVE_FRAME						(PRU_CAN_PRU0_BASE_ADDRESS 	+ 	0xD4)
#define	PRU_CAN_ID_MAP								(PRU_CAN_PRU0_BASE_ADDRESS 	+ 	0xF0)

#define PRU_CAN_ERROR_ACTIVE					128

#define CAN_ACK_FAILED							0xE
#define CAN_ARBTR_FAIL							0xD
#define CAN_BIT_ERROR							0xC
#define	CAN_TRANSMISSION_SUCCESS				0xA

#define STD_DATA_FRAME							0x1
#define EXTD_DATA_FRAME							0x2
#define STD_REMOTE_FRAME						0x3
#define	EXTD_REMOTE_FRAME						0x4

#define PRU_CAN_MAX_SJW							8
#define PRU_CAN_MAX_PHSEG1						25
#define PRU_CAN_MAX_PHSEG2						25

#define CSL_PRUCANCORE_0_REGS						0x7000
#define CSL_PRUCANCORE_1_REGS						0x7800
#define PRU0_PROG_RAM_START_OFFSET						0x8000
#define PRU1_PROG_RAM_START_OFFSET						0xC000
#define PRU_CAN_INIT_MAX_TIMEOUT				0xFF


/* NOTE1
 *  * This is the superset list for all modules present in this family
 *   * Please refer to individual device datasheet to see which modules
 *    * apply on the device being used
 *     * e.g. c6747 does not have ARM module, so PSC0 CSL_PSC_ARM does not
 *      * exist for c6747                                                  */

/* NOTE2
 *  * The actual number of MDCTL and MDSTAT register depend on number of
 *   * LPSC modules in a PSC. The number of MDCTL/MDSTAT registers defined
 *    * here would be a superset
 *     * e.g. PSC0 has 16 MDCTL/MDSTAT register, PSC1 has 32 MDCTL/MDSTAT
 *      * registers                                                       */

/* NOTE3
 *  * Please refer to the device specific PSC user guide to see what
 *   *  register bit fields apply to individual registers
 *    *  e.g. For PSC0 MERRPR0 bits 14,15 exist but for PSC1 MERRPR0
 *     *  these bits are RESERVED                                        */

	typedef enum {
		CSL_PSC_CC0 = 0,
		CSL_PSC_TC0 = 1,
		CSL_PSC_TC1 = 2,
		CSL_PSC_EMIFA = 3,
		CSL_PSC_SPI0 = 4,
		CSL_PSC_MMCSD0 = 5,
		CSL_PSC_AINTC = 6,
		CSL_PSC_ARM_RAMROM = 7,
		CSL_PSC_UART0 = 9,
		CSL_PSC_SCR0_SS = 10,
		CSL_PSC_SCR1_SS = 11,
		CSL_PSC_SCR2_SS = 12,
		CSL_PSC_PRU = 13,
		CSL_PSC_ARM = 14,
		CSL_PSC_DSP = 15
	} CSL_Psc0Peripheral;

	typedef enum {
		CSL_PSC_CC1 = 0,
		CSL_PSC_USB0 = 1,
		CSL_PSC_USB1 = 2,
		CSL_PSC_GPIO = 3,
		CSL_PSC_UHPI = 4,
		CSL_PSC_EMAC = 5,
		CSL_PSC_DDR2_MDDR = 6,
		CSL_PSC_MCASP0 = 7,
		CSL_PSC_SATA = 8,
		CSL_PSC_VPIF = 9,
		CSL_PSC_SPI1 = 10,
		CSL_PSC_I2C1 = 11,
		CSL_PSC_UART1 = 12,
		CSL_PSC_UART2 = 13,
		CSL_PSC_MCBSP0 = 14,
		CSL_PSC_MCBSP1 = 15,
		CSL_PSC_LCDC = 16,
		CSL_PSC_EHRPWM = 17,
		CSL_PSC_MMCSD1 = 18,
		CSL_PSC_UPP = 19,
		CSL_PSC_ECAP0_1_2 = 20,
		CSL_PSC_TC2 = 21,
		CSL_PSC_SCRF0_SS = 24,
		CSL_PSC_SCRF1_SS = 25,
		CSL_PSC_SCRF2_SS = 26,
		CSL_PSC_SCRF6_SS = 27,
		CSL_PSC_SCRF7_SS = 28,
		CSL_PSC_SCRF8_SS = 29,
		CSL_PSC_BR_F7 = 30,
		CSL_PSC_SHRAM = 31
	} CSL_Psc1Peripheral;

/* the Field MaKe macro */
#define CSL_FMK(PER_REG_FIELD, val)                                         \
    (((val) << CSL_##PER_REG_FIELD##_SHIFT) & CSL_##PER_REG_FIELD##_MASK)

/* the Field EXTract macro */
#define CSL_FEXT(reg, PER_REG_FIELD)                                        \
    (((reg) & CSL_##PER_REG_FIELD##_MASK) >> CSL_##PER_REG_FIELD##_SHIFT)

/* the Field INSert macro */
#define CSL_FINS(reg, PER_REG_FIELD, val)                                   \
    ((reg) = ((reg) & ~CSL_##PER_REG_FIELD##_MASK)                          \
    | CSL_FMK(PER_REG_FIELD, val))

/* the "token" macros */

/* the Field MaKe (Token) macro */
#define CSL_FMKT(PER_REG_FIELD, TOKEN)                                      \
    CSL_FMK(PER_REG_FIELD, CSL_##PER_REG_FIELD##_##TOKEN)

/* the Field INSert (Token) macro */
#define CSL_FINST(reg, PER_REG_FIELD, TOKEN)                                \
    CSL_FINS((reg), PER_REG_FIELD, CSL_##PER_REG_FIELD##_##TOKEN)

/* the "raw" macros */

/* the Field MaKe (Raw) macro */
#define CSL_FMKR(msb, lsb, val)                                             \
    (((val) & ((1 << ((msb) - (lsb) + 1)) - 1)) << (lsb))

/* the Field EXTract (Raw) macro */
#define CSL_FEXTR(reg, msb, lsb)                                            \
    (((reg) >> (lsb)) & ((1 << ((msb) - (lsb) + 1)) - 1))

/* the Field INSert (Raw) macro */
#define CSL_FINSR(reg, msb, lsb, val)                                       \
    ((reg) = ((reg) &~ (((1 << ((msb) - (lsb) + 1)) - 1) << (lsb)))         \
    | CSL_FMKR(msb, lsb, val))

	typedef enum {

		ecaninst0 = 0,
		ecaninst1,
		ecanmaxinst
	} can_instance_enum;

	typedef enum {

		ecanmailbox0 = 0,
		ecanmailbox1,
		ecanmailbox2,
		ecanmailbox3,
		ecanmailbox4,
		ecanmailbox5,
		ecanmailbox6,
		ecanmailbox7
	} can_mailbox_number;

	typedef enum {

		ecandirectioninit = 0,
		ecantransmit,
		ecanreceive
	} can_transfer_direction;

	typedef struct {

		u16 u16extendedidentifier;
		u16 u16baseidentifier;
		u8 u8data7;
		u8 u8data6;
		u8 u8data5;
		u8 u8data4;
		u8 u8data3;
		u8 u8data2;
		u8 u8data1;
		u8 u8data0;
		u16 u16datalength;
		u16 u16crc;

	} can_mail_box_structure;

	typedef struct {

		can_transfer_direction ecantransferdirection;

	} can_mailbox_config;

	typedef struct {

		can_instance_enum ecaninstance;
		can_transfer_direction ecantransferdirection;
		can_mail_box_structure strcanmailbox;
		can_mailbox_number ecanmailboxnumber;
		u8 u8prunumber;
		u32 u32globalstatus;
		u32 u32interruptstatus;
		u32 u32mailboxstatus;

	} can_emulation_app_hndl;

	typedef struct {

		bool bcaninststate;
		can_transfer_direction ecantransferdirection;
		u32 u32apphandlerptr;

	} can_emulation_drv_inst;

	typedef struct {

		u8 u8syncjumpwidth;
		u8 u8phseg1;
		u8 u8phseg2;

	} can_bit_timing_consts;

	typedef struct {

		u32 *ptr_pru0;
		u32 *ptr_pru1;
		u32 u32_pru0_code_size;
		u32 u32_pru1_code_size;

	} pru_can_firmware_structure;


/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* CONTROL */

#define CSL_PRUCORE_CONTROL_PCRESETVAL_MASK (0xFFFF0000u)
#define CSL_PRUCORE_CONTROL_PCRESETVAL_SHIFT (0x00000010u)
#define CSL_PRUCORE_CONTROL_PCRESETVAL_RESETVAL (0x00000000u)

#define CSL_PRUCORE_CONTROL_RUNSTATE_MASK (0x00008000u)
#define CSL_PRUCORE_CONTROL_RUNSTATE_SHIFT (0x0000000Fu)
#define CSL_PRUCORE_CONTROL_RUNSTATE_RESETVAL (0x00000000u)
/*----RUNSTATE Tokens----*/
#define CSL_PRUCORE_CONTROL_RUNSTATE_HALT (0x00000000u)
#define CSL_PRUCORE_CONTROL_RUNSTATE_RUN (0x00000001u)

#define CSL_PRUCORE_CONTROL_SINGLESTEP_MASK (0x00000100u)
#define CSL_PRUCORE_CONTROL_SINGLESTEP_SHIFT (0x00000008u)
#define CSL_PRUCORE_CONTROL_SINGLESTEP_RESETVAL (0x00000000u)
/*----SINGLESTEP Tokens----*/
#define CSL_PRUCORE_CONTROL_SINGLESTEP_FREERUN (0x00000000u)
#define CSL_PRUCORE_CONTROL_SINGLESTEP_SINGLE (0x00000001u)

#define CSL_PRUCORE_CONTROL_COUNTENABLE_MASK (0x00000008u)
#define CSL_PRUCORE_CONTROL_COUNTENABLE_SHIFT (0x00000003u)
#define CSL_PRUCORE_CONTROL_COUNTENABLE_RESETVAL (0x00000000u)
/*----COUNTENABLE Tokens----*/
#define CSL_PRUCORE_CONTROL_COUNTENABLE_DISABLE (0x00000000u)
#define CSL_PRUCORE_CONTROL_COUNTENABLE_ENABLE (0x00000001u)

#define CSL_PRUCORE_CONTROL_SLEEPING_MASK (0x00000004u)
#define CSL_PRUCORE_CONTROL_SLEEPING_SHIFT (0x00000002u)
#define CSL_PRUCORE_CONTROL_SLEEPING_RESETVAL (0x00000000u)
/*----SLEEPING Tokens----*/
#define CSL_PRUCORE_CONTROL_SLEEPING_NOTASLEEP (0x00000000u)
#define CSL_PRUCORE_CONTROL_SLEEPING_ASLEEP (0x00000001u)

#define CSL_PRUCORE_CONTROL_ENABLE_MASK  (0x00000002u)
#define CSL_PRUCORE_CONTROL_ENABLE_SHIFT (0x00000001u)
#define CSL_PRUCORE_CONTROL_ENABLE_RESETVAL (0x00000000u)
/*----ENABLE Tokens----*/
#define CSL_PRUCORE_CONTROL_ENABLE_DISABLE (0x00000000u)
#define CSL_PRUCORE_CONTROL_ENABLE_ENABLE (0x00000001u)

#define CSL_PRUCORE_CONTROL_SOFTRESET_MASK (0x00000001u)
#define CSL_PRUCORE_CONTROL_SOFTRESET_SHIFT (0x00000000u)
#define CSL_PRUCORE_CONTROL_SOFTRESET_RESETVAL (0x00000000u)
/*----SOFTRESET Tokens----*/
#define CSL_PRUCORE_CONTROL_SOFTRESET_RESET (0x00000000u)
#define CSL_PRUCORE_CONTROL_SOFTRESET_OUT_OF_RESET (0x00000001u)

#define CSL_PRUCORE_CONTROL_RESETVAL     (0x00000000u)

/* STATUS */

#define CSL_PRUCORE_STATUS_PCOUNTER_MASK (0x0000FFFFu)
#define CSL_PRUCORE_STATUS_PCOUNTER_SHIFT (0x00000000u)
#define CSL_PRUCORE_STATUS_PCOUNTER_RESETVAL (0x00000000u)

#define CSL_PRUCORE_STATUS_RESETVAL      (0x00000000u)

/* WAKEUP */

#define CSL_PRUCORE_WAKEUP_BITWISEENABLES_MASK (0xFFFFFFFFu)
#define CSL_PRUCORE_WAKEUP_BITWISEENABLES_SHIFT (0x00000000u)
#define CSL_PRUCORE_WAKEUP_BITWISEENABLES_RESETVAL (0x00000000u)

#define CSL_PRUCORE_WAKEUP_RESETVAL      (0x00000000u)

/* CYCLECNT */

#define CSL_PRUCORE_CYCLECNT_CYCLECOUNT_MASK (0xFFFFFFFFu)
#define CSL_PRUCORE_CYCLECNT_CYCLECOUNT_SHIFT (0x00000000u)
#define CSL_PRUCORE_CYCLECNT_CYCLECOUNT_RESETVAL (0x00000000u)

#define CSL_PRUCORE_CYCLECNT_RESETVAL    (0x00000000u)

/* STALLCNT */

#define CSL_PRUCORE_STALLCNT_STALLCOUNT_MASK (0xFFFFFFFFu)
#define CSL_PRUCORE_STALLCNT_STALLCOUNT_SHIFT (0x00000000u)
#define CSL_PRUCORE_STALLCNT_STALLCOUNT_RESETVAL (0x00000000u)

#define CSL_PRUCORE_STALLCNT_RESETVAL    (0x00000000u)

/* CONTABBLKIDX0 */

#define CSL_PRUCORE_CONTABBLKIDX0_C25_MASK (0x000F0000u)
#define CSL_PRUCORE_CONTABBLKIDX0_C25_SHIFT (0x00000010u)
#define CSL_PRUCORE_CONTABBLKIDX0_C25_RESETVAL (0x00000000u)

#define CSL_PRUCORE_CONTABBLKIDX0_C24_MASK (0x0000000Fu)
#define CSL_PRUCORE_CONTABBLKIDX0_C24_SHIFT (0x00000000u)
#define CSL_PRUCORE_CONTABBLKIDX0_C24_RESETVAL (0x00000000u)

#define CSL_PRUCORE_CONTABBLKIDX0_RESETVAL (0x00000000u)

/* CONTABBLKIDX1 */

#define CSL_PRUCORE_CONTABBLKIDX1_C27_MASK (0x000F0000u)
#define CSL_PRUCORE_CONTABBLKIDX1_C27_SHIFT (0x00000010u)
#define CSL_PRUCORE_CONTABBLKIDX1_C27_RESETVAL (0x00000000u)

#define CSL_PRUCORE_CONTABBLKIDX1_C26_MASK (0x0000000Fu)
#define CSL_PRUCORE_CONTABBLKIDX1_C26_SHIFT (0x00000000u)
#define CSL_PRUCORE_CONTABBLKIDX1_C26_RESETVAL (0x00000000u)

#define CSL_PRUCORE_CONTABBLKIDX1_RESETVAL (0x00000000u)

/* CONTABPROPTR0 */

#define CSL_PRUCORE_CONTABPROPTR0_C29_MASK (0xFFFF0000u)
#define CSL_PRUCORE_CONTABPROPTR0_C29_SHIFT (0x00000010u)
#define CSL_PRUCORE_CONTABPROPTR0_C29_RESETVAL (0x00000000u)

#define CSL_PRUCORE_CONTABPROPTR0_C28_MASK (0x0000FFFFu)
#define CSL_PRUCORE_CONTABPROPTR0_C28_SHIFT (0x00000000u)
#define CSL_PRUCORE_CONTABPROPTR0_C28_RESETVAL (0x00000000u)

#define CSL_PRUCORE_CONTABPROPTR0_RESETVAL (0x00000000u)

/* CONTABPROPTR1 */

#define CSL_PRUCORE_CONTABPROPTR1_C31_MASK (0xFFFF0000u)
#define CSL_PRUCORE_CONTABPROPTR1_C31_SHIFT (0x00000010u)
#define CSL_PRUCORE_CONTABPROPTR1_C31_RESETVAL (0x00000000u)

#define CSL_PRUCORE_CONTABPROPTR1_C30_MASK (0x0000FFFFu)
#define CSL_PRUCORE_CONTABPROPTR1_C30_SHIFT (0x00000000u)
#define CSL_PRUCORE_CONTABPROPTR1_C30_RESETVAL (0x00000000u)

#define CSL_PRUCORE_CONTABPROPTR1_RESETVAL (0x00000000u)

/* INTGPR0 */

#define CSL_PRUCORE_INTGPR0_REG_MASK     (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR0_REG_SHIFT    (0x00000000u)
#define CSL_PRUCORE_INTGPR0_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR0_RESETVAL     (0x00000000u)

/* INTGPR1 */

#define CSL_PRUCORE_INTGPR1_REG_MASK     (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR1_REG_SHIFT    (0x00000000u)
#define CSL_PRUCORE_INTGPR1_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR1_RESETVAL     (0x00000000u)

/* INTGPR2 */

#define CSL_PRUCORE_INTGPR2_REG_MASK     (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR2_REG_SHIFT    (0x00000000u)
#define CSL_PRUCORE_INTGPR2_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR2_RESETVAL     (0x00000000u)

/* INTGPR3 */

#define CSL_PRUCORE_INTGPR3_REG_MASK     (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR3_REG_SHIFT    (0x00000000u)
#define CSL_PRUCORE_INTGPR3_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR3_RESETVAL     (0x00000000u)

/* INTGPR4 */

#define CSL_PRUCORE_INTGPR4_REG_MASK     (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR4_REG_SHIFT    (0x00000000u)
#define CSL_PRUCORE_INTGPR4_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR4_RESETVAL     (0x00000000u)

/* INTGPR5 */

#define CSL_PRUCORE_INTGPR5_REG_MASK     (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR5_REG_SHIFT    (0x00000000u)
#define CSL_PRUCORE_INTGPR5_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR5_RESETVAL     (0x00000000u)

/* INTGPR6 */

#define CSL_PRUCORE_INTGPR6_REG_MASK     (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR6_REG_SHIFT    (0x00000000u)
#define CSL_PRUCORE_INTGPR6_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR6_RESETVAL     (0x00000000u)

/* INTGPR7 */

#define CSL_PRUCORE_INTGPR7_REG_MASK     (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR7_REG_SHIFT    (0x00000000u)
#define CSL_PRUCORE_INTGPR7_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR7_RESETVAL     (0x00000000u)

/* INTGPR8 */

#define CSL_PRUCORE_INTGPR8_REG_MASK     (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR8_REG_SHIFT    (0x00000000u)
#define CSL_PRUCORE_INTGPR8_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR8_RESETVAL     (0x00000000u)

/* INTGPR9 */

#define CSL_PRUCORE_INTGPR9_REG_MASK     (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR9_REG_SHIFT    (0x00000000u)
#define CSL_PRUCORE_INTGPR9_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR9_RESETVAL     (0x00000000u)

/* INTGPR10 */

#define CSL_PRUCORE_INTGPR10_REG_MASK    (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR10_REG_SHIFT   (0x00000000u)
#define CSL_PRUCORE_INTGPR10_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR10_RESETVAL    (0x00000000u)

/* INTGPR11 */

#define CSL_PRUCORE_INTGPR11_REG_MASK    (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR11_REG_SHIFT   (0x00000000u)
#define CSL_PRUCORE_INTGPR11_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR11_RESETVAL    (0x00000000u)

/* INTGPR12 */

#define CSL_PRUCORE_INTGPR12_REG_MASK    (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR12_REG_SHIFT   (0x00000000u)
#define CSL_PRUCORE_INTGPR12_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR12_RESETVAL    (0x00000000u)

/* INTGPR13 */

#define CSL_PRUCORE_INTGPR13_REG_MASK    (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR13_REG_SHIFT   (0x00000000u)
#define CSL_PRUCORE_INTGPR13_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR13_RESETVAL    (0x00000000u)

/* INTGPR14 */

#define CSL_PRUCORE_INTGPR14_REG_MASK    (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR14_REG_SHIFT   (0x00000000u)
#define CSL_PRUCORE_INTGPR14_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR14_RESETVAL    (0x00000000u)

/* INTGPR15 */

#define CSL_PRUCORE_INTGPR15_REG_MASK    (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR15_REG_SHIFT   (0x00000000u)
#define CSL_PRUCORE_INTGPR15_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR15_RESETVAL    (0x00000000u)

/* INTGPR16 */

#define CSL_PRUCORE_INTGPR16_REG_MASK    (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR16_REG_SHIFT   (0x00000000u)
#define CSL_PRUCORE_INTGPR16_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR16_RESETVAL    (0x00000000u)

/* INTGPR17 */

#define CSL_PRUCORE_INTGPR17_REG_MASK    (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR17_REG_SHIFT   (0x00000000u)
#define CSL_PRUCORE_INTGPR17_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR17_RESETVAL    (0x00000000u)

/* INTGPR18 */

#define CSL_PRUCORE_INTGPR18_REG_MASK    (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR18_REG_SHIFT   (0x00000000u)
#define CSL_PRUCORE_INTGPR18_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR18_RESETVAL    (0x00000000u)

/* INTGPR19 */

#define CSL_PRUCORE_INTGPR19_REG_MASK    (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR19_REG_SHIFT   (0x00000000u)
#define CSL_PRUCORE_INTGPR19_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR19_RESETVAL    (0x00000000u)

/* INTGPR20 */

#define CSL_PRUCORE_INTGPR20_REG_MASK    (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR20_REG_SHIFT   (0x00000000u)
#define CSL_PRUCORE_INTGPR20_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR20_RESETVAL    (0x00000000u)

/* INTGPR21 */

#define CSL_PRUCORE_INTGPR21_REG_MASK    (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR21_REG_SHIFT   (0x00000000u)
#define CSL_PRUCORE_INTGPR21_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR21_RESETVAL    (0x00000000u)

/* INTGPR22 */

#define CSL_PRUCORE_INTGPR22_REG_MASK    (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR22_REG_SHIFT   (0x00000000u)
#define CSL_PRUCORE_INTGPR22_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR22_RESETVAL    (0x00000000u)

/* INTGPR23 */

#define CSL_PRUCORE_INTGPR23_REG_MASK    (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR23_REG_SHIFT   (0x00000000u)
#define CSL_PRUCORE_INTGPR23_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR23_RESETVAL    (0x00000000u)

/* INTGPR24 */

#define CSL_PRUCORE_INTGPR24_REG_MASK    (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR24_REG_SHIFT   (0x00000000u)
#define CSL_PRUCORE_INTGPR24_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR24_RESETVAL    (0x00000000u)

/* INTGPR25 */

#define CSL_PRUCORE_INTGPR25_REG_MASK    (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR25_REG_SHIFT   (0x00000000u)
#define CSL_PRUCORE_INTGPR25_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR25_RESETVAL    (0x00000000u)

/* INTGPR26 */

#define CSL_PRUCORE_INTGPR26_REG_MASK    (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR26_REG_SHIFT   (0x00000000u)
#define CSL_PRUCORE_INTGPR26_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR26_RESETVAL    (0x00000000u)

/* INTGPR27 */

#define CSL_PRUCORE_INTGPR27_REG_MASK    (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR27_REG_SHIFT   (0x00000000u)
#define CSL_PRUCORE_INTGPR27_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR27_RESETVAL    (0x00000000u)

/* INTGPR28 */

#define CSL_PRUCORE_INTGPR28_REG_MASK    (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR28_REG_SHIFT   (0x00000000u)
#define CSL_PRUCORE_INTGPR28_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR28_RESETVAL    (0x00000000u)

/* INTGPR29 */

#define CSL_PRUCORE_INTGPR29_REG_MASK    (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR29_REG_SHIFT   (0x00000000u)
#define CSL_PRUCORE_INTGPR29_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR29_RESETVAL    (0x00000000u)

/* INTGPR30 */

#define CSL_PRUCORE_INTGPR30_REG_MASK    (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR30_REG_SHIFT   (0x00000000u)
#define CSL_PRUCORE_INTGPR30_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR30_RESETVAL    (0x00000000u)

/* INTGPR31 */

#define CSL_PRUCORE_INTGPR31_REG_MASK    (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR31_REG_SHIFT   (0x00000000u)
#define CSL_PRUCORE_INTGPR31_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR31_RESETVAL    (0x00000000u)

/* INTCTER0 */

#define CSL_PRUCORE_INTCTER0_ENTRY_MASK  (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER0_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER0_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER0_RESETVAL    (0x00000000u)

/* INTCTER1 */

#define CSL_PRUCORE_INTCTER1_ENTRY_MASK  (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER1_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER1_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER1_RESETVAL    (0x00000000u)

/* INTCTER2 */

#define CSL_PRUCORE_INTCTER2_ENTRY_MASK  (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER2_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER2_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER2_RESETVAL    (0x00000000u)

/* INTCTER3 */

#define CSL_PRUCORE_INTCTER3_ENTRY_MASK  (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER3_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER3_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER3_RESETVAL    (0x00000000u)

/* INTCTER4 */

#define CSL_PRUCORE_INTCTER4_ENTRY_MASK  (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER4_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER4_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER4_RESETVAL    (0x00000000u)

/* INTCTER5 */

#define CSL_PRUCORE_INTCTER5_ENTRY_MASK  (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER5_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER5_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER5_RESETVAL    (0x00000000u)

/* INTCTER6 */

#define CSL_PRUCORE_INTCTER6_ENTRY_MASK  (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER6_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER6_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER6_RESETVAL    (0x00000000u)

/* INTCTER7 */

#define CSL_PRUCORE_INTCTER7_ENTRY_MASK  (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER7_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER7_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER7_RESETVAL    (0x00000000u)

/* INTCTER8 */

#define CSL_PRUCORE_INTCTER8_ENTRY_MASK  (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER8_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER8_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER8_RESETVAL    (0x00000000u)

/* INTCTER9 */

#define CSL_PRUCORE_INTCTER9_ENTRY_MASK  (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER9_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER9_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER9_RESETVAL    (0x00000000u)

/* INTCTER10 */

#define CSL_PRUCORE_INTCTER10_ENTRY_MASK (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER10_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER10_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER10_RESETVAL   (0x00000000u)

/* INTCTER11 */

#define CSL_PRUCORE_INTCTER11_ENTRY_MASK (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER11_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER11_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER11_RESETVAL   (0x00000000u)

/* INTCTER12 */

#define CSL_PRUCORE_INTCTER12_ENTRY_MASK (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER12_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER12_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER12_RESETVAL   (0x00000000u)

/* INTCTER13 */

#define CSL_PRUCORE_INTCTER13_ENTRY_MASK (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER13_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER13_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER13_RESETVAL   (0x00000000u)

/* INTCTER14 */

#define CSL_PRUCORE_INTCTER14_ENTRY_MASK (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER14_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER14_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER14_RESETVAL   (0x00000000u)

/* INTCTER15 */

#define CSL_PRUCORE_INTCTER15_ENTRY_MASK (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER15_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER15_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER15_RESETVAL   (0x00000000u)

/* INTCTER16 */

#define CSL_PRUCORE_INTCTER16_ENTRY_MASK (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER16_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER16_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER16_RESETVAL   (0x00000000u)

/* INTCTER17 */

#define CSL_PRUCORE_INTCTER17_ENTRY_MASK (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER17_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER17_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER17_RESETVAL   (0x00000000u)

/* INTCTER18 */

#define CSL_PRUCORE_INTCTER18_ENTRY_MASK (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER18_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER18_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER18_RESETVAL   (0x00000000u)

/* INTCTER19 */

#define CSL_PRUCORE_INTCTER19_ENTRY_MASK (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER19_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER19_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER19_RESETVAL   (0x00000000u)

/* INTCTER20 */

#define CSL_PRUCORE_INTCTER20_ENTRY_MASK (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER20_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER20_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER20_RESETVAL   (0x00000000u)

/* INTCTER21 */

#define CSL_PRUCORE_INTCTER21_ENTRY_MASK (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER21_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER21_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER21_RESETVAL   (0x00000000u)

/* INTCTER22 */

#define CSL_PRUCORE_INTCTER22_ENTRY_MASK (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER22_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER22_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER22_RESETVAL   (0x00000000u)

/* INTCTER23 */

#define CSL_PRUCORE_INTCTER23_ENTRY_MASK (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER23_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER23_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER23_RESETVAL   (0x00000000u)

/* INTCTER24 */

#define CSL_PRUCORE_INTCTER24_ENTRY_MASK (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER24_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER24_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER24_RESETVAL   (0x00000000u)

/* INTCTER25 */

#define CSL_PRUCORE_INTCTER25_ENTRY_MASK (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER25_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER25_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER25_RESETVAL   (0x00000000u)

/* INTCTER26 */

#define CSL_PRUCORE_INTCTER26_ENTRY_MASK (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER26_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER26_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER26_RESETVAL   (0x00000000u)

/* INTCTER27 */

#define CSL_PRUCORE_INTCTER27_ENTRY_MASK (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER27_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER27_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER27_RESETVAL   (0x00000000u)

/* INTCTER28 */

#define CSL_PRUCORE_INTCTER28_ENTRY_MASK (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER28_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER28_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER28_RESETVAL   (0x00000000u)

/* INTCTER29 */

#define CSL_PRUCORE_INTCTER29_ENTRY_MASK (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER29_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER29_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER29_RESETVAL   (0x00000000u)

/* INTCTER30 */

#define CSL_PRUCORE_INTCTER30_ENTRY_MASK (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER30_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER30_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER30_RESETVAL   (0x00000000u)

/* INTCTER31 */

#define CSL_PRUCORE_INTCTER31_ENTRY_MASK (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER31_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER31_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER31_RESETVAL   (0x00000000u)

/**************************************** PSC ************************************************/
/*******************************************************************************************/

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
	typedef struct {
		volatile u32 REVID;
		volatile u8 RSVD0[20];
		volatile u32 INTEVAL;
		volatile u8 RSVD1[36];
		volatile u32 MERRPR0;
		volatile u8 RSVD2[12];
		volatile u32 MERRCR0;
		volatile u8 RSVD3[12];
		volatile u32 PERRPR;
		volatile u8 RSVD4[4];
		volatile u32 PERRCR;
		volatile u8 RSVD5[180];
		volatile u32 PTCMD;
		volatile u8 RSVD6[4];
		volatile u32 PTSTAT;
		volatile u8 RSVD7[212];
		volatile u32 PDSTAT0;
		volatile u32 PDSTAT1;
		volatile u8 RSVD8[248];
		volatile u32 PDCTL0;
		volatile u32 PDCTL1;
		volatile u8 RSVD9[248];
		volatile u32 PDCFG0;
		volatile u32 PDCFG1;
		volatile u8 RSVD10[1016];
		volatile u32 MDSTAT[32];
		volatile u8 RSVD11[384];
		volatile u32 MDCTL[32];
	} CSL_PscRegs;

/**************************************************************************\
* Overlay structure typedef definition
\**************************************************************************/
	typedef volatile CSL_PscRegs *CSL_PscRegsOvly;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* REVID */

#define CSL_PSC_REVID_REV_MASK             (0xFFFFFFFFu)
#define CSL_PSC_REVID_REV_SHIFT            (0x00000000u)
#define CSL_PSC_REVID_REV_RESETVAL         (0x44823A00u)

#define CSL_PSC_REVID_RESETVAL             (0x44823A00u)

/* INTEVAL */

#define CSL_PSC_INTEVAL_ALLEV_MASK      (0x00000001u)
#define CSL_PSC_INTEVAL_ALLEV_SHIFT     (0x00000000u)
#define CSL_PSC_INTEVAL_ALLEV_RESETVAL  (0x00000000u)
/*----ALLEV Tokens----*/
#define CSL_PSC_INTEVAL_ALLEV_NO_EFFECT (0x00000000u)
#define CSL_PSC_INTEVAL_ALLEV_RE_EVALUATE (0x00000001u)

#define CSL_PSC_INTEVAL_RESETVAL        (0x00000000u)

/* MERRPR0 */

#define CSL_PSC_MERRPR0_M15_MASK        (0x0000C000u)
#define CSL_PSC_MERRPR0_M15_SHIFT       (0x0000000Eu)
#define CSL_PSC_MERRPR0_M15_RESETVAL    (0x00000000u)
/*----M15 Tokens----*/
#define CSL_PSC_MERRPR0_M15_NO_ERR      (0x00000000u)
#define CSL_PSC_MERRPR0_M15_ERROR       (0x00000001u)

#define CSL_PSC_MERRPR0_M14_MASK        (0x00006000u)
#define CSL_PSC_MERRPR0_M14_SHIFT       (0x0000000Du)
#define CSL_PSC_MERRPR0_M14_RESETVAL    (0x00000000u)
/*----M14 Tokens----*/
#define CSL_PSC_MERRPR0_M14_NO_ERR      (0x00000000u)
#define CSL_PSC_MERRPR0_M14_ERROR       (0x00000001u)

#define CSL_PSC_MERRPR0_RESETVAL        (0x00000000u)

/* MERRCR0 */

#define CSL_PSC_MERRCR0_M15_MASK        (0x0000C000u)
#define CSL_PSC_MERRCR0_M15_SHIFT       (0x0000000Eu)
#define CSL_PSC_MERRCR0_M15_RESETVAL    (0x00000000u)
/*----M15 Tokens----*/
#define CSL_PSC_MERRCR0_M15_NO_EFFECT   (0x00000000u)
#define CSL_PSC_MERRCR0_M15_CLR_ERR     (0x00000001u)

#define CSL_PSC_MERRCR0_M14_MASK        (0x00006000u)
#define CSL_PSC_MERRCR0_M14_SHIFT       (0x0000000Du)
#define CSL_PSC_MERRCR0_M14_RESETVAL    (0x00000000u)
/*----M14 Tokens----*/
#define CSL_PSC_MERRCR0_M14_NO_EFFECT   (0x00000000u)
#define CSL_PSC_MERRCR0_M14_CLR_ERR     (0x00000001u)

#define CSL_PSC_MERRCR0_RESETVAL        (0x00000000u)

/* PERRPR */

#define CSL_PSC_PERRPR_P1_MASK          (0x00000002u)
#define CSL_PSC_PERRPR_P1_SHIFT         (0x00000001u)
#define CSL_PSC_PERRPR_P1_RESETVAL      (0x00000000u)
/*----P1 Tokens----*/
#define CSL_PSC_PERRPR_P1_NO_ERR        (0x00000000u)
#define CSL_PSC_PERRPR_P1_ERROR         (0x00000001u)

#define CSL_PSC_PERRPR_P0_MASK          (0x00000001u)
#define CSL_PSC_PERRPR_P0_SHIFT         (0x00000000u)
#define CSL_PSC_PERRPR_P0_RESETVAL      (0x00000000u)
/*----P0 Tokens----*/
#define CSL_PSC_PERRPR_P0_NO_ERR        (0x00000000u)
#define CSL_PSC_PERRPR_P0_ERROR         (0x00000001u)

#define CSL_PSC_PERRPR_RESETVAL         (0x00000000u)

/* PERRCR */

#define CSL_PSC_PERRCR_P1_MASK          (0x00000002u)
#define CSL_PSC_PERRCR_P1_SHIFT         (0x00000001u)
#define CSL_PSC_PERRCR_P1_RESETVAL      (0x00000000u)
/*----P1 Tokens----*/
#define CSL_PSC_PERRCR_P1_NO_EFFECT     (0x00000000u)
#define CSL_PSC_PERRCR_P1_CLR_ERR       (0x00000001u)

#define CSL_PSC_PERRCR_P0_MASK          (0x00000001u)
#define CSL_PSC_PERRCR_P0_SHIFT         (0x00000000u)
#define CSL_PSC_PERRCR_P0_RESETVAL      (0x00000000u)
/*----P0 Tokens----*/
#define CSL_PSC_PERRCR_P0_NO_EFFECT     (0x00000000u)
#define CSL_PSC_PERRCR_P0_CLR_ERR       (0x00000001u)

#define CSL_PSC_PERRCR_RESETVAL         (0x00000000u)

/* PTCMD */

#define CSL_PSC_PTCMD_GO1_MASK          (0x00000002u)
#define CSL_PSC_PTCMD_GO1_SHIFT         (0x00000001u)
#define CSL_PSC_PTCMD_GO1_RESETVAL      (0x00000000u)
/*----GO1 Tokens----*/
#define CSL_PSC_PTCMD_GO1_NO_EFFECT     (0x00000000u)
#define CSL_PSC_PTCMD_GO1_SET           (0x00000001u)

#define CSL_PSC_PTCMD_GO0_MASK          (0x00000001u)
#define CSL_PSC_PTCMD_GO0_SHIFT         (0x00000000u)
#define CSL_PSC_PTCMD_GO0_RESETVAL      (0x00000000u)
/*----GO0 Tokens----*/
#define CSL_PSC_PTCMD_GO0_NO_EFFECT     (0x00000000u)
#define CSL_PSC_PTCMD_GO0_SET           (0x00000001u)

#define CSL_PSC_PTCMD_RESETVAL          (0x00000000u)

/* PTSTAT */

#define CSL_PSC_PTSTAT_GOSTAT1_MASK     (0x00000002u)
#define CSL_PSC_PTSTAT_GOSTAT1_SHIFT    (0x00000001u)
#define CSL_PSC_PTSTAT_GOSTAT1_RESETVAL (0x00000000u)
/*----GOSTAT1 Tokens----*/
#define CSL_PSC_PTSTAT_GOSTAT1_NO_TRANSITION (0x00000000u)
#define CSL_PSC_PTSTAT_GOSTAT1_IN_TRANSITION (0x00000001u)

#define CSL_PSC_PTSTAT_GOSTAT0_MASK     (0x00000001u)
#define CSL_PSC_PTSTAT_GOSTAT0_SHIFT    (0x00000000u)
#define CSL_PSC_PTSTAT_GOSTAT0_RESETVAL (0x00000000u)
/*----GOSTAT0 Tokens----*/
#define CSL_PSC_PTSTAT_GOSTAT0_NO_TRANSITION (0x00000000u)
#define CSL_PSC_PTSTAT_GOSTAT0_IN_TRANSITION (0x00000001u)

#define CSL_PSC_PTSTAT_RESETVAL         (0x00000000u)

/* PDSTAT0 */

#define CSL_PSC_PDSTAT0_EMUIHB_MASK     (0x00000800u)
#define CSL_PSC_PDSTAT0_EMUIHB_SHIFT    (0x0000000Bu)
#define CSL_PSC_PDSTAT0_EMUIHB_RESETVAL (0x00000000u)
/*----EMUIHB Tokens----*/
#define CSL_PSC_PDSTAT0_EMUIHB_INHIBIT_OFF (0x00000000u)
#define CSL_PSC_PDSTAT0_EMUIHB_INHIBIT_ON (0x00000001u)

#define CSL_PSC_PDSTAT0_STATE_MASK      (0x0000001Fu)
#define CSL_PSC_PDSTAT0_STATE_SHIFT     (0x00000000u)
#define CSL_PSC_PDSTAT0_STATE_RESETVAL  (0x00000000u)
/*----STATE Tokens----*/
#define CSL_PSC_PDSTAT0_STATE_OFF       (0x00000000u)
#define CSL_PSC_PDSTAT0_STATE_ON        (0x00000001u)

#define CSL_PSC_PDSTAT0_RESETVAL        (0x00000000u)

/* PDSTAT1 */

#define CSL_PSC_PDSTAT1_EMUIHB_MASK     (0x00000800u)
#define CSL_PSC_PDSTAT1_EMUIHB_SHIFT    (0x0000000Bu)
#define CSL_PSC_PDSTAT1_EMUIHB_RESETVAL (0x00000000u)
/*----EMUIHB Tokens----*/
#define CSL_PSC_PDSTAT1_EMUIHB_INHIBIT_OFF (0x00000000u)
#define CSL_PSC_PDSTAT1_EMUIHB_INHIBIT_ON (0x00000001u)

#define CSL_PSC_PDSTAT1_STATE_MASK      (0x0000001Fu)
#define CSL_PSC_PDSTAT1_STATE_SHIFT     (0x00000000u)
#define CSL_PSC_PDSTAT1_STATE_RESETVAL  (0x00000000u)
/*----STATE Tokens----*/
#define CSL_PSC_PDSTAT1_STATE_OFF       (0x00000000u)
#define CSL_PSC_PDSTAT1_STATE_ON        (0x00000001u)

#define CSL_PSC_PDSTAT1_RESETVAL        (0x00000000u)

/* PDCTL0 */

#define CSL_PSC_PDCTL0_WAKECNT_MASK     (0x00FF0000u)
#define CSL_PSC_PDCTL0_WAKECNT_SHIFT    (0x00000010u)
#define CSL_PSC_PDCTL0_WAKECNT_RESETVAL (0x0000001Fu)

#define CSL_PSC_PDCTL0_PDMODE_MASK      (0x0000F000u)
#define CSL_PSC_PDCTL0_PDMODE_SHIFT     (0x0000000Cu)
#define CSL_PSC_PDCTL0_PDMODE_RESETVAL  (0x0000000Fu)

#define CSL_PSC_PDCTL0_EMUIHBIE_MASK    (0x00000200u)
#define CSL_PSC_PDCTL0_EMUIHBIE_SHIFT   (0x00000009u)
#define CSL_PSC_PDCTL0_EMUIHBIE_RESETVAL (0x00000000u)
/*----EMUIHBIE Tokens----*/
#define CSL_PSC_PDCTL0_EMUIHBIE_DISABLE (0x00000000u)
#define CSL_PSC_PDCTL0_EMUIHBIE_ENABLE  (0x00000001u)

#define CSL_PSC_PDCTL0_NEXT_MASK        (0x00000001u)
#define CSL_PSC_PDCTL0_NEXT_SHIFT       (0x00000000u)
#define CSL_PSC_PDCTL0_NEXT_RESETVAL    (0x00000001u)
/*----NEXT Tokens----*/
#define CSL_PSC_PDCTL0_NEXT_OFF         (0x00000000u)
#define CSL_PSC_PDCTL0_NEXT_ON          (0x00000001u)

#define CSL_PSC_PDCTL0_RESETVAL         (0x001FF101u)

/* PDCTL1 */

#define CSL_PSC_PDCTL1_WAKECNT_MASK     (0x00FF0000u)
#define CSL_PSC_PDCTL1_WAKECNT_SHIFT    (0x00000010u)
#define CSL_PSC_PDCTL1_WAKECNT_RESETVAL (0x0000001Fu)

#define CSL_PSC_PDCTL1_PDMODE_MASK      (0x0000F000u)
#define CSL_PSC_PDCTL1_PDMODE_SHIFT     (0x0000000Cu)
#define CSL_PSC_PDCTL1_PDMODE_RESETVAL  (0x0000000Fu)
/*----PDMODE Tokens----*/
#define CSL_PSC_PDCTL1_PDMODE_OFF       (0x00000000u)
#define CSL_PSC_PDCTL1_PDMODE_RAM_OFF   (0x00000008u)
#define CSL_PSC_PDCTL1_PDMODE_DEEP_SLEEP (0x00000009u)
#define CSL_PSC_PDCTL1_PDMODE_LIGHT_SLEEP (0x0000000Au)
#define CSL_PSC_PDCTL1_PDMODE_RETENTION (0x0000000Bu)
#define CSL_PSC_PDCTL1_PDMODE_ON        (0x0000000Fu)

#define CSL_PSC_PDCTL1_EMUIHBIE_MASK    (0x00000200u)
#define CSL_PSC_PDCTL1_EMUIHBIE_SHIFT   (0x00000009u)
#define CSL_PSC_PDCTL1_EMUIHBIE_RESETVAL (0x00000000u)
/*----EMUIHBIE Tokens----*/
#define CSL_PSC_PDCTL1_EMUIHBIE_DISABLE (0x00000000u)
#define CSL_PSC_PDCTL1_EMUIHBIE_ENABLE  (0x00000001u)

#define CSL_PSC_PDCTL1_NEXT_MASK        (0x00000001u)
#define CSL_PSC_PDCTL1_NEXT_SHIFT       (0x00000000u)
#define CSL_PSC_PDCTL1_NEXT_RESETVAL    (0x00000001u)
/*----NEXT Tokens----*/
#define CSL_PSC_PDCTL1_NEXT_OFF         (0x00000000u)
#define CSL_PSC_PDCTL1_NEXT_ON          (0x00000001u)

#define CSL_PSC_PDCTL1_RESETVAL         (0x001FF101u)

/* PDCFG0 */

#define CSL_PSC_PDCFG0_PDLOCK_MASK      (0x00000008u)
#define CSL_PSC_PDCFG0_PDLOCK_SHIFT     (0x00000003u)
#define CSL_PSC_PDCFG0_PDLOCK_RESETVAL  (0x00000001u)
/*----PD LOCK Tokens----*/
#define CSL_PSC_PDCFG0_PDLOCK_YES       (0x00000000u)
#define CSL_PSC_PDCFG0_PDLOCK_NO        (0x00000001u)

#define CSL_PSC_PDCFG0_ICEPICK_MASK     (0x00000004u)
#define CSL_PSC_PDCFG0_ICEPICK_SHIFT    (0x00000002u)
#define CSL_PSC_PDCFG0_ICEPICK_RESETVAL (0x00000001u)
/*----ICEPICK Tokens----*/
#define CSL_PSC_PDCFG0_ICEPICK_ABSENT   (0x00000000u)
#define CSL_PSC_PDCFG0_ICEPICK_PRESENT  (0x00000001u)

#define CSL_PSC_PDCFG0_RAM_PSM_MASK     (0x00000002u)
#define CSL_PSC_PDCFG0_RAM_PSM_SHIFT    (0x00000001u)
#define CSL_PSC_PDCFG0_RAM_PSM_RESETVAL (0x00000000u)
/*----RAM_PSM Tokens----*/
#define CSL_PSC_PDCFG0_RAM_PSM_NO       (0x00000000u)
#define CSL_PSC_PDCFG0_RAM_PSM_YES      (0x00000001u)

#define CSL_PSC_PDCFG0_ALWAYSON_MASK    (0x00000001u)
#define CSL_PSC_PDCFG0_ALWAYSON_SHIFT   (0x00000000u)
#define CSL_PSC_PDCFG0_ALWAYSON_RESETVAL (0x00000001u)
/*----ALWAYSON Tokens----*/
#define CSL_PSC_PDCFG0_ALWAYSON_NO      (0x00000000u)
#define CSL_PSC_PDCFG0_ALWAYSON_YES     (0x00000001u)

#define CSL_PSC_PDCFG0_RESETVAL         (0x0000000Du)

/* PDCFG1 */

#define CSL_PSC_PDCFG1_PDLOCK_MASK      (0x00000008u)
#define CSL_PSC_PDCFG1_PDLOCK_SHIFT     (0x00000003u)
#define CSL_PSC_PDCFG1_PDLOCK_RESETVAL  (0x00000001u)
/*----PD LOCK Tokens----*/
#define CSL_PSC_PDCFG1_PDLOCK_YES       (0x00000000u)
#define CSL_PSC_PDCFG1_PDLOCK_NO        (0x00000001u)

#define CSL_PSC_PDCFG1_ICEPICK_MASK     (0x00000004u)
#define CSL_PSC_PDCFG1_ICEPICK_SHIFT    (0x00000002u)
#define CSL_PSC_PDCFG1_ICEPICK_RESETVAL (0x00000001u)
/*----ICEPICK Tokens----*/
#define CSL_PSC_PDCFG1_ICEPICK_ABSENT   (0x00000000u)
#define CSL_PSC_PDCFG1_ICEPICK_PRESENT  (0x00000001u)

#define CSL_PSC_PDCFG1_RAM_PSM_MASK     (0x00000002u)
#define CSL_PSC_PDCFG1_RAM_PSM_SHIFT    (0x00000001u)
#define CSL_PSC_PDCFG1_RAM_PSM_RESETVAL (0x00000001u)
/*----RAM_PSM Tokens----*/
#define CSL_PSC_PDCFG1_RAM_PSM_NO       (0x00000000u)
#define CSL_PSC_PDCFG1_RAM_PSM_YES      (0x00000001u)

#define CSL_PSC_PDCFG1_ALWAYSON_MASK    (0x00000001u)
#define CSL_PSC_PDCFG1_ALWAYSON_SHIFT   (0x00000000u)
#define CSL_PSC_PDCFG1_ALWAYSON_RESETVAL (0x00000000u)
/*----ALWAYSON Tokens----*/
#define CSL_PSC_PDCFG1_ALWAYSON_NO      (0x00000000u)
#define CSL_PSC_PDCFG1_ALWAYSON_YES     (0x00000001u)

#define CSL_PSC_PDCFG1_RESETVAL         (0x0000000Eu)

/* MDSTAT */

#define CSL_PSC_MDSTAT_EMUIHB_MASK      (0x00020000u)
#define CSL_PSC_MDSTAT_EMUIHB_SHIFT     (0x00000011u)
#define CSL_PSC_MDSTAT_EMUIHB_RESETVAL  (0x00000000u)
/*----EMUIHB Tokens----*/
#define CSL_PSC_MDSTAT_EMUIHB_DISABLE   (0x00000000u)
#define CSL_PSC_MDSTAT_EMUIHB_ENABLE    (0x00000001u)

#define CSL_PSC_MDSTAT_EMURST_MASK      (0x00010000u)
#define CSL_PSC_MDSTAT_EMURST_SHIFT     (0x00000010u)
#define CSL_PSC_MDSTAT_EMURST_RESETVAL  (0x00000000u)
/*----EMURST Tokens----*/
#define CSL_PSC_MDSTAT_EMURST_DISABLE   (0x00000000u)
#define CSL_PSC_MDSTAT_EMURST_ENABLE    (0x00000001u)

#define CSL_PSC_MDSTAT_MCKOUT_MASK      (0x00001000u)
#define CSL_PSC_MDSTAT_MCKOUT_SHIFT     (0x0000000Cu)
#define CSL_PSC_MDSTAT_MCKOUT_RESETVAL  (0x00000000u)
/*----MCKOUT Tokens----*/
#define CSL_PSC_MDSTAT_MCKOUT_OFF       (0x00000000u)
#define CSL_PSC_MDSTAT_MCKOUT_ON        (0x00000001u)

#define CSL_PSC_MDSTAT_MRSTDONE_MASK    (0x00000800u)
#define CSL_PSC_MDSTAT_MRSTDONE_SHIFT   (0x0000000Bu)
#define CSL_PSC_MDSTAT_MRSTDONE_RESETVAL (0x00000000u)
/*----MRSTDONE Tokens----*/
#define CSL_PSC_MDSTAT_MRSTDONE_COMPLETE (0x00000000u)
#define CSL_PSC_MDSTAT_MRSTDONE_INCOMPLETE (0x00000001u)

#define CSL_PSC_MDSTAT_MRST_MASK        (0x00000400u)
#define CSL_PSC_MDSTAT_MRST_SHIFT       (0x0000000Au)
#define CSL_PSC_MDSTAT_MRST_RESETVAL    (0x00000000u)
/*----MRST Tokens----*/
#define CSL_PSC_MDSTAT_MRST_ASSERT      (0x00000000u)
#define CSL_PSC_MDSTAT_MRST_DEASSERT    (0x00000001u)

#define CSL_PSC_MDSTAT_LRSTDONE_MASK    (0x00000200u)
#define CSL_PSC_MDSTAT_LRSTDONE_SHIFT   (0x00000009u)
#define CSL_PSC_MDSTAT_LRSTDONE_RESETVAL (0x00000000u)
/*----LRSTDONE Tokens----*/
#define CSL_PSC_MDSTAT_LRSTDONE_NOTDONE (0x00000000u)
#define CSL_PSC_MDSTAT_LRSTDONE_DONE    (0x00000001u)

#define CSL_PSC_MDSTAT_LRST_MASK        (0x00000100u)
#define CSL_PSC_MDSTAT_LRST_SHIFT       (0x00000008u)
#define CSL_PSC_MDSTAT_LRST_RESETVAL    (0x00000000u)
/*----LRST Tokens----*/
#define CSL_PSC_MDSTAT_LRST_ASSERT      (0x00000000u)
#define CSL_PSC_MDSTAT_LRST_DEASSERT    (0x00000001u)

#define CSL_PSC_MDSTAT_STATE_MASK       (0x0000003Fu)
#define CSL_PSC_MDSTAT_STATE_SHIFT      (0x00000000u)
#define CSL_PSC_MDSTAT_STATE_RESETVAL   (0x00000000u)
/*----STATE Tokens----*/
#define CSL_PSC_MDSTAT_STATE_SWRSTDISABLE (0x00000000u)
#define CSL_PSC_MDSTAT_STATE_SYNCRST    (0x00000001u)
#define CSL_PSC_MDSTAT_STATE_DISABLE    (0x00000002u)
#define CSL_PSC_MDSTAT_STATE_ENABLE     (0x00000003u)
#define CSL_PSC_MDSTAT_STATE_AUTOSLEEP  (0x00000004u)
#define CSL_PSC_MDSTAT_STATE_AUTOWAKE   (0x00000005u)

#define CSL_PSC_MDSTAT_RESETVAL         (0x00000000u)

/* MDCTL */

#define CSL_PSC_MDCTL_FORCE_MASK        (0x80000000u)
#define CSL_PSC_MDCTL_FORCE_SHIFT       (0x0000001Fu)
#define CSL_PSC_MDCTL_FORCE_RESETVAL    (0x00000000u)
/*----FORCE Tokens----*/
#define CSL_PSC_MDCTL_FORCE_DISABLE     (0x00000000u)
#define CSL_PSC_MDCTL_FORCE_ENABLE      (0x00000001u)

#define CSL_PSC_MDCTL_EMUIHBIE_MASK     (0x00000400u)
#define CSL_PSC_MDCTL_EMUIHBIE_SHIFT    (0x0000000Au)
#define CSL_PSC_MDCTL_EMUIHBIE_RESETVAL (0x00000000u)
/*----EMUIHBIE Tokens----*/
#define CSL_PSC_MDCTL_EMUIHBIE_DISABLE  (0x00000000u)
#define CSL_PSC_MDCTL_EMUIHBIE_ENABLE   (0x00000001u)

#define CSL_PSC_MDCTL_EMURSTIE_MASK     (0x00000200u)
#define CSL_PSC_MDCTL_EMURSTIE_SHIFT    (0x00000009u)
#define CSL_PSC_MDCTL_EMURSTIE_RESETVAL (0x00000000u)
/*----EMURSTIE Tokens----*/
#define CSL_PSC_MDCTL_EMURSTIE_DISABLE  (0x00000000u)
#define CSL_PSC_MDCTL_EMURSTIE_ENABLE   (0x00000001u)

#define CSL_PSC_MDCTL_LRST_MASK         (0x00000100u)
#define CSL_PSC_MDCTL_LRST_SHIFT        (0x00000008u)
#define CSL_PSC_MDCTL_LRST_RESETVAL     (0x00000000u)
/*----LRST Tokens----*/
#define CSL_PSC_MDCTL_LRST_ASSERT       (0x00000000u)
#define CSL_PSC_MDCTL_LRST_DEASSERT     (0x00000001u)

#define CSL_PSC_MDCTL_NEXT_MASK         (0x0000001Fu)
#define CSL_PSC_MDCTL_NEXT_SHIFT        (0x00000000u)
#define CSL_PSC_MDCTL_NEXT_RESETVAL     (0x00000000u)
/*----NEXT Tokens----*/
#define CSL_PSC_MDCTL_NEXT_SWRSTDISABLE (0x00000000u)
#define CSL_PSC_MDCTL_NEXT_SYNCRST      (0x00000001u)
#define CSL_PSC_MDCTL_NEXT_DISABLE      (0x00000002u)
#define CSL_PSC_MDCTL_NEXT_ENABLE       (0x00000003u)
#define CSL_PSC_MDCTL_NEXT_AUTOSLEEP    (0x00000004u)
#define CSL_PSC_MDCTL_NEXT_AUTOWAKE     (0x00000005u)

#define CSL_PSC_MDCTL_RESETVAL          (0x00000000u)

/********************************************************************************************/
/********************************************************************************************/
/********************************************************************************************/
/********************************************************************************************/

/** ********************************************************************************************************
 * \brief    pru_can_enable()		Configure and Enable PRU0 and PRU1 of OMAP L138.
 *
 * This API will be called by the Application to Configure and Enable PRU0 and PRU1
 *
 * \param None
 *
 * \return   SUCCESS or FAILURE
 *
 ***********************************************************************************************************/
	short pru_can_enable(void
	    );
/** ********************************************************************************************************
 * \brief    pru_can_disable()		Disable PRU0 and PRU1 of OMAP L138.
 *
 * This API will be called by the Application to disable PRU0 and PRU1
 *
 * \param None
 *
 * \return   SUCCESS or FAILURE
 *
 ***********************************************************************************************************/
	short pru_can_disable(void
	    );
/** ********************************************************************************************************
 * \brief    pru_can_run ()	Allows the PRU0 or PRU1 of OMAP L138 to execute the code loaded into its Instruction RAM
 *
 * This API will be called by the Application to execute the instruction in PRU
 *
 * \param 	u8prunum		The PRU number to initiate execution
 *
 * \return   	SUCCESS or FAILURE
 *
 ***********************************************************************************************************/
	short pru_can_run(u8 u8prunum);
/** ********************************************************************************************************
 * \brief    pru_can_psc_enable ()	Enable state transition of PRU
 *
 * This API will be called by the Application for state transition of PRU
 *
 * \param 	None
 *
 * \return   	SUCCESS or FAILURE
 *
 ***********************************************************************************************************/
	short pru_can_psc_enable(void
	    );
/** ********************************************************************************************************
 * \brief    pru_can_psc_disable ()	Disable state transition of PRU
 *
 * This API will be called by the Application for disabling state transition of PRU
 *
 * \param 	None
 *
 * \return   	SUCCESS or FAILURE
 *
 ***********************************************************************************************************/
	short pru_can_psc_disable(void
	    );
/** ********************************************************************************************************
 * \brief    pru_can_ram_write_data()		Download the data into data RAM of PRU0 or PRU1 of OMAP L138.
 *
 * This API will be called by the Application to download the data into data RAM of PRU0 or PRU1
 *
 * \param 	u32offset			Offset of the data RAM where the data has to be written
 * \param	pu32datatowrite		Pointer to a buffer that holds the data to be written into RAM
* \param	u16wordstowrite		Number of words to be written into that RAM
 *
 * \return   SUCCESS or FAILURE
 *
 ***********************************************************************************************************/
	short pru_can_ram_write_data
	    (u32 u32offset, u32 * pu32datatowrite, u16 u16wordstowrite);
/** ********************************************************************************************************
 * \brief    pru_can_ram_read_data()		Download the data into data RAM of PRU0 or PRU1 of OMAP L138.
 *
 * This API will be called by the Application to read the data from data RAM of PRU0 or PRU1
 *
 * \param 	u32offset			Offset of the data RAM where the data has to be read
 * \param	pu32datatoread		Pointer to a buffer that would hold the data to be read from the RAM
* \param	u16wordstoread		Number of words to be read from RAM
 *
 * \return   SUCCESS or FAILURE
 *
 ***********************************************************************************************************/
	short pru_can_ram_read_data
	    (u32 u32offset, u32 * pu32datatoread, u16 u16wordstoread);
/** ********************************************************************************************************
 * \brief    pru_can_download_firmware()		Download the firmware into PRU0 and PRU1 of OMAP L138.
 *
 * This API will be called by the Application to download the code into instruction RAM of PRU0 
 * and PRU1
 *
 * \param 	pstrfirmwaredata		Pointer to structure holding firmware data
 * \param 	u8prunum			The PRU number to download firmware
 *
 * \return   SUCCESS or FAILURE
 *
 ***********************************************************************************************************/
	short pru_can_download_firmware
	    (pru_can_firmware_structure * pstrfirmwaredata, u8 u8prunum);
/** ********************************************************************************************************
 * \brief    pru_can_set_brp()		Updates the  BRP register of PRU0 and PRU1 of OMAP L138.
 *
 * This API will be called by the Application to updtae the BRP register of PRU0 and PRU1
 *
 * \param 	u16bitrateprescaler		The can bus bitrate prescaler value be set
 *
 * \return   SUCCESS or FAILURE
 *
 ***********************************************************************************************************/
	short pru_can_set_brp(u16 u16bitrateprescaler);
/** End of   pru_can_set_brp() ********************************************************************************/

/** ********************************************************************************************************
 * \brief    pru_can_set_bit_timing()		Updates the  timing register of PRU0 and PRU1 of OMAP L138.
 *
 * This API will be called by the Application to updtae the timing register of PRU0 and PRU1
 *
 * \param 	pstrcanbittiming		Pointer to structure holding the bit timing values for can bus
 *
 * \return   SUCCESS or FAILURE
 *
 ***********************************************************************************************************/
	short pru_can_set_bit_timing(can_bit_timing_consts * pstrcanbittiming);
/** End of   pru_can_set_bit_timing() ************************************************************************/

/** ********************************************************************************************************
 * \brief    pru_can_calculatetiming()		Updates the  timing values of PRU0 and PRU1 of OMAP L138.
 *
 * This API will be called by the Application to updtae the timing values of PRU0 and PRU1
 *
 * \param 	u32canbittiming		Bit timing values for can bus
 * \param 	u32bitrateprescaler	Bit Rate Prescaler  for can bus
 *
 * \return   SUCCESS or FAILURE
 *
 ***********************************************************************************************************/
	short pru_can_calculatetiming
	    (u32 u32canbittiming, u32 u32bitrateprescaler);
/** End of   pru_can_calculatetiming() ************************************************************************/

/** ********************************************************************************************************
 * \brief    pru_can_write_data_to_mailbox()		Updates the transmit mailboxes of PRU1 of OMAP L138.
 *
 * This API will be called by the Application to updtae the transmit mailboxes of PRU1
 *
 * \param 	pu16canframedata	Can mailbox data buffer
 * \param 	u8mailboxnum		Mailbox to be updated
 *
 * \return   SUCCESS or FAILURE
 *
 ***********************************************************************************************************/
	short pru_can_write_data_to_mailbox
	    (can_emulation_app_hndl * pstrcanemuapphndl);
/** End of pru_can_write_data_to_mailbox()************************************************************************/

/** ********************************************************************************************************
 * \brief    pru_can_get_data_from_mailbox()		Receive data from the receive mailboxes of PRU0  of OMAP L138.
 *
 * This API will be called by the Application to get data from the receive mailboxes of PRU0 
 *
 * \param 	pu16canframedata	Can mailbox data buffer
 * \param 	u8mailboxnum		Mailbox to be updated
 *
 * \return   SUCCESS or FAILURE
 *
 ***********************************************************************************************************/
	short pru_can_get_data_from_mailbox
	    (can_emulation_app_hndl * pstrcanemuapphndl);
/** End of pru_can_get_data_from_mailbox()************************************************************************/

/** ********************************************************************************************************
 * \brief    pru_can_receive_id_map()		Receive mailboxes ID Mapping of PRU0  of OMAP L138.
 *
 * This API will be called by the Application to map the IDs  to receive mailboxes of PRU0 
 *
 * \param 	u32nodeid			Can node ID
 * \param 	ecanmailboxno		Mailbox to be mapped
 *
 * \return   SUCCESS or FAILURE
 *
 ***********************************************************************************************************/
	short pru_can_receive_id_map
	    (u32 u32nodeid, can_mailbox_number ecanmailboxno);
/** End of pru_can_receive_id_map()***********************************************************************/

/** ********************************************************************************************************
 * \brief    pru_can_get_interrupt_status()		Gets the interrupts status register value 
 *
 * This API will be called by the Application  to get the interrupts status register value 
 *
 * \param 	pu32intrstatus			Pointer to a var where interrupt status register value has to be written
 * \param 	u8prunumber			PRU number for which IntStatusReg  has to be read 
 *
 * \return   SUCCESS or FAILURE
 *
 ***********************************************************************************************************/
	short pru_can_get_interrupt_status
	    (can_emulation_app_hndl * pstrcanemuapphndl);
/** End of pru_can_get_interrupt_status() ***********************************************************************/

/** ********************************************************************************************************
 * \brief    pru_can_get_global_status()		Gets the globalstatus register value 
 *
 * This API will be called by the Application to  get the global status register value 
 *
 * \param 	pu32globalstatus			Pointer to a var where global status register value has to be written
 * \param 	u8prunumber			PRU number for which GlobalStatusReg  has to be read 
 *
 * \return   SUCCESS or FAILURE
 *
 ***********************************************************************************************************/
	short pru_can_get_global_status
	    (can_emulation_app_hndl * pstrcanemuapphndl);
/** End of pru_can_get_global_status() ***********************************************************************/

/** ********************************************************************************************************
 * \brief    pru_can_get_mailbox_status()		Gets the mailbox status register value 
 *
 * This API will be called by the Application to get the mailbox status register value 
 *
 * \param 	pu32globalstatus			Pointer to a var where global status register value has to be written
 * \param 	u8prunumber			PRU number for which GlobalStatusReg  has to be read 
 *
 * \return   SUCCESS or FAILURE
 *
 ***********************************************************************************************************/
	short pru_can_get_mailbox_status
	    (can_emulation_app_hndl * pstrcanemuapphndl);
/** End of pru_can_get_mailbox_status() ***********************************************************************/

/** ********************************************************************************************************
 * \brief    pru_can_configuration_mode_set()		Sets the timing value for data transfer 
 *
 * This API will be called by the Application to set timing valus for data transfer 
 *
 * \param 	bconfigmodeenabledisableflag			set the timing parameters
 *
 * \return   SUCCESS or FAILURE
 *
 ***********************************************************************************************************/
	short pru_can_configuration_mode_set(bool bconfigmodeenabledisableflag);
/** End of pru_can_configuration_mode_set() *****************************************************************/

/** ********************************************************************************************************
 * \brief    pru_can_emulation_init()		Initializes the Can Emulation Parameters 
 *
 * This API will be called by the Application to Initialize the Can Emulation Parameters 
 *
 * \param 	pstr_pru_iomap		Pointer to structure holding the io map addresses
 * \param 	u32pruclock			PRU Clock value
 *
 * \return   SUCCESS or FAILURE
 *
 ***********************************************************************************************************/
	short pru_can_emulation_init
	    (arm_pru_iomap * pstr_pru_iomap, u32 u32pruclock);
/** End of pru_can_emulation_init() ************************************************************************/

/** ********************************************************************************************************
 * \brief    pru_can_emulation_open()		Opens the can emulation for application to use
 *
 * This API will be called by the Application to Open the can emulation for application to use
 *
 * \param 	pstrcanemuapphndl		Pointer to application handler structure
 *
 * \return   SUCCESS or FAILURE
 *
 ***********************************************************************************************************/
	short pru_can_emulation_open
	    (can_emulation_app_hndl * pstrcanemuapphndl);
/** End of pru_can_emulation_open() ************************************************************************/

/** ********************************************************************************************************
 * \brief    pru_can_emulation_close()		Closes the can emulation for other applications to use
 *
 * This API will be called by the Application to Close the can emulation for other applications to use
 *
 * \param 	pstrcanemuapphndl		Pointer to application handler structure
 *
 * \return   SUCCESS or FAILURE
 *
 ***********************************************************************************************************/
	short pru_can_emulation_close
	    (can_emulation_app_hndl * pstrcanemuapphndl);
/** End of pru_can_emulation_close() ************************************************************************/

/** ********************************************************************************************************
 * \brief    pru_can_emulation_exit()		Diables all the PRUs
 *
 * This API will be called by the Application to disable all PRUs
 *
 * \param 	None
 *
 * \return   SUCCESS or FAILURE
 *
 ***********************************************************************************************************/
	short pru_can_emulation_exit(void
	    );
/** End of pru_can_emulation_exit() ************************************************************************/

	short pru_can_transfer_mode_set
	    (bool btransfer_flag, can_transfer_direction ecan_trx);

	short pru_can_emulation_sreset(void
	    );

	short pru_can_transfer(u8 u8mailboxnumber, u8 u8prunumber);

	short pru_can_start_or_abort_transmission(bool bcantransmitabortflag);

	short pru_can_check_init_status(void
	    );

	short pru_can_mask_ints(u32 int_mask);
	int pru_can_get_error_cnt(u8 u8prunumber);
	int pru_can_intc_status_get(void);
#ifdef __cplusplus
}				/* End of extern C */
#endif				/* #ifdef __cplusplus */
#endif
