/********************************************************************
* Copyright (C) 2003-2009 Texas Instruments Incorporated.
* All Rights Reserved
*********************************************************************
* file: cslr_prucore.h
*
* Brief: This file contains the Register Description for PRU Core
*
*********************************************************************/
#ifndef _CSLR_PRUCORE_H_
#define _CSLR_PRUCORE_H_

#ifdef __cplusplus
extern "C" {
#endif

#include <csl/cslr.h>
#include "tistdtypes.h"

/* Minimum unit = 1 byte */

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
	typedef struct {
		volatile Uint32 CONTROL;
		volatile Uint32 STATUS;
		volatile Uint32 WAKEUP;
		volatile Uint32 CYCLECNT;
		volatile Uint32 STALLCNT;
		volatile Uint8 RSVD0[12];
		volatile Uint32 CONTABBLKIDX0;
		volatile Uint32 CONTABBLKIDX1;
		volatile Uint32 CONTABPROPTR0;
		volatile Uint32 CONTABPROPTR1;
		volatile Uint8 RSVD1[976];
		volatile Uint32 INTGPR0;
		volatile Uint32 INTGPR1;
		volatile Uint32 INTGPR2;
		volatile Uint32 INTGPR3;
		volatile Uint32 INTGPR4;
		volatile Uint32 INTGPR5;
		volatile Uint32 INTGPR6;
		volatile Uint32 INTGPR7;
		volatile Uint32 INTGPR8;
		volatile Uint32 INTGPR9;
		volatile Uint32 INTGPR10;
		volatile Uint32 INTGPR11;
		volatile Uint32 INTGPR12;
		volatile Uint32 INTGPR13;
		volatile Uint32 INTGPR14;
		volatile Uint32 INTGPR15;
		volatile Uint32 INTGPR16;
		volatile Uint32 INTGPR17;
		volatile Uint32 INTGPR18;
		volatile Uint32 INTGPR19;
		volatile Uint32 INTGPR20;
		volatile Uint32 INTGPR21;
		volatile Uint32 INTGPR22;
		volatile Uint32 INTGPR23;
		volatile Uint32 INTGPR24;
		volatile Uint32 INTGPR25;
		volatile Uint32 INTGPR26;
		volatile Uint32 INTGPR27;
		volatile Uint32 INTGPR28;
		volatile Uint32 INTGPR29;
		volatile Uint32 INTGPR30;
		volatile Uint32 INTGPR31;
		volatile Uint32 INTCTER0;
		volatile Uint32 INTCTER1;
		volatile Uint32 INTCTER2;
		volatile Uint32 INTCTER3;
		volatile Uint32 INTCTER4;
		volatile Uint32 INTCTER5;
		volatile Uint32 INTCTER6;
		volatile Uint32 INTCTER7;
		volatile Uint32 INTCTER8;
		volatile Uint32 INTCTER9;
		volatile Uint32 INTCTER10;
		volatile Uint32 INTCTER11;
		volatile Uint32 INTCTER12;
		volatile Uint32 INTCTER13;
		volatile Uint32 INTCTER14;
		volatile Uint32 INTCTER15;
		volatile Uint32 INTCTER16;
		volatile Uint32 INTCTER17;
		volatile Uint32 INTCTER18;
		volatile Uint32 INTCTER19;
		volatile Uint32 INTCTER20;
		volatile Uint32 INTCTER21;
		volatile Uint32 INTCTER22;
		volatile Uint32 INTCTER23;
		volatile Uint32 INTCTER24;
		volatile Uint32 INTCTER25;
		volatile Uint32 INTCTER26;
		volatile Uint32 INTCTER27;
		volatile Uint32 INTCTER28;
		volatile Uint32 INTCTER29;
		volatile Uint32 INTCTER30;
		volatile Uint32 INTCTER31;
	} CSL_PrucoreRegs;

/**************************************************************************\
* Overlay structure typedef definition
\**************************************************************************/
	typedef volatile CSL_PrucoreRegs *CSL_PrucoreRegsOvly;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* CONTROL */

#define CSL_PRUCORE_CONTROL_PCRESETVAL_MASK (0xFFFF0000u)
#define CSL_PRUCORE_CONTROL_PCRESETVAL_SHIFT (0x00000010u)
#define CSL_PRUCORE_CONTROL_PCRESETVAL_RESETVAL (0x00000000u)

#define CSL_PRUCORE_CONTROL_RUNSTATE_MASK (0x00008000u)
#define CSL_PRUCORE_CONTROL_RUNSTATE_SHIFT (0x0000000Fu)
#define CSL_PRUCORE_CONTROL_RUNSTATE_RESETVAL (0x00000000u)
/*----RUNSTATE Tokens----*/
#define CSL_PRUCORE_CONTROL_RUNSTATE_HALT (0x00000000u)
#define CSL_PRUCORE_CONTROL_RUNSTATE_RUN (0x00000001u)

#define CSL_PRUCORE_CONTROL_SINGLESTEP_MASK (0x00000100u)
#define CSL_PRUCORE_CONTROL_SINGLESTEP_SHIFT (0x00000008u)
#define CSL_PRUCORE_CONTROL_SINGLESTEP_RESETVAL (0x00000000u)
/*----SINGLESTEP Tokens----*/
#define CSL_PRUCORE_CONTROL_SINGLESTEP_FREERUN (0x00000000u)
#define CSL_PRUCORE_CONTROL_SINGLESTEP_SINGLE (0x00000001u)

#define CSL_PRUCORE_CONTROL_COUNTENABLE_MASK (0x00000008u)
#define CSL_PRUCORE_CONTROL_COUNTENABLE_SHIFT (0x00000003u)
#define CSL_PRUCORE_CONTROL_COUNTENABLE_RESETVAL (0x00000000u)
/*----COUNTENABLE Tokens----*/
#define CSL_PRUCORE_CONTROL_COUNTENABLE_DISABLE (0x00000000u)
#define CSL_PRUCORE_CONTROL_COUNTENABLE_ENABLE (0x00000001u)

#define CSL_PRUCORE_CONTROL_SLEEPING_MASK (0x00000004u)
#define CSL_PRUCORE_CONTROL_SLEEPING_SHIFT (0x00000002u)
#define CSL_PRUCORE_CONTROL_SLEEPING_RESETVAL (0x00000000u)
/*----SLEEPING Tokens----*/
#define CSL_PRUCORE_CONTROL_SLEEPING_NOTASLEEP (0x00000000u)
#define CSL_PRUCORE_CONTROL_SLEEPING_ASLEEP (0x00000001u)

#define CSL_PRUCORE_CONTROL_ENABLE_MASK  (0x00000002u)
#define CSL_PRUCORE_CONTROL_ENABLE_SHIFT (0x00000001u)
#define CSL_PRUCORE_CONTROL_ENABLE_RESETVAL (0x00000000u)
/*----ENABLE Tokens----*/
#define CSL_PRUCORE_CONTROL_ENABLE_DISABLE (0x00000000u)
#define CSL_PRUCORE_CONTROL_ENABLE_ENABLE (0x00000001u)

#define CSL_PRUCORE_CONTROL_SOFTRESET_MASK (0x00000001u)
#define CSL_PRUCORE_CONTROL_SOFTRESET_SHIFT (0x00000000u)
#define CSL_PRUCORE_CONTROL_SOFTRESET_RESETVAL (0x00000000u)
/*----SOFTRESET Tokens----*/
#define CSL_PRUCORE_CONTROL_SOFTRESET_RESET (0x00000000u)
#define CSL_PRUCORE_CONTROL_SOFTRESET_OUT_OF_RESET (0x00000001u)

#define CSL_PRUCORE_CONTROL_RESETVAL     (0x00000000u)

/* STATUS */

#define CSL_PRUCORE_STATUS_PCOUNTER_MASK (0x0000FFFFu)
#define CSL_PRUCORE_STATUS_PCOUNTER_SHIFT (0x00000000u)
#define CSL_PRUCORE_STATUS_PCOUNTER_RESETVAL (0x00000000u)

#define CSL_PRUCORE_STATUS_RESETVAL      (0x00000000u)

/* WAKEUP */

#define CSL_PRUCORE_WAKEUP_BITWISEENABLES_MASK (0xFFFFFFFFu)
#define CSL_PRUCORE_WAKEUP_BITWISEENABLES_SHIFT (0x00000000u)
#define CSL_PRUCORE_WAKEUP_BITWISEENABLES_RESETVAL (0x00000000u)

#define CSL_PRUCORE_WAKEUP_RESETVAL      (0x00000000u)

/* CYCLECNT */

#define CSL_PRUCORE_CYCLECNT_CYCLECOUNT_MASK (0xFFFFFFFFu)
#define CSL_PRUCORE_CYCLECNT_CYCLECOUNT_SHIFT (0x00000000u)
#define CSL_PRUCORE_CYCLECNT_CYCLECOUNT_RESETVAL (0x00000000u)

#define CSL_PRUCORE_CYCLECNT_RESETVAL    (0x00000000u)

/* STALLCNT */

#define CSL_PRUCORE_STALLCNT_STALLCOUNT_MASK (0xFFFFFFFFu)
#define CSL_PRUCORE_STALLCNT_STALLCOUNT_SHIFT (0x00000000u)
#define CSL_PRUCORE_STALLCNT_STALLCOUNT_RESETVAL (0x00000000u)

#define CSL_PRUCORE_STALLCNT_RESETVAL    (0x00000000u)

/* CONTABBLKIDX0 */

#define CSL_PRUCORE_CONTABBLKIDX0_C25_MASK (0x000F0000u)
#define CSL_PRUCORE_CONTABBLKIDX0_C25_SHIFT (0x00000010u)
#define CSL_PRUCORE_CONTABBLKIDX0_C25_RESETVAL (0x00000000u)

#define CSL_PRUCORE_CONTABBLKIDX0_C24_MASK (0x0000000Fu)
#define CSL_PRUCORE_CONTABBLKIDX0_C24_SHIFT (0x00000000u)
#define CSL_PRUCORE_CONTABBLKIDX0_C24_RESETVAL (0x00000000u)

#define CSL_PRUCORE_CONTABBLKIDX0_RESETVAL (0x00000000u)

/* CONTABBLKIDX1 */

#define CSL_PRUCORE_CONTABBLKIDX1_C27_MASK (0x000F0000u)
#define CSL_PRUCORE_CONTABBLKIDX1_C27_SHIFT (0x00000010u)
#define CSL_PRUCORE_CONTABBLKIDX1_C27_RESETVAL (0x00000000u)

#define CSL_PRUCORE_CONTABBLKIDX1_C26_MASK (0x0000000Fu)
#define CSL_PRUCORE_CONTABBLKIDX1_C26_SHIFT (0x00000000u)
#define CSL_PRUCORE_CONTABBLKIDX1_C26_RESETVAL (0x00000000u)

#define CSL_PRUCORE_CONTABBLKIDX1_RESETVAL (0x00000000u)

/* CONTABPROPTR0 */

#define CSL_PRUCORE_CONTABPROPTR0_C29_MASK (0xFFFF0000u)
#define CSL_PRUCORE_CONTABPROPTR0_C29_SHIFT (0x00000010u)
#define CSL_PRUCORE_CONTABPROPTR0_C29_RESETVAL (0x00000000u)

#define CSL_PRUCORE_CONTABPROPTR0_C28_MASK (0x0000FFFFu)
#define CSL_PRUCORE_CONTABPROPTR0_C28_SHIFT (0x00000000u)
#define CSL_PRUCORE_CONTABPROPTR0_C28_RESETVAL (0x00000000u)

#define CSL_PRUCORE_CONTABPROPTR0_RESETVAL (0x00000000u)

/* CONTABPROPTR1 */

#define CSL_PRUCORE_CONTABPROPTR1_C31_MASK (0xFFFF0000u)
#define CSL_PRUCORE_CONTABPROPTR1_C31_SHIFT (0x00000010u)
#define CSL_PRUCORE_CONTABPROPTR1_C31_RESETVAL (0x00000000u)

#define CSL_PRUCORE_CONTABPROPTR1_C30_MASK (0x0000FFFFu)
#define CSL_PRUCORE_CONTABPROPTR1_C30_SHIFT (0x00000000u)
#define CSL_PRUCORE_CONTABPROPTR1_C30_RESETVAL (0x00000000u)

#define CSL_PRUCORE_CONTABPROPTR1_RESETVAL (0x00000000u)

/* INTGPR0 */

#define CSL_PRUCORE_INTGPR0_REG_MASK     (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR0_REG_SHIFT    (0x00000000u)
#define CSL_PRUCORE_INTGPR0_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR0_RESETVAL     (0x00000000u)

/* INTGPR1 */

#define CSL_PRUCORE_INTGPR1_REG_MASK     (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR1_REG_SHIFT    (0x00000000u)
#define CSL_PRUCORE_INTGPR1_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR1_RESETVAL     (0x00000000u)

/* INTGPR2 */

#define CSL_PRUCORE_INTGPR2_REG_MASK     (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR2_REG_SHIFT    (0x00000000u)
#define CSL_PRUCORE_INTGPR2_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR2_RESETVAL     (0x00000000u)

/* INTGPR3 */

#define CSL_PRUCORE_INTGPR3_REG_MASK     (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR3_REG_SHIFT    (0x00000000u)
#define CSL_PRUCORE_INTGPR3_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR3_RESETVAL     (0x00000000u)

/* INTGPR4 */

#define CSL_PRUCORE_INTGPR4_REG_MASK     (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR4_REG_SHIFT    (0x00000000u)
#define CSL_PRUCORE_INTGPR4_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR4_RESETVAL     (0x00000000u)

/* INTGPR5 */

#define CSL_PRUCORE_INTGPR5_REG_MASK     (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR5_REG_SHIFT    (0x00000000u)
#define CSL_PRUCORE_INTGPR5_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR5_RESETVAL     (0x00000000u)

/* INTGPR6 */

#define CSL_PRUCORE_INTGPR6_REG_MASK     (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR6_REG_SHIFT    (0x00000000u)
#define CSL_PRUCORE_INTGPR6_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR6_RESETVAL     (0x00000000u)

/* INTGPR7 */

#define CSL_PRUCORE_INTGPR7_REG_MASK     (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR7_REG_SHIFT    (0x00000000u)
#define CSL_PRUCORE_INTGPR7_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR7_RESETVAL     (0x00000000u)

/* INTGPR8 */

#define CSL_PRUCORE_INTGPR8_REG_MASK     (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR8_REG_SHIFT    (0x00000000u)
#define CSL_PRUCORE_INTGPR8_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR8_RESETVAL     (0x00000000u)

/* INTGPR9 */

#define CSL_PRUCORE_INTGPR9_REG_MASK     (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR9_REG_SHIFT    (0x00000000u)
#define CSL_PRUCORE_INTGPR9_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR9_RESETVAL     (0x00000000u)

/* INTGPR10 */

#define CSL_PRUCORE_INTGPR10_REG_MASK    (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR10_REG_SHIFT   (0x00000000u)
#define CSL_PRUCORE_INTGPR10_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR10_RESETVAL    (0x00000000u)

/* INTGPR11 */

#define CSL_PRUCORE_INTGPR11_REG_MASK    (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR11_REG_SHIFT   (0x00000000u)
#define CSL_PRUCORE_INTGPR11_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR11_RESETVAL    (0x00000000u)

/* INTGPR12 */

#define CSL_PRUCORE_INTGPR12_REG_MASK    (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR12_REG_SHIFT   (0x00000000u)
#define CSL_PRUCORE_INTGPR12_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR12_RESETVAL    (0x00000000u)

/* INTGPR13 */

#define CSL_PRUCORE_INTGPR13_REG_MASK    (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR13_REG_SHIFT   (0x00000000u)
#define CSL_PRUCORE_INTGPR13_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR13_RESETVAL    (0x00000000u)

/* INTGPR14 */

#define CSL_PRUCORE_INTGPR14_REG_MASK    (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR14_REG_SHIFT   (0x00000000u)
#define CSL_PRUCORE_INTGPR14_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR14_RESETVAL    (0x00000000u)

/* INTGPR15 */

#define CSL_PRUCORE_INTGPR15_REG_MASK    (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR15_REG_SHIFT   (0x00000000u)
#define CSL_PRUCORE_INTGPR15_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR15_RESETVAL    (0x00000000u)

/* INTGPR16 */

#define CSL_PRUCORE_INTGPR16_REG_MASK    (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR16_REG_SHIFT   (0x00000000u)
#define CSL_PRUCORE_INTGPR16_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR16_RESETVAL    (0x00000000u)

/* INTGPR17 */

#define CSL_PRUCORE_INTGPR17_REG_MASK    (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR17_REG_SHIFT   (0x00000000u)
#define CSL_PRUCORE_INTGPR17_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR17_RESETVAL    (0x00000000u)

/* INTGPR18 */

#define CSL_PRUCORE_INTGPR18_REG_MASK    (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR18_REG_SHIFT   (0x00000000u)
#define CSL_PRUCORE_INTGPR18_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR18_RESETVAL    (0x00000000u)

/* INTGPR19 */

#define CSL_PRUCORE_INTGPR19_REG_MASK    (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR19_REG_SHIFT   (0x00000000u)
#define CSL_PRUCORE_INTGPR19_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR19_RESETVAL    (0x00000000u)

/* INTGPR20 */

#define CSL_PRUCORE_INTGPR20_REG_MASK    (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR20_REG_SHIFT   (0x00000000u)
#define CSL_PRUCORE_INTGPR20_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR20_RESETVAL    (0x00000000u)

/* INTGPR21 */

#define CSL_PRUCORE_INTGPR21_REG_MASK    (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR21_REG_SHIFT   (0x00000000u)
#define CSL_PRUCORE_INTGPR21_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR21_RESETVAL    (0x00000000u)

/* INTGPR22 */

#define CSL_PRUCORE_INTGPR22_REG_MASK    (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR22_REG_SHIFT   (0x00000000u)
#define CSL_PRUCORE_INTGPR22_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR22_RESETVAL    (0x00000000u)

/* INTGPR23 */

#define CSL_PRUCORE_INTGPR23_REG_MASK    (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR23_REG_SHIFT   (0x00000000u)
#define CSL_PRUCORE_INTGPR23_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR23_RESETVAL    (0x00000000u)

/* INTGPR24 */

#define CSL_PRUCORE_INTGPR24_REG_MASK    (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR24_REG_SHIFT   (0x00000000u)
#define CSL_PRUCORE_INTGPR24_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR24_RESETVAL    (0x00000000u)

/* INTGPR25 */

#define CSL_PRUCORE_INTGPR25_REG_MASK    (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR25_REG_SHIFT   (0x00000000u)
#define CSL_PRUCORE_INTGPR25_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR25_RESETVAL    (0x00000000u)

/* INTGPR26 */

#define CSL_PRUCORE_INTGPR26_REG_MASK    (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR26_REG_SHIFT   (0x00000000u)
#define CSL_PRUCORE_INTGPR26_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR26_RESETVAL    (0x00000000u)

/* INTGPR27 */

#define CSL_PRUCORE_INTGPR27_REG_MASK    (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR27_REG_SHIFT   (0x00000000u)
#define CSL_PRUCORE_INTGPR27_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR27_RESETVAL    (0x00000000u)

/* INTGPR28 */

#define CSL_PRUCORE_INTGPR28_REG_MASK    (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR28_REG_SHIFT   (0x00000000u)
#define CSL_PRUCORE_INTGPR28_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR28_RESETVAL    (0x00000000u)

/* INTGPR29 */

#define CSL_PRUCORE_INTGPR29_REG_MASK    (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR29_REG_SHIFT   (0x00000000u)
#define CSL_PRUCORE_INTGPR29_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR29_RESETVAL    (0x00000000u)

/* INTGPR30 */

#define CSL_PRUCORE_INTGPR30_REG_MASK    (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR30_REG_SHIFT   (0x00000000u)
#define CSL_PRUCORE_INTGPR30_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR30_RESETVAL    (0x00000000u)

/* INTGPR31 */

#define CSL_PRUCORE_INTGPR31_REG_MASK    (0xFFFFFFFFu)
#define CSL_PRUCORE_INTGPR31_REG_SHIFT   (0x00000000u)
#define CSL_PRUCORE_INTGPR31_REG_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTGPR31_RESETVAL    (0x00000000u)

/* INTCTER0 */

#define CSL_PRUCORE_INTCTER0_ENTRY_MASK  (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER0_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER0_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER0_RESETVAL    (0x00000000u)

/* INTCTER1 */

#define CSL_PRUCORE_INTCTER1_ENTRY_MASK  (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER1_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER1_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER1_RESETVAL    (0x00000000u)

/* INTCTER2 */

#define CSL_PRUCORE_INTCTER2_ENTRY_MASK  (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER2_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER2_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER2_RESETVAL    (0x00000000u)

/* INTCTER3 */

#define CSL_PRUCORE_INTCTER3_ENTRY_MASK  (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER3_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER3_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER3_RESETVAL    (0x00000000u)

/* INTCTER4 */

#define CSL_PRUCORE_INTCTER4_ENTRY_MASK  (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER4_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER4_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER4_RESETVAL    (0x00000000u)

/* INTCTER5 */

#define CSL_PRUCORE_INTCTER5_ENTRY_MASK  (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER5_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER5_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER5_RESETVAL    (0x00000000u)

/* INTCTER6 */

#define CSL_PRUCORE_INTCTER6_ENTRY_MASK  (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER6_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER6_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER6_RESETVAL    (0x00000000u)

/* INTCTER7 */

#define CSL_PRUCORE_INTCTER7_ENTRY_MASK  (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER7_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER7_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER7_RESETVAL    (0x00000000u)

/* INTCTER8 */

#define CSL_PRUCORE_INTCTER8_ENTRY_MASK  (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER8_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER8_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER8_RESETVAL    (0x00000000u)

/* INTCTER9 */

#define CSL_PRUCORE_INTCTER9_ENTRY_MASK  (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER9_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER9_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER9_RESETVAL    (0x00000000u)

/* INTCTER10 */

#define CSL_PRUCORE_INTCTER10_ENTRY_MASK (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER10_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER10_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER10_RESETVAL   (0x00000000u)

/* INTCTER11 */

#define CSL_PRUCORE_INTCTER11_ENTRY_MASK (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER11_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER11_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER11_RESETVAL   (0x00000000u)

/* INTCTER12 */

#define CSL_PRUCORE_INTCTER12_ENTRY_MASK (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER12_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER12_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER12_RESETVAL   (0x00000000u)

/* INTCTER13 */

#define CSL_PRUCORE_INTCTER13_ENTRY_MASK (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER13_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER13_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER13_RESETVAL   (0x00000000u)

/* INTCTER14 */

#define CSL_PRUCORE_INTCTER14_ENTRY_MASK (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER14_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER14_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER14_RESETVAL   (0x00000000u)

/* INTCTER15 */

#define CSL_PRUCORE_INTCTER15_ENTRY_MASK (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER15_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER15_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER15_RESETVAL   (0x00000000u)

/* INTCTER16 */

#define CSL_PRUCORE_INTCTER16_ENTRY_MASK (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER16_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER16_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER16_RESETVAL   (0x00000000u)

/* INTCTER17 */

#define CSL_PRUCORE_INTCTER17_ENTRY_MASK (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER17_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER17_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER17_RESETVAL   (0x00000000u)

/* INTCTER18 */

#define CSL_PRUCORE_INTCTER18_ENTRY_MASK (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER18_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER18_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER18_RESETVAL   (0x00000000u)

/* INTCTER19 */

#define CSL_PRUCORE_INTCTER19_ENTRY_MASK (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER19_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER19_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER19_RESETVAL   (0x00000000u)

/* INTCTER20 */

#define CSL_PRUCORE_INTCTER20_ENTRY_MASK (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER20_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER20_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER20_RESETVAL   (0x00000000u)

/* INTCTER21 */

#define CSL_PRUCORE_INTCTER21_ENTRY_MASK (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER21_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER21_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER21_RESETVAL   (0x00000000u)

/* INTCTER22 */

#define CSL_PRUCORE_INTCTER22_ENTRY_MASK (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER22_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER22_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER22_RESETVAL   (0x00000000u)

/* INTCTER23 */

#define CSL_PRUCORE_INTCTER23_ENTRY_MASK (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER23_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER23_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER23_RESETVAL   (0x00000000u)

/* INTCTER24 */

#define CSL_PRUCORE_INTCTER24_ENTRY_MASK (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER24_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER24_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER24_RESETVAL   (0x00000000u)

/* INTCTER25 */

#define CSL_PRUCORE_INTCTER25_ENTRY_MASK (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER25_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER25_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER25_RESETVAL   (0x00000000u)

/* INTCTER26 */

#define CSL_PRUCORE_INTCTER26_ENTRY_MASK (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER26_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER26_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER26_RESETVAL   (0x00000000u)

/* INTCTER27 */

#define CSL_PRUCORE_INTCTER27_ENTRY_MASK (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER27_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER27_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER27_RESETVAL   (0x00000000u)

/* INTCTER28 */

#define CSL_PRUCORE_INTCTER28_ENTRY_MASK (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER28_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER28_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER28_RESETVAL   (0x00000000u)

/* INTCTER29 */

#define CSL_PRUCORE_INTCTER29_ENTRY_MASK (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER29_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER29_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER29_RESETVAL   (0x00000000u)

/* INTCTER30 */

#define CSL_PRUCORE_INTCTER30_ENTRY_MASK (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER30_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER30_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER30_RESETVAL   (0x00000000u)

/* INTCTER31 */

#define CSL_PRUCORE_INTCTER31_ENTRY_MASK (0xFFFFFFFFu)
#define CSL_PRUCORE_INTCTER31_ENTRY_SHIFT (0x00000000u)
#define CSL_PRUCORE_INTCTER31_ENTRY_RESETVAL (0x00000000u)

#define CSL_PRUCORE_INTCTER31_RESETVAL   (0x00000000u)

#ifdef __cplusplus
}
#endif
#endif
