/********************************************************************
* Copyright (C) 2003-2009 Texas Instruments Incorporated.
* All Rights Reserved
*********************************************************************
* file: cslr_pruintc.h
*
* Brief: This file contains the Register Description for PRU Intc
*
*********************************************************************/
#ifndef _CSLR_PRUINTC_H_
#define _CSLR_PRUINTC_H_

#ifdef __cplusplus
extern "C" {
#endif

#include <csl/cslr.h>
#include "tistdtypes.h"


/* Minimum unit = 1 byte */

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint32 REVID;
    volatile Uint32 CONTROL;
    volatile Uint8 RSVD0[8];
    volatile Uint32 GLBLEN;
    volatile Uint8 RSVD1[8];
    volatile Uint32 GLBLNSTLVL;
    volatile Uint32 STATIDXSET;
    volatile Uint32 STATIDXCLR;
    volatile Uint32 ENIDXSET;
    volatile Uint32 ENIDXCLR;
    volatile Uint8 RSVD2[4];
    volatile Uint32 HSTINTENIDX;
    volatile Uint32 HSTINTENIDXCLR;
    volatile Uint8 RSVD3[68];
    volatile Uint32 GLBLPRIIDX;
    volatile Uint8 RSVD4[380];
    volatile Uint32 STATSETINT0;
    volatile Uint32 STATSETINT1;
    volatile Uint8 RSVD5[120];
    volatile Uint32 STATCLRINT0;
    volatile Uint32 STATCLRINT1;
    volatile Uint8 RSVD6[120];
    volatile Uint32 ENABLESET0;
    volatile Uint32 ENABLESET1;
    volatile Uint8 RSVD7[120];
    volatile Uint32 ENABLECLR0;
    volatile Uint32 ENABLECLR1;
    volatile Uint8 RSVD8[120];
    volatile Uint32 CHANMAP0;
    volatile Uint32 CHANMAP1;
    volatile Uint32 CHANMAP2;
    volatile Uint32 CHANMAP3;
    volatile Uint32 CHANMAP4;
    volatile Uint32 CHANMAP5;
    volatile Uint32 CHANMAP6;
    volatile Uint32 CHANMAP7;
    volatile Uint32 CHANMAP8;
    volatile Uint32 CHANMAP9;
    volatile Uint32 CHANMAP10;
    volatile Uint32 CHANMAP11;
    volatile Uint32 CHANMAP12;
    volatile Uint32 CHANMAP13;
    volatile Uint32 CHANMAP14;
    volatile Uint32 CHANMAP15;
    volatile Uint8 RSVD9[960];
    volatile Uint32 HOSTMAP0;
    volatile Uint32 HOSTMAP1;
    volatile Uint32 HOSTMAP2;
    volatile Uint8 RSVD10[244];
    volatile Uint32 HSTINTPRIIDX0;
    volatile Uint32 HSTINTPRIIDX1;
    volatile Uint32 HSTINTPRIIDX2;
    volatile Uint32 HSTINTPRIIDX3;
    volatile Uint32 HSTINTPRIIDX4;
    volatile Uint32 HSTINTPRIIDX5;
    volatile Uint32 HSTINTPRIIDX6;
    volatile Uint32 HSTINTPRIIDX7;
    volatile Uint32 HSTINTPRIIDX8;
    volatile Uint32 HSTINTPRIIDX9;
    volatile Uint8 RSVD11[984];
    volatile Uint32 POLARITY0;
    volatile Uint32 POLARITY1;
    volatile Uint8 RSVD12[120];
    volatile Uint32 TYPE0;
    volatile Uint32 TYPE1;
    volatile Uint8 RSVD13[888];
    volatile Uint32 HSTINTNSTLVL0;
    volatile Uint32 HSTINTNSTLVL1;
    volatile Uint32 HSTINTNSTLVL2;
    volatile Uint32 HSTINTNSTLVL3;
    volatile Uint32 HSTINTNSTLVL4;
    volatile Uint32 HSTINTNSTLVL5;
    volatile Uint32 HSTINTNSTLVL6;
    volatile Uint32 HSTINTNSTLVL7;
    volatile Uint32 HSTINTNSTLVL8;
    volatile Uint32 HSTINTNSTLVL9;
    volatile Uint8 RSVD14[984];
    volatile Uint32 HSTINTEN;
} CSL_PruintcRegs;


/**************************************************************************\
* Overlay structure typedef definition
\**************************************************************************/
typedef volatile CSL_PruintcRegs         *CSL_PruintcRegsOvly;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* REVID */

#define CSL_PRUINTC_REVID_REV_MASK       (0xFFFFFFFFu)
#define CSL_PRUINTC_REVID_REV_SHIFT      (0x00000000u)
#define CSL_PRUINTC_REVID_REV_RESETVAL   (0x4E820100u)

#define CSL_PRUINTC_REVID_RESETVAL       (0x4E820100u)

/* CONTROL */


#define CSL_PRUINTC_CONTROL_NESTMODE_MASK (0x0000000Cu)
#define CSL_PRUINTC_CONTROL_NESTMODE_SHIFT (0x00000002u)
#define CSL_PRUINTC_CONTROL_NESTMODE_RESETVAL (0x00000000u)
/*----NESTMODE Tokens----*/
#define CSL_PRUINTC_CONTROL_NESTMODE_NONEST (0x00000000u)
#define CSL_PRUINTC_CONTROL_NESTMODE_INDIVIDUAL (0x00000001u)
#define CSL_PRUINTC_CONTROL_NESTMODE_GLOBAL (0x00000002u)
#define CSL_PRUINTC_CONTROL_NESTMODE_MANUAL (0x00000003u)


#define CSL_PRUINTC_CONTROL_RESETVAL     (0x00000000u)

/* GLBLEN */


#define CSL_PRUINTC_GLBLEN_ENABLE_MASK   (0x00000001u)
#define CSL_PRUINTC_GLBLEN_ENABLE_SHIFT  (0x00000000u)
#define CSL_PRUINTC_GLBLEN_ENABLE_RESETVAL (0x00000000u)
/*----ENABLE Tokens----*/
#define CSL_PRUINTC_GLBLEN_ENABLE_DISABLE (0x00000000u)
#define CSL_PRUINTC_GLBLEN_ENABLE_ENABLE (0x00000001u)

#define CSL_PRUINTC_GLBLEN_RESETVAL      (0x00000000u)

/* GLBLNSTLVL */

#define CSL_PRUINTC_GLBLNSTLVL_OVERRIDE_MASK (0x80000000u)
#define CSL_PRUINTC_GLBLNSTLVL_OVERRIDE_SHIFT (0x0000001Fu)
#define CSL_PRUINTC_GLBLNSTLVL_OVERRIDE_RESETVAL (0x00000000u)
/*----OVERRIDE Tokens----*/
#define CSL_PRUINTC_GLBLNSTLVL_OVERRIDE_DISABLE (0x00000000u)
#define CSL_PRUINTC_GLBLNSTLVL_OVERRIDE_ENABLE (0x00000001u)


#define CSL_PRUINTC_GLBLNSTLVL_NESTLEVEL_MASK (0x000001FFu)
#define CSL_PRUINTC_GLBLNSTLVL_NESTLEVEL_SHIFT (0x00000000u)
#define CSL_PRUINTC_GLBLNSTLVL_NESTLEVEL_RESETVAL (0x00000000u)

#define CSL_PRUINTC_GLBLNSTLVL_RESETVAL  (0x00000000u)

/* STATIDXSET */


#define CSL_PRUINTC_STATIDXSET_INDEX_MASK (0x000003FFu)
#define CSL_PRUINTC_STATIDXSET_INDEX_SHIFT (0x00000000u)
#define CSL_PRUINTC_STATIDXSET_INDEX_RESETVAL (0x00000000u)

#define CSL_PRUINTC_STATIDXSET_RESETVAL  (0x00000000u)

/* STATIDXCLR */


#define CSL_PRUINTC_STATIDXCLR_INDEX_MASK (0x000003FFu)
#define CSL_PRUINTC_STATIDXCLR_INDEX_SHIFT (0x00000000u)
#define CSL_PRUINTC_STATIDXCLR_INDEX_RESETVAL (0x00000000u)

#define CSL_PRUINTC_STATIDXCLR_RESETVAL  (0x00000000u)

/* ENIDXSET */


#define CSL_PRUINTC_ENIDXSET_INDEX_MASK  (0x000003FFu)
#define CSL_PRUINTC_ENIDXSET_INDEX_SHIFT (0x00000000u)
#define CSL_PRUINTC_ENIDXSET_INDEX_RESETVAL (0x00000000u)

#define CSL_PRUINTC_ENIDXSET_RESETVAL    (0x00000000u)

/* ENIDXCLR */


#define CSL_PRUINTC_ENIDXCLR_INDEX_MASK  (0x000003FFu)
#define CSL_PRUINTC_ENIDXCLR_INDEX_SHIFT (0x00000000u)
#define CSL_PRUINTC_ENIDXCLR_INDEX_RESETVAL (0x00000000u)

#define CSL_PRUINTC_ENIDXCLR_RESETVAL    (0x00000000u)

/* HSTINTENIDX */


#define CSL_PRUINTC_HSTINTENIDX_INDEX_MASK (0x000003FFu)
#define CSL_PRUINTC_HSTINTENIDX_INDEX_SHIFT (0x00000000u)
#define CSL_PRUINTC_HSTINTENIDX_INDEX_RESETVAL (0x00000000u)

#define CSL_PRUINTC_HSTINTENIDX_RESETVAL (0x00000000u)

/* HSTINTENIDXCLR */


#define CSL_PRUINTC_HSTINTENIDXCLR_INDEX_MASK (0x000003FFu)
#define CSL_PRUINTC_HSTINTENIDXCLR_INDEX_SHIFT (0x00000000u)
#define CSL_PRUINTC_HSTINTENIDXCLR_INDEX_RESETVAL (0x00000000u)

#define CSL_PRUINTC_HSTINTENIDXCLR_RESETVAL (0x00000000u)

/* GLBLPRIIDX */

#define CSL_PRUINTC_GLBLPRIIDX_NONE_MASK (0x80000000u)
#define CSL_PRUINTC_GLBLPRIIDX_NONE_SHIFT (0x0000001Fu)
#define CSL_PRUINTC_GLBLPRIIDX_NONE_RESETVAL (0x00000001u)


#define CSL_PRUINTC_GLBLPRIIDX_INDEX_MASK (0x000003FFu)
#define CSL_PRUINTC_GLBLPRIIDX_INDEX_SHIFT (0x00000000u)
#define CSL_PRUINTC_GLBLPRIIDX_INDEX_RESETVAL (0x00000000u)

#define CSL_PRUINTC_GLBLPRIIDX_RESETVAL  (0x80000000u)

/* STATSETINT0 */

#define CSL_PRUINTC_STATSETINT0_SI31_MASK (0x80000000u)
#define CSL_PRUINTC_STATSETINT0_SI31_SHIFT (0x0000001Fu)
#define CSL_PRUINTC_STATSETINT0_SI31_RESETVAL (0x00000000u)
/*----SI31 Tokens----*/
#define CSL_PRUINTC_STATSETINT0_SI31_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT0_SI31_SET (0x00000001u)

#define CSL_PRUINTC_STATSETINT0_SI30_MASK (0x40000000u)
#define CSL_PRUINTC_STATSETINT0_SI30_SHIFT (0x0000001Eu)
#define CSL_PRUINTC_STATSETINT0_SI30_RESETVAL (0x00000000u)
/*----SI30 Tokens----*/
#define CSL_PRUINTC_STATSETINT0_SI30_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT0_SI30_SET (0x00000001u)

#define CSL_PRUINTC_STATSETINT0_SI29_MASK (0x20000000u)
#define CSL_PRUINTC_STATSETINT0_SI29_SHIFT (0x0000001Du)
#define CSL_PRUINTC_STATSETINT0_SI29_RESETVAL (0x00000000u)
/*----SI29 Tokens----*/
#define CSL_PRUINTC_STATSETINT0_SI29_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT0_SI29_SET (0x00000001u)

#define CSL_PRUINTC_STATSETINT0_SI28_MASK (0x10000000u)
#define CSL_PRUINTC_STATSETINT0_SI28_SHIFT (0x0000001Cu)
#define CSL_PRUINTC_STATSETINT0_SI28_RESETVAL (0x00000000u)
/*----SI28 Tokens----*/
#define CSL_PRUINTC_STATSETINT0_SI28_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT0_SI28_SET (0x00000001u)

#define CSL_PRUINTC_STATSETINT0_SI27_MASK (0x08000000u)
#define CSL_PRUINTC_STATSETINT0_SI27_SHIFT (0x0000001Bu)
#define CSL_PRUINTC_STATSETINT0_SI27_RESETVAL (0x00000000u)
/*----SI27 Tokens----*/
#define CSL_PRUINTC_STATSETINT0_SI27_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT0_SI27_SET (0x00000001u)

#define CSL_PRUINTC_STATSETINT0_SI26_MASK (0x04000000u)
#define CSL_PRUINTC_STATSETINT0_SI26_SHIFT (0x0000001Au)
#define CSL_PRUINTC_STATSETINT0_SI26_RESETVAL (0x00000000u)
/*----SI26 Tokens----*/
#define CSL_PRUINTC_STATSETINT0_SI26_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT0_SI26_SET (0x00000001u)

#define CSL_PRUINTC_STATSETINT0_SI25_MASK (0x02000000u)
#define CSL_PRUINTC_STATSETINT0_SI25_SHIFT (0x00000019u)
#define CSL_PRUINTC_STATSETINT0_SI25_RESETVAL (0x00000000u)
/*----SI25 Tokens----*/
#define CSL_PRUINTC_STATSETINT0_SI25_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT0_SI25_SET (0x00000001u)

#define CSL_PRUINTC_STATSETINT0_SI24_MASK (0x01000000u)
#define CSL_PRUINTC_STATSETINT0_SI24_SHIFT (0x00000018u)
#define CSL_PRUINTC_STATSETINT0_SI24_RESETVAL (0x00000000u)
/*----SI24 Tokens----*/
#define CSL_PRUINTC_STATSETINT0_SI24_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT0_SI24_SET (0x00000001u)

#define CSL_PRUINTC_STATSETINT0_SI23_MASK (0x00800000u)
#define CSL_PRUINTC_STATSETINT0_SI23_SHIFT (0x00000017u)
#define CSL_PRUINTC_STATSETINT0_SI23_RESETVAL (0x00000000u)
/*----SI23 Tokens----*/
#define CSL_PRUINTC_STATSETINT0_SI23_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT0_SI23_SET (0x00000001u)

#define CSL_PRUINTC_STATSETINT0_SI22_MASK (0x00400000u)
#define CSL_PRUINTC_STATSETINT0_SI22_SHIFT (0x00000016u)
#define CSL_PRUINTC_STATSETINT0_SI22_RESETVAL (0x00000000u)
/*----SI22 Tokens----*/
#define CSL_PRUINTC_STATSETINT0_SI22_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT0_SI22_SET (0x00000001u)

#define CSL_PRUINTC_STATSETINT0_SI21_MASK (0x00200000u)
#define CSL_PRUINTC_STATSETINT0_SI21_SHIFT (0x00000015u)
#define CSL_PRUINTC_STATSETINT0_SI21_RESETVAL (0x00000000u)
/*----SI21 Tokens----*/
#define CSL_PRUINTC_STATSETINT0_SI21_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT0_SI21_SET (0x00000001u)

#define CSL_PRUINTC_STATSETINT0_SI20_MASK (0x00100000u)
#define CSL_PRUINTC_STATSETINT0_SI20_SHIFT (0x00000014u)
#define CSL_PRUINTC_STATSETINT0_SI20_RESETVAL (0x00000000u)
/*----SI20 Tokens----*/
#define CSL_PRUINTC_STATSETINT0_SI20_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT0_SI20_SET (0x00000001u)

#define CSL_PRUINTC_STATSETINT0_SI19_MASK (0x00080000u)
#define CSL_PRUINTC_STATSETINT0_SI19_SHIFT (0x00000013u)
#define CSL_PRUINTC_STATSETINT0_SI19_RESETVAL (0x00000000u)
/*----SI19 Tokens----*/
#define CSL_PRUINTC_STATSETINT0_SI19_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT0_SI19_SET (0x00000001u)

#define CSL_PRUINTC_STATSETINT0_SI18_MASK (0x00040000u)
#define CSL_PRUINTC_STATSETINT0_SI18_SHIFT (0x00000012u)
#define CSL_PRUINTC_STATSETINT0_SI18_RESETVAL (0x00000000u)
/*----SI18 Tokens----*/
#define CSL_PRUINTC_STATSETINT0_SI18_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT0_SI18_SET (0x00000001u)

#define CSL_PRUINTC_STATSETINT0_SI17_MASK (0x00020000u)
#define CSL_PRUINTC_STATSETINT0_SI17_SHIFT (0x00000011u)
#define CSL_PRUINTC_STATSETINT0_SI17_RESETVAL (0x00000000u)
/*----SI17 Tokens----*/
#define CSL_PRUINTC_STATSETINT0_SI17_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT0_SI17_SET (0x00000001u)

#define CSL_PRUINTC_STATSETINT0_SI16_MASK (0x00010000u)
#define CSL_PRUINTC_STATSETINT0_SI16_SHIFT (0x00000010u)
#define CSL_PRUINTC_STATSETINT0_SI16_RESETVAL (0x00000000u)
/*----SI16 Tokens----*/
#define CSL_PRUINTC_STATSETINT0_SI16_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT0_SI16_SET (0x00000001u)

#define CSL_PRUINTC_STATSETINT0_SI15_MASK (0x00008000u)
#define CSL_PRUINTC_STATSETINT0_SI15_SHIFT (0x0000000Fu)
#define CSL_PRUINTC_STATSETINT0_SI15_RESETVAL (0x00000000u)
/*----SI15 Tokens----*/
#define CSL_PRUINTC_STATSETINT0_SI15_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT0_SI15_SET (0x00000001u)

#define CSL_PRUINTC_STATSETINT0_SI14_MASK (0x00004000u)
#define CSL_PRUINTC_STATSETINT0_SI14_SHIFT (0x0000000Eu)
#define CSL_PRUINTC_STATSETINT0_SI14_RESETVAL (0x00000000u)
/*----SI14 Tokens----*/
#define CSL_PRUINTC_STATSETINT0_SI14_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT0_SI14_SET (0x00000001u)

#define CSL_PRUINTC_STATSETINT0_SI13_MASK (0x00002000u)
#define CSL_PRUINTC_STATSETINT0_SI13_SHIFT (0x0000000Du)
#define CSL_PRUINTC_STATSETINT0_SI13_RESETVAL (0x00000000u)
/*----SI13 Tokens----*/
#define CSL_PRUINTC_STATSETINT0_SI13_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT0_SI13_SET (0x00000001u)

#define CSL_PRUINTC_STATSETINT0_SI12_MASK (0x00001000u)
#define CSL_PRUINTC_STATSETINT0_SI12_SHIFT (0x0000000Cu)
#define CSL_PRUINTC_STATSETINT0_SI12_RESETVAL (0x00000000u)
/*----SI12 Tokens----*/
#define CSL_PRUINTC_STATSETINT0_SI12_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT0_SI12_SET (0x00000001u)

#define CSL_PRUINTC_STATSETINT0_SI11_MASK (0x00000800u)
#define CSL_PRUINTC_STATSETINT0_SI11_SHIFT (0x0000000Bu)
#define CSL_PRUINTC_STATSETINT0_SI11_RESETVAL (0x00000000u)
/*----SI11 Tokens----*/
#define CSL_PRUINTC_STATSETINT0_SI11_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT0_SI11_SET (0x00000001u)

#define CSL_PRUINTC_STATSETINT0_SI10_MASK (0x00000400u)
#define CSL_PRUINTC_STATSETINT0_SI10_SHIFT (0x0000000Au)
#define CSL_PRUINTC_STATSETINT0_SI10_RESETVAL (0x00000000u)
/*----SI10 Tokens----*/
#define CSL_PRUINTC_STATSETINT0_SI10_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT0_SI10_SET (0x00000001u)

#define CSL_PRUINTC_STATSETINT0_SI9_MASK (0x00000200u)
#define CSL_PRUINTC_STATSETINT0_SI9_SHIFT (0x00000009u)
#define CSL_PRUINTC_STATSETINT0_SI9_RESETVAL (0x00000000u)
/*----SI9 Tokens----*/
#define CSL_PRUINTC_STATSETINT0_SI9_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT0_SI9_SET  (0x00000001u)

#define CSL_PRUINTC_STATSETINT0_SI8_MASK (0x00000100u)
#define CSL_PRUINTC_STATSETINT0_SI8_SHIFT (0x00000008u)
#define CSL_PRUINTC_STATSETINT0_SI8_RESETVAL (0x00000000u)
/*----SI8 Tokens----*/
#define CSL_PRUINTC_STATSETINT0_SI8_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT0_SI8_SET  (0x00000001u)

#define CSL_PRUINTC_STATSETINT0_SI7_MASK (0x00000080u)
#define CSL_PRUINTC_STATSETINT0_SI7_SHIFT (0x00000007u)
#define CSL_PRUINTC_STATSETINT0_SI7_RESETVAL (0x00000000u)
/*----SI7 Tokens----*/
#define CSL_PRUINTC_STATSETINT0_SI7_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT0_SI7_SET  (0x00000001u)

#define CSL_PRUINTC_STATSETINT0_SI6_MASK (0x00000040u)
#define CSL_PRUINTC_STATSETINT0_SI6_SHIFT (0x00000006u)
#define CSL_PRUINTC_STATSETINT0_SI6_RESETVAL (0x00000000u)
/*----SI6 Tokens----*/
#define CSL_PRUINTC_STATSETINT0_SI6_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT0_SI6_SET  (0x00000001u)

#define CSL_PRUINTC_STATSETINT0_SI5_MASK (0x00000020u)
#define CSL_PRUINTC_STATSETINT0_SI5_SHIFT (0x00000005u)
#define CSL_PRUINTC_STATSETINT0_SI5_RESETVAL (0x00000000u)
/*----SI5 Tokens----*/
#define CSL_PRUINTC_STATSETINT0_SI5_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT0_SI5_SET  (0x00000001u)

#define CSL_PRUINTC_STATSETINT0_SI4_MASK (0x00000010u)
#define CSL_PRUINTC_STATSETINT0_SI4_SHIFT (0x00000004u)
#define CSL_PRUINTC_STATSETINT0_SI4_RESETVAL (0x00000000u)
/*----SI4 Tokens----*/
#define CSL_PRUINTC_STATSETINT0_SI4_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT0_SI4_SET  (0x00000001u)

#define CSL_PRUINTC_STATSETINT0_SI3_MASK (0x00000008u)
#define CSL_PRUINTC_STATSETINT0_SI3_SHIFT (0x00000003u)
#define CSL_PRUINTC_STATSETINT0_SI3_RESETVAL (0x00000000u)
/*----SI3 Tokens----*/
#define CSL_PRUINTC_STATSETINT0_SI3_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT0_SI3_SET  (0x00000001u)

#define CSL_PRUINTC_STATSETINT0_SI2_MASK (0x00000004u)
#define CSL_PRUINTC_STATSETINT0_SI2_SHIFT (0x00000002u)
#define CSL_PRUINTC_STATSETINT0_SI2_RESETVAL (0x00000000u)
/*----SI2 Tokens----*/
#define CSL_PRUINTC_STATSETINT0_SI2_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT0_SI2_SET  (0x00000001u)

#define CSL_PRUINTC_STATSETINT0_SI1_MASK (0x00000002u)
#define CSL_PRUINTC_STATSETINT0_SI1_SHIFT (0x00000001u)
#define CSL_PRUINTC_STATSETINT0_SI1_RESETVAL (0x00000000u)
/*----SI1 Tokens----*/
#define CSL_PRUINTC_STATSETINT0_SI1_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT0_SI1_SET  (0x00000001u)

#define CSL_PRUINTC_STATSETINT0_SI0_MASK (0x00000001u)
#define CSL_PRUINTC_STATSETINT0_SI0_SHIFT (0x00000000u)
#define CSL_PRUINTC_STATSETINT0_SI0_RESETVAL (0x00000000u)
/*----SI0 Tokens----*/
#define CSL_PRUINTC_STATSETINT0_SI0_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT0_SI0_SET  (0x00000001u)

#define CSL_PRUINTC_STATSETINT0_RESETVAL (0x00000000u)

/* STATSETINT1 */

#define CSL_PRUINTC_STATSETINT1_SI63_MASK (0x80000000u)
#define CSL_PRUINTC_STATSETINT1_SI63_SHIFT (0x0000001Fu)
#define CSL_PRUINTC_STATSETINT1_SI63_RESETVAL (0x00000000u)
/*----SI63 Tokens----*/
#define CSL_PRUINTC_STATSETINT1_SI63_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT1_SI63_SET (0x00000001u)

#define CSL_PRUINTC_STATSETINT1_SI62_MASK (0x40000000u)
#define CSL_PRUINTC_STATSETINT1_SI62_SHIFT (0x0000001Eu)
#define CSL_PRUINTC_STATSETINT1_SI62_RESETVAL (0x00000000u)
/*----SI62 Tokens----*/
#define CSL_PRUINTC_STATSETINT1_SI62_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT1_SI62_SET (0x00000001u)

#define CSL_PRUINTC_STATSETINT1_SI61_MASK (0x20000000u)
#define CSL_PRUINTC_STATSETINT1_SI61_SHIFT (0x0000001Du)
#define CSL_PRUINTC_STATSETINT1_SI61_RESETVAL (0x00000000u)
/*----SI61 Tokens----*/
#define CSL_PRUINTC_STATSETINT1_SI61_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT1_SI61_SET (0x00000001u)

#define CSL_PRUINTC_STATSETINT1_SI60_MASK (0x10000000u)
#define CSL_PRUINTC_STATSETINT1_SI60_SHIFT (0x0000001Cu)
#define CSL_PRUINTC_STATSETINT1_SI60_RESETVAL (0x00000000u)
/*----SI60 Tokens----*/
#define CSL_PRUINTC_STATSETINT1_SI60_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT1_SI60_SET (0x00000001u)

#define CSL_PRUINTC_STATSETINT1_SI59_MASK (0x08000000u)
#define CSL_PRUINTC_STATSETINT1_SI59_SHIFT (0x0000001Bu)
#define CSL_PRUINTC_STATSETINT1_SI59_RESETVAL (0x00000000u)
/*----SI59 Tokens----*/
#define CSL_PRUINTC_STATSETINT1_SI59_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT1_SI59_SET (0x00000001u)

#define CSL_PRUINTC_STATSETINT1_SI58_MASK (0x04000000u)
#define CSL_PRUINTC_STATSETINT1_SI58_SHIFT (0x0000001Au)
#define CSL_PRUINTC_STATSETINT1_SI58_RESETVAL (0x00000000u)
/*----SI58 Tokens----*/
#define CSL_PRUINTC_STATSETINT1_SI58_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT1_SI58_SET (0x00000001u)

#define CSL_PRUINTC_STATSETINT1_SI57_MASK (0x02000000u)
#define CSL_PRUINTC_STATSETINT1_SI57_SHIFT (0x00000019u)
#define CSL_PRUINTC_STATSETINT1_SI57_RESETVAL (0x00000000u)
/*----SI57 Tokens----*/
#define CSL_PRUINTC_STATSETINT1_SI57_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT1_SI57_SET (0x00000001u)

#define CSL_PRUINTC_STATSETINT1_SI56_MASK (0x01000000u)
#define CSL_PRUINTC_STATSETINT1_SI56_SHIFT (0x00000018u)
#define CSL_PRUINTC_STATSETINT1_SI56_RESETVAL (0x00000000u)
/*----SI56 Tokens----*/
#define CSL_PRUINTC_STATSETINT1_SI56_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT1_SI56_SET (0x00000001u)

#define CSL_PRUINTC_STATSETINT1_SI55_MASK (0x00800000u)
#define CSL_PRUINTC_STATSETINT1_SI55_SHIFT (0x00000017u)
#define CSL_PRUINTC_STATSETINT1_SI55_RESETVAL (0x00000000u)
/*----SI55 Tokens----*/
#define CSL_PRUINTC_STATSETINT1_SI55_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT1_SI55_SET (0x00000001u)

#define CSL_PRUINTC_STATSETINT1_SI54_MASK (0x00400000u)
#define CSL_PRUINTC_STATSETINT1_SI54_SHIFT (0x00000016u)
#define CSL_PRUINTC_STATSETINT1_SI54_RESETVAL (0x00000000u)
/*----SI54 Tokens----*/
#define CSL_PRUINTC_STATSETINT1_SI54_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT1_SI54_SET (0x00000001u)

#define CSL_PRUINTC_STATSETINT1_SI53_MASK (0x00200000u)
#define CSL_PRUINTC_STATSETINT1_SI53_SHIFT (0x00000015u)
#define CSL_PRUINTC_STATSETINT1_SI53_RESETVAL (0x00000000u)
/*----SI53 Tokens----*/
#define CSL_PRUINTC_STATSETINT1_SI53_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT1_SI53_SET (0x00000001u)

#define CSL_PRUINTC_STATSETINT1_SI52_MASK (0x00100000u)
#define CSL_PRUINTC_STATSETINT1_SI52_SHIFT (0x00000014u)
#define CSL_PRUINTC_STATSETINT1_SI52_RESETVAL (0x00000000u)
/*----SI52 Tokens----*/
#define CSL_PRUINTC_STATSETINT1_SI52_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT1_SI52_SET (0x00000001u)

#define CSL_PRUINTC_STATSETINT1_SI51_MASK (0x00080000u)
#define CSL_PRUINTC_STATSETINT1_SI51_SHIFT (0x00000013u)
#define CSL_PRUINTC_STATSETINT1_SI51_RESETVAL (0x00000000u)
/*----SI51 Tokens----*/
#define CSL_PRUINTC_STATSETINT1_SI51_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT1_SI51_SET (0x00000001u)

#define CSL_PRUINTC_STATSETINT1_SI50_MASK (0x00040000u)
#define CSL_PRUINTC_STATSETINT1_SI50_SHIFT (0x00000012u)
#define CSL_PRUINTC_STATSETINT1_SI50_RESETVAL (0x00000000u)
/*----SI50 Tokens----*/
#define CSL_PRUINTC_STATSETINT1_SI50_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT1_SI50_SET (0x00000001u)

#define CSL_PRUINTC_STATSETINT1_SI49_MASK (0x00020000u)
#define CSL_PRUINTC_STATSETINT1_SI49_SHIFT (0x00000011u)
#define CSL_PRUINTC_STATSETINT1_SI49_RESETVAL (0x00000000u)
/*----SI49 Tokens----*/
#define CSL_PRUINTC_STATSETINT1_SI49_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT1_SI49_SET (0x00000001u)

#define CSL_PRUINTC_STATSETINT1_SI48_MASK (0x00010000u)
#define CSL_PRUINTC_STATSETINT1_SI48_SHIFT (0x00000010u)
#define CSL_PRUINTC_STATSETINT1_SI48_RESETVAL (0x00000000u)
/*----SI48 Tokens----*/
#define CSL_PRUINTC_STATSETINT1_SI48_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT1_SI48_SET (0x00000001u)

#define CSL_PRUINTC_STATSETINT1_SI47_MASK (0x00008000u)
#define CSL_PRUINTC_STATSETINT1_SI47_SHIFT (0x0000000Fu)
#define CSL_PRUINTC_STATSETINT1_SI47_RESETVAL (0x00000000u)
/*----SI47 Tokens----*/
#define CSL_PRUINTC_STATSETINT1_SI47_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT1_SI47_SET (0x00000001u)

#define CSL_PRUINTC_STATSETINT1_SI46_MASK (0x00004000u)
#define CSL_PRUINTC_STATSETINT1_SI46_SHIFT (0x0000000Eu)
#define CSL_PRUINTC_STATSETINT1_SI46_RESETVAL (0x00000000u)
/*----SI46 Tokens----*/
#define CSL_PRUINTC_STATSETINT1_SI46_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT1_SI46_SET (0x00000001u)

#define CSL_PRUINTC_STATSETINT1_SI45_MASK (0x00002000u)
#define CSL_PRUINTC_STATSETINT1_SI45_SHIFT (0x0000000Du)
#define CSL_PRUINTC_STATSETINT1_SI45_RESETVAL (0x00000000u)
/*----SI45 Tokens----*/
#define CSL_PRUINTC_STATSETINT1_SI45_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT1_SI45_SET (0x00000001u)

#define CSL_PRUINTC_STATSETINT1_SI44_MASK (0x00001000u)
#define CSL_PRUINTC_STATSETINT1_SI44_SHIFT (0x0000000Cu)
#define CSL_PRUINTC_STATSETINT1_SI44_RESETVAL (0x00000000u)
/*----SI44 Tokens----*/
#define CSL_PRUINTC_STATSETINT1_SI44_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT1_SI44_SET (0x00000001u)

#define CSL_PRUINTC_STATSETINT1_SI43_MASK (0x00000800u)
#define CSL_PRUINTC_STATSETINT1_SI43_SHIFT (0x0000000Bu)
#define CSL_PRUINTC_STATSETINT1_SI43_RESETVAL (0x00000000u)
/*----SI43 Tokens----*/
#define CSL_PRUINTC_STATSETINT1_SI43_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT1_SI43_SET (0x00000001u)

#define CSL_PRUINTC_STATSETINT1_SI42_MASK (0x00000400u)
#define CSL_PRUINTC_STATSETINT1_SI42_SHIFT (0x0000000Au)
#define CSL_PRUINTC_STATSETINT1_SI42_RESETVAL (0x00000000u)
/*----SI42 Tokens----*/
#define CSL_PRUINTC_STATSETINT1_SI42_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT1_SI42_SET (0x00000001u)

#define CSL_PRUINTC_STATSETINT1_SI41_MASK (0x00000200u)
#define CSL_PRUINTC_STATSETINT1_SI41_SHIFT (0x00000009u)
#define CSL_PRUINTC_STATSETINT1_SI41_RESETVAL (0x00000000u)
/*----SI41 Tokens----*/
#define CSL_PRUINTC_STATSETINT1_SI41_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT1_SI41_SET (0x00000001u)

#define CSL_PRUINTC_STATSETINT1_SI40_MASK (0x00000100u)
#define CSL_PRUINTC_STATSETINT1_SI40_SHIFT (0x00000008u)
#define CSL_PRUINTC_STATSETINT1_SI40_RESETVAL (0x00000000u)
/*----SI40 Tokens----*/
#define CSL_PRUINTC_STATSETINT1_SI40_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT1_SI40_SET (0x00000001u)

#define CSL_PRUINTC_STATSETINT1_SI39_MASK (0x00000080u)
#define CSL_PRUINTC_STATSETINT1_SI39_SHIFT (0x00000007u)
#define CSL_PRUINTC_STATSETINT1_SI39_RESETVAL (0x00000000u)
/*----SI39 Tokens----*/
#define CSL_PRUINTC_STATSETINT1_SI39_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT1_SI39_SET (0x00000001u)

#define CSL_PRUINTC_STATSETINT1_SI38_MASK (0x00000040u)
#define CSL_PRUINTC_STATSETINT1_SI38_SHIFT (0x00000006u)
#define CSL_PRUINTC_STATSETINT1_SI38_RESETVAL (0x00000000u)
/*----SI38 Tokens----*/
#define CSL_PRUINTC_STATSETINT1_SI38_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT1_SI38_SET (0x00000001u)

#define CSL_PRUINTC_STATSETINT1_SI37_MASK (0x00000020u)
#define CSL_PRUINTC_STATSETINT1_SI37_SHIFT (0x00000005u)
#define CSL_PRUINTC_STATSETINT1_SI37_RESETVAL (0x00000000u)
/*----SI37 Tokens----*/
#define CSL_PRUINTC_STATSETINT1_SI37_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT1_SI37_SET (0x00000001u)

#define CSL_PRUINTC_STATSETINT1_SI36_MASK (0x00000010u)
#define CSL_PRUINTC_STATSETINT1_SI36_SHIFT (0x00000004u)
#define CSL_PRUINTC_STATSETINT1_SI36_RESETVAL (0x00000000u)
/*----SI36 Tokens----*/
#define CSL_PRUINTC_STATSETINT1_SI36_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT1_SI36_SET (0x00000001u)

#define CSL_PRUINTC_STATSETINT1_SI35_MASK (0x00000008u)
#define CSL_PRUINTC_STATSETINT1_SI35_SHIFT (0x00000003u)
#define CSL_PRUINTC_STATSETINT1_SI35_RESETVAL (0x00000000u)
/*----SI35 Tokens----*/
#define CSL_PRUINTC_STATSETINT1_SI35_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT1_SI35_SET (0x00000001u)

#define CSL_PRUINTC_STATSETINT1_SI34_MASK (0x00000004u)
#define CSL_PRUINTC_STATSETINT1_SI34_SHIFT (0x00000002u)
#define CSL_PRUINTC_STATSETINT1_SI34_RESETVAL (0x00000000u)
/*----SI34 Tokens----*/
#define CSL_PRUINTC_STATSETINT1_SI34_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT1_SI34_SET (0x00000001u)

#define CSL_PRUINTC_STATSETINT1_SI33_MASK (0x00000002u)
#define CSL_PRUINTC_STATSETINT1_SI33_SHIFT (0x00000001u)
#define CSL_PRUINTC_STATSETINT1_SI33_RESETVAL (0x00000000u)
/*----SI33 Tokens----*/
#define CSL_PRUINTC_STATSETINT1_SI33_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT1_SI33_SET (0x00000001u)

#define CSL_PRUINTC_STATSETINT1_SI32_MASK (0x00000001u)
#define CSL_PRUINTC_STATSETINT1_SI32_SHIFT (0x00000000u)
#define CSL_PRUINTC_STATSETINT1_SI32_RESETVAL (0x00000000u)
/*----SI32 Tokens----*/
#define CSL_PRUINTC_STATSETINT1_SI32_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATSETINT1_SI32_SET (0x00000001u)

#define CSL_PRUINTC_STATSETINT1_RESETVAL (0x00000000u)

/* STATCLRINT0 */

#define CSL_PRUINTC_STATCLRINT0_SI31_MASK (0x80000000u)
#define CSL_PRUINTC_STATCLRINT0_SI31_SHIFT (0x0000001Fu)
#define CSL_PRUINTC_STATCLRINT0_SI31_RESETVAL (0x00000000u)
/*----SI31 Tokens----*/
#define CSL_PRUINTC_STATCLRINT0_SI31_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT0_SI31_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT0_SI30_MASK (0x40000000u)
#define CSL_PRUINTC_STATCLRINT0_SI30_SHIFT (0x0000001Eu)
#define CSL_PRUINTC_STATCLRINT0_SI30_RESETVAL (0x00000000u)
/*----SI30 Tokens----*/
#define CSL_PRUINTC_STATCLRINT0_SI30_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT0_SI30_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT0_SI29_MASK (0x20000000u)
#define CSL_PRUINTC_STATCLRINT0_SI29_SHIFT (0x0000001Du)
#define CSL_PRUINTC_STATCLRINT0_SI29_RESETVAL (0x00000000u)
/*----SI29 Tokens----*/
#define CSL_PRUINTC_STATCLRINT0_SI29_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT0_SI29_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT0_SI28_MASK (0x10000000u)
#define CSL_PRUINTC_STATCLRINT0_SI28_SHIFT (0x0000001Cu)
#define CSL_PRUINTC_STATCLRINT0_SI28_RESETVAL (0x00000000u)
/*----SI28 Tokens----*/
#define CSL_PRUINTC_STATCLRINT0_SI28_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT0_SI28_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT0_SI27_MASK (0x08000000u)
#define CSL_PRUINTC_STATCLRINT0_SI27_SHIFT (0x0000001Bu)
#define CSL_PRUINTC_STATCLRINT0_SI27_RESETVAL (0x00000000u)
/*----SI27 Tokens----*/
#define CSL_PRUINTC_STATCLRINT0_SI27_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT0_SI27_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT0_SI26_MASK (0x04000000u)
#define CSL_PRUINTC_STATCLRINT0_SI26_SHIFT (0x0000001Au)
#define CSL_PRUINTC_STATCLRINT0_SI26_RESETVAL (0x00000000u)
/*----SI26 Tokens----*/
#define CSL_PRUINTC_STATCLRINT0_SI26_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT0_SI26_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT0_SI25_MASK (0x02000000u)
#define CSL_PRUINTC_STATCLRINT0_SI25_SHIFT (0x00000019u)
#define CSL_PRUINTC_STATCLRINT0_SI25_RESETVAL (0x00000000u)
/*----SI25 Tokens----*/
#define CSL_PRUINTC_STATCLRINT0_SI25_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT0_SI25_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT0_SI24_MASK (0x01000000u)
#define CSL_PRUINTC_STATCLRINT0_SI24_SHIFT (0x00000018u)
#define CSL_PRUINTC_STATCLRINT0_SI24_RESETVAL (0x00000000u)
/*----SI24 Tokens----*/
#define CSL_PRUINTC_STATCLRINT0_SI24_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT0_SI24_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT0_SI23_MASK (0x00800000u)
#define CSL_PRUINTC_STATCLRINT0_SI23_SHIFT (0x00000017u)
#define CSL_PRUINTC_STATCLRINT0_SI23_RESETVAL (0x00000000u)
/*----SI23 Tokens----*/
#define CSL_PRUINTC_STATCLRINT0_SI23_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT0_SI23_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT0_SI22_MASK (0x00400000u)
#define CSL_PRUINTC_STATCLRINT0_SI22_SHIFT (0x00000016u)
#define CSL_PRUINTC_STATCLRINT0_SI22_RESETVAL (0x00000000u)
/*----SI22 Tokens----*/
#define CSL_PRUINTC_STATCLRINT0_SI22_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT0_SI22_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT0_SI21_MASK (0x00200000u)
#define CSL_PRUINTC_STATCLRINT0_SI21_SHIFT (0x00000015u)
#define CSL_PRUINTC_STATCLRINT0_SI21_RESETVAL (0x00000000u)
/*----SI21 Tokens----*/
#define CSL_PRUINTC_STATCLRINT0_SI21_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT0_SI21_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT0_SI20_MASK (0x00100000u)
#define CSL_PRUINTC_STATCLRINT0_SI20_SHIFT (0x00000014u)
#define CSL_PRUINTC_STATCLRINT0_SI20_RESETVAL (0x00000000u)
/*----SI20 Tokens----*/
#define CSL_PRUINTC_STATCLRINT0_SI20_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT0_SI20_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT0_SI19_MASK (0x00080000u)
#define CSL_PRUINTC_STATCLRINT0_SI19_SHIFT (0x00000013u)
#define CSL_PRUINTC_STATCLRINT0_SI19_RESETVAL (0x00000000u)
/*----SI19 Tokens----*/
#define CSL_PRUINTC_STATCLRINT0_SI19_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT0_SI19_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT0_SI18_MASK (0x00040000u)
#define CSL_PRUINTC_STATCLRINT0_SI18_SHIFT (0x00000012u)
#define CSL_PRUINTC_STATCLRINT0_SI18_RESETVAL (0x00000000u)
/*----SI18 Tokens----*/
#define CSL_PRUINTC_STATCLRINT0_SI18_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT0_SI18_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT0_SI17_MASK (0x00020000u)
#define CSL_PRUINTC_STATCLRINT0_SI17_SHIFT (0x00000011u)
#define CSL_PRUINTC_STATCLRINT0_SI17_RESETVAL (0x00000000u)
/*----SI17 Tokens----*/
#define CSL_PRUINTC_STATCLRINT0_SI17_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT0_SI17_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT0_SI16_MASK (0x00010000u)
#define CSL_PRUINTC_STATCLRINT0_SI16_SHIFT (0x00000010u)
#define CSL_PRUINTC_STATCLRINT0_SI16_RESETVAL (0x00000000u)
/*----SI16 Tokens----*/
#define CSL_PRUINTC_STATCLRINT0_SI16_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT0_SI16_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT0_SI15_MASK (0x00008000u)
#define CSL_PRUINTC_STATCLRINT0_SI15_SHIFT (0x0000000Fu)
#define CSL_PRUINTC_STATCLRINT0_SI15_RESETVAL (0x00000000u)
/*----SI15 Tokens----*/
#define CSL_PRUINTC_STATCLRINT0_SI15_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT0_SI15_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT0_SI14_MASK (0x00004000u)
#define CSL_PRUINTC_STATCLRINT0_SI14_SHIFT (0x0000000Eu)
#define CSL_PRUINTC_STATCLRINT0_SI14_RESETVAL (0x00000000u)
/*----SI14 Tokens----*/
#define CSL_PRUINTC_STATCLRINT0_SI14_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT0_SI14_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT0_SI13_MASK (0x00002000u)
#define CSL_PRUINTC_STATCLRINT0_SI13_SHIFT (0x0000000Du)
#define CSL_PRUINTC_STATCLRINT0_SI13_RESETVAL (0x00000000u)
/*----SI13 Tokens----*/
#define CSL_PRUINTC_STATCLRINT0_SI13_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT0_SI13_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT0_SI12_MASK (0x00001000u)
#define CSL_PRUINTC_STATCLRINT0_SI12_SHIFT (0x0000000Cu)
#define CSL_PRUINTC_STATCLRINT0_SI12_RESETVAL (0x00000000u)
/*----SI12 Tokens----*/
#define CSL_PRUINTC_STATCLRINT0_SI12_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT0_SI12_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT0_SI11_MASK (0x00000800u)
#define CSL_PRUINTC_STATCLRINT0_SI11_SHIFT (0x0000000Bu)
#define CSL_PRUINTC_STATCLRINT0_SI11_RESETVAL (0x00000000u)
/*----SI11 Tokens----*/
#define CSL_PRUINTC_STATCLRINT0_SI11_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT0_SI11_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT0_SI10_MASK (0x00000400u)
#define CSL_PRUINTC_STATCLRINT0_SI10_SHIFT (0x0000000Au)
#define CSL_PRUINTC_STATCLRINT0_SI10_RESETVAL (0x00000000u)
/*----SI10 Tokens----*/
#define CSL_PRUINTC_STATCLRINT0_SI10_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT0_SI10_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT0_SI9_MASK (0x00000200u)
#define CSL_PRUINTC_STATCLRINT0_SI9_SHIFT (0x00000009u)
#define CSL_PRUINTC_STATCLRINT0_SI9_RESETVAL (0x00000000u)
/*----SI9 Tokens----*/
#define CSL_PRUINTC_STATCLRINT0_SI9_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT0_SI9_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT0_SI8_MASK (0x00000100u)
#define CSL_PRUINTC_STATCLRINT0_SI8_SHIFT (0x00000008u)
#define CSL_PRUINTC_STATCLRINT0_SI8_RESETVAL (0x00000000u)
/*----SI8 Tokens----*/
#define CSL_PRUINTC_STATCLRINT0_SI8_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT0_SI8_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT0_SI7_MASK (0x00000080u)
#define CSL_PRUINTC_STATCLRINT0_SI7_SHIFT (0x00000007u)
#define CSL_PRUINTC_STATCLRINT0_SI7_RESETVAL (0x00000000u)
/*----SI7 Tokens----*/
#define CSL_PRUINTC_STATCLRINT0_SI7_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT0_SI7_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT0_SI6_MASK (0x00000040u)
#define CSL_PRUINTC_STATCLRINT0_SI6_SHIFT (0x00000006u)
#define CSL_PRUINTC_STATCLRINT0_SI6_RESETVAL (0x00000000u)
/*----SI6 Tokens----*/
#define CSL_PRUINTC_STATCLRINT0_SI6_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT0_SI6_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT0_SI5_MASK (0x00000020u)
#define CSL_PRUINTC_STATCLRINT0_SI5_SHIFT (0x00000005u)
#define CSL_PRUINTC_STATCLRINT0_SI5_RESETVAL (0x00000000u)
/*----SI5 Tokens----*/
#define CSL_PRUINTC_STATCLRINT0_SI5_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT0_SI5_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT0_SI4_MASK (0x00000010u)
#define CSL_PRUINTC_STATCLRINT0_SI4_SHIFT (0x00000004u)
#define CSL_PRUINTC_STATCLRINT0_SI4_RESETVAL (0x00000000u)
/*----SI4 Tokens----*/
#define CSL_PRUINTC_STATCLRINT0_SI4_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT0_SI4_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT0_SI3_MASK (0x00000008u)
#define CSL_PRUINTC_STATCLRINT0_SI3_SHIFT (0x00000003u)
#define CSL_PRUINTC_STATCLRINT0_SI3_RESETVAL (0x00000000u)
/*----SI3 Tokens----*/
#define CSL_PRUINTC_STATCLRINT0_SI3_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT0_SI3_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT0_SI2_MASK (0x00000004u)
#define CSL_PRUINTC_STATCLRINT0_SI2_SHIFT (0x00000002u)
#define CSL_PRUINTC_STATCLRINT0_SI2_RESETVAL (0x00000000u)
/*----SI2 Tokens----*/
#define CSL_PRUINTC_STATCLRINT0_SI2_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT0_SI2_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT0_SI1_MASK (0x00000002u)
#define CSL_PRUINTC_STATCLRINT0_SI1_SHIFT (0x00000001u)
#define CSL_PRUINTC_STATCLRINT0_SI1_RESETVAL (0x00000000u)
/*----SI1 Tokens----*/
#define CSL_PRUINTC_STATCLRINT0_SI1_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT0_SI1_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT0_SI0_MASK (0x00000001u)
#define CSL_PRUINTC_STATCLRINT0_SI0_SHIFT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT0_SI0_RESETVAL (0x00000000u)
/*----SI0 Tokens----*/
#define CSL_PRUINTC_STATCLRINT0_SI0_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT0_SI0_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT0_RESETVAL (0x00000000u)

/* STATCLRINT1 */

#define CSL_PRUINTC_STATCLRINT1_SI63_MASK (0x80000000u)
#define CSL_PRUINTC_STATCLRINT1_SI63_SHIFT (0x0000001Fu)
#define CSL_PRUINTC_STATCLRINT1_SI63_RESETVAL (0x00000000u)
/*----SI63 Tokens----*/
#define CSL_PRUINTC_STATCLRINT1_SI63_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT1_SI63_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT1_SI62_MASK (0x40000000u)
#define CSL_PRUINTC_STATCLRINT1_SI62_SHIFT (0x0000001Eu)
#define CSL_PRUINTC_STATCLRINT1_SI62_RESETVAL (0x00000000u)
/*----SI62 Tokens----*/
#define CSL_PRUINTC_STATCLRINT1_SI62_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT1_SI62_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT1_SI61_MASK (0x20000000u)
#define CSL_PRUINTC_STATCLRINT1_SI61_SHIFT (0x0000001Du)
#define CSL_PRUINTC_STATCLRINT1_SI61_RESETVAL (0x00000000u)
/*----SI61 Tokens----*/
#define CSL_PRUINTC_STATCLRINT1_SI61_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT1_SI61_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT1_SI60_MASK (0x10000000u)
#define CSL_PRUINTC_STATCLRINT1_SI60_SHIFT (0x0000001Cu)
#define CSL_PRUINTC_STATCLRINT1_SI60_RESETVAL (0x00000000u)
/*----SI60 Tokens----*/
#define CSL_PRUINTC_STATCLRINT1_SI60_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT1_SI60_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT1_SI59_MASK (0x08000000u)
#define CSL_PRUINTC_STATCLRINT1_SI59_SHIFT (0x0000001Bu)
#define CSL_PRUINTC_STATCLRINT1_SI59_RESETVAL (0x00000000u)
/*----SI59 Tokens----*/
#define CSL_PRUINTC_STATCLRINT1_SI59_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT1_SI59_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT1_SI58_MASK (0x04000000u)
#define CSL_PRUINTC_STATCLRINT1_SI58_SHIFT (0x0000001Au)
#define CSL_PRUINTC_STATCLRINT1_SI58_RESETVAL (0x00000000u)
/*----SI58 Tokens----*/
#define CSL_PRUINTC_STATCLRINT1_SI58_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT1_SI58_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT1_SI57_MASK (0x02000000u)
#define CSL_PRUINTC_STATCLRINT1_SI57_SHIFT (0x00000019u)
#define CSL_PRUINTC_STATCLRINT1_SI57_RESETVAL (0x00000000u)
/*----SI57 Tokens----*/
#define CSL_PRUINTC_STATCLRINT1_SI57_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT1_SI57_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT1_SI56_MASK (0x01000000u)
#define CSL_PRUINTC_STATCLRINT1_SI56_SHIFT (0x00000018u)
#define CSL_PRUINTC_STATCLRINT1_SI56_RESETVAL (0x00000000u)
/*----SI56 Tokens----*/
#define CSL_PRUINTC_STATCLRINT1_SI56_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT1_SI56_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT1_SI55_MASK (0x00800000u)
#define CSL_PRUINTC_STATCLRINT1_SI55_SHIFT (0x00000017u)
#define CSL_PRUINTC_STATCLRINT1_SI55_RESETVAL (0x00000000u)
/*----SI55 Tokens----*/
#define CSL_PRUINTC_STATCLRINT1_SI55_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT1_SI55_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT1_SI54_MASK (0x00400000u)
#define CSL_PRUINTC_STATCLRINT1_SI54_SHIFT (0x00000016u)
#define CSL_PRUINTC_STATCLRINT1_SI54_RESETVAL (0x00000000u)
/*----SI54 Tokens----*/
#define CSL_PRUINTC_STATCLRINT1_SI54_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT1_SI54_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT1_SI53_MASK (0x00200000u)
#define CSL_PRUINTC_STATCLRINT1_SI53_SHIFT (0x00000015u)
#define CSL_PRUINTC_STATCLRINT1_SI53_RESETVAL (0x00000000u)
/*----SI53 Tokens----*/
#define CSL_PRUINTC_STATCLRINT1_SI53_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT1_SI53_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT1_SI52_MASK (0x00100000u)
#define CSL_PRUINTC_STATCLRINT1_SI52_SHIFT (0x00000014u)
#define CSL_PRUINTC_STATCLRINT1_SI52_RESETVAL (0x00000000u)
/*----SI52 Tokens----*/
#define CSL_PRUINTC_STATCLRINT1_SI52_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT1_SI52_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT1_SI51_MASK (0x00080000u)
#define CSL_PRUINTC_STATCLRINT1_SI51_SHIFT (0x00000013u)
#define CSL_PRUINTC_STATCLRINT1_SI51_RESETVAL (0x00000000u)
/*----SI51 Tokens----*/
#define CSL_PRUINTC_STATCLRINT1_SI51_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT1_SI51_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT1_SI50_MASK (0x00040000u)
#define CSL_PRUINTC_STATCLRINT1_SI50_SHIFT (0x00000012u)
#define CSL_PRUINTC_STATCLRINT1_SI50_RESETVAL (0x00000000u)
/*----SI50 Tokens----*/
#define CSL_PRUINTC_STATCLRINT1_SI50_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT1_SI50_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT1_SI49_MASK (0x00020000u)
#define CSL_PRUINTC_STATCLRINT1_SI49_SHIFT (0x00000011u)
#define CSL_PRUINTC_STATCLRINT1_SI49_RESETVAL (0x00000000u)
/*----SI49 Tokens----*/
#define CSL_PRUINTC_STATCLRINT1_SI49_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT1_SI49_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT1_SI48_MASK (0x00010000u)
#define CSL_PRUINTC_STATCLRINT1_SI48_SHIFT (0x00000010u)
#define CSL_PRUINTC_STATCLRINT1_SI48_RESETVAL (0x00000000u)
/*----SI48 Tokens----*/
#define CSL_PRUINTC_STATCLRINT1_SI48_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT1_SI48_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT1_SI47_MASK (0x00008000u)
#define CSL_PRUINTC_STATCLRINT1_SI47_SHIFT (0x0000000Fu)
#define CSL_PRUINTC_STATCLRINT1_SI47_RESETVAL (0x00000000u)
/*----SI47 Tokens----*/
#define CSL_PRUINTC_STATCLRINT1_SI47_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT1_SI47_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT1_SI46_MASK (0x00004000u)
#define CSL_PRUINTC_STATCLRINT1_SI46_SHIFT (0x0000000Eu)
#define CSL_PRUINTC_STATCLRINT1_SI46_RESETVAL (0x00000000u)
/*----SI46 Tokens----*/
#define CSL_PRUINTC_STATCLRINT1_SI46_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT1_SI46_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT1_SI45_MASK (0x00002000u)
#define CSL_PRUINTC_STATCLRINT1_SI45_SHIFT (0x0000000Du)
#define CSL_PRUINTC_STATCLRINT1_SI45_RESETVAL (0x00000000u)
/*----SI45 Tokens----*/
#define CSL_PRUINTC_STATCLRINT1_SI45_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT1_SI45_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT1_SI44_MASK (0x00001000u)
#define CSL_PRUINTC_STATCLRINT1_SI44_SHIFT (0x0000000Cu)
#define CSL_PRUINTC_STATCLRINT1_SI44_RESETVAL (0x00000000u)
/*----SI44 Tokens----*/
#define CSL_PRUINTC_STATCLRINT1_SI44_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT1_SI44_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT1_SI43_MASK (0x00000800u)
#define CSL_PRUINTC_STATCLRINT1_SI43_SHIFT (0x0000000Bu)
#define CSL_PRUINTC_STATCLRINT1_SI43_RESETVAL (0x00000000u)
/*----SI43 Tokens----*/
#define CSL_PRUINTC_STATCLRINT1_SI43_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT1_SI43_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT1_SI42_MASK (0x00000400u)
#define CSL_PRUINTC_STATCLRINT1_SI42_SHIFT (0x0000000Au)
#define CSL_PRUINTC_STATCLRINT1_SI42_RESETVAL (0x00000000u)
/*----SI42 Tokens----*/
#define CSL_PRUINTC_STATCLRINT1_SI42_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT1_SI42_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT1_SI41_MASK (0x00000200u)
#define CSL_PRUINTC_STATCLRINT1_SI41_SHIFT (0x00000009u)
#define CSL_PRUINTC_STATCLRINT1_SI41_RESETVAL (0x00000000u)
/*----SI41 Tokens----*/
#define CSL_PRUINTC_STATCLRINT1_SI41_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT1_SI41_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT1_SI40_MASK (0x00000100u)
#define CSL_PRUINTC_STATCLRINT1_SI40_SHIFT (0x00000008u)
#define CSL_PRUINTC_STATCLRINT1_SI40_RESETVAL (0x00000000u)
/*----SI40 Tokens----*/
#define CSL_PRUINTC_STATCLRINT1_SI40_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT1_SI40_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT1_SI39_MASK (0x00000080u)
#define CSL_PRUINTC_STATCLRINT1_SI39_SHIFT (0x00000007u)
#define CSL_PRUINTC_STATCLRINT1_SI39_RESETVAL (0x00000000u)
/*----SI39 Tokens----*/
#define CSL_PRUINTC_STATCLRINT1_SI39_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT1_SI39_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT1_SI38_MASK (0x00000040u)
#define CSL_PRUINTC_STATCLRINT1_SI38_SHIFT (0x00000006u)
#define CSL_PRUINTC_STATCLRINT1_SI38_RESETVAL (0x00000000u)
/*----SI38 Tokens----*/
#define CSL_PRUINTC_STATCLRINT1_SI38_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT1_SI38_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT1_SI37_MASK (0x00000020u)
#define CSL_PRUINTC_STATCLRINT1_SI37_SHIFT (0x00000005u)
#define CSL_PRUINTC_STATCLRINT1_SI37_RESETVAL (0x00000000u)
/*----SI37 Tokens----*/
#define CSL_PRUINTC_STATCLRINT1_SI37_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT1_SI37_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT1_SI36_MASK (0x00000010u)
#define CSL_PRUINTC_STATCLRINT1_SI36_SHIFT (0x00000004u)
#define CSL_PRUINTC_STATCLRINT1_SI36_RESETVAL (0x00000000u)
/*----SI36 Tokens----*/
#define CSL_PRUINTC_STATCLRINT1_SI36_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT1_SI36_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT1_SI35_MASK (0x00000008u)
#define CSL_PRUINTC_STATCLRINT1_SI35_SHIFT (0x00000003u)
#define CSL_PRUINTC_STATCLRINT1_SI35_RESETVAL (0x00000000u)
/*----SI35 Tokens----*/
#define CSL_PRUINTC_STATCLRINT1_SI35_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT1_SI35_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT1_SI34_MASK (0x00000004u)
#define CSL_PRUINTC_STATCLRINT1_SI34_SHIFT (0x00000002u)
#define CSL_PRUINTC_STATCLRINT1_SI34_RESETVAL (0x00000000u)
/*----SI34 Tokens----*/
#define CSL_PRUINTC_STATCLRINT1_SI34_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT1_SI34_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT1_SI33_MASK (0x00000002u)
#define CSL_PRUINTC_STATCLRINT1_SI33_SHIFT (0x00000001u)
#define CSL_PRUINTC_STATCLRINT1_SI33_RESETVAL (0x00000000u)
/*----SI33 Tokens----*/
#define CSL_PRUINTC_STATCLRINT1_SI33_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT1_SI33_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT1_SI32_MASK (0x00000001u)
#define CSL_PRUINTC_STATCLRINT1_SI32_SHIFT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT1_SI32_RESETVAL (0x00000000u)
/*----SI32 Tokens----*/
#define CSL_PRUINTC_STATCLRINT1_SI32_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_STATCLRINT1_SI32_CLEAR (0x00000001u)

#define CSL_PRUINTC_STATCLRINT1_RESETVAL (0x00000000u)

/* ENABLESET0 */

#define CSL_PRUINTC_ENABLESET0_SI31_MASK (0x80000000u)
#define CSL_PRUINTC_ENABLESET0_SI31_SHIFT (0x0000001Fu)
#define CSL_PRUINTC_ENABLESET0_SI31_RESETVAL (0x00000000u)
/*----SI31 Tokens----*/
#define CSL_PRUINTC_ENABLESET0_SI31_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET0_SI31_SET  (0x00000001u)

#define CSL_PRUINTC_ENABLESET0_SI30_MASK (0x40000000u)
#define CSL_PRUINTC_ENABLESET0_SI30_SHIFT (0x0000001Eu)
#define CSL_PRUINTC_ENABLESET0_SI30_RESETVAL (0x00000000u)
/*----SI30 Tokens----*/
#define CSL_PRUINTC_ENABLESET0_SI30_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET0_SI30_SET  (0x00000001u)

#define CSL_PRUINTC_ENABLESET0_SI29_MASK (0x20000000u)
#define CSL_PRUINTC_ENABLESET0_SI29_SHIFT (0x0000001Du)
#define CSL_PRUINTC_ENABLESET0_SI29_RESETVAL (0x00000000u)
/*----SI29 Tokens----*/
#define CSL_PRUINTC_ENABLESET0_SI29_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET0_SI29_SET  (0x00000001u)

#define CSL_PRUINTC_ENABLESET0_SI28_MASK (0x10000000u)
#define CSL_PRUINTC_ENABLESET0_SI28_SHIFT (0x0000001Cu)
#define CSL_PRUINTC_ENABLESET0_SI28_RESETVAL (0x00000000u)
/*----SI28 Tokens----*/
#define CSL_PRUINTC_ENABLESET0_SI28_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET0_SI28_SET  (0x00000001u)

#define CSL_PRUINTC_ENABLESET0_SI27_MASK (0x08000000u)
#define CSL_PRUINTC_ENABLESET0_SI27_SHIFT (0x0000001Bu)
#define CSL_PRUINTC_ENABLESET0_SI27_RESETVAL (0x00000000u)
/*----SI27 Tokens----*/
#define CSL_PRUINTC_ENABLESET0_SI27_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET0_SI27_SET  (0x00000001u)

#define CSL_PRUINTC_ENABLESET0_SI26_MASK (0x04000000u)
#define CSL_PRUINTC_ENABLESET0_SI26_SHIFT (0x0000001Au)
#define CSL_PRUINTC_ENABLESET0_SI26_RESETVAL (0x00000000u)
/*----SI26 Tokens----*/
#define CSL_PRUINTC_ENABLESET0_SI26_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET0_SI26_SET  (0x00000001u)

#define CSL_PRUINTC_ENABLESET0_SI25_MASK (0x02000000u)
#define CSL_PRUINTC_ENABLESET0_SI25_SHIFT (0x00000019u)
#define CSL_PRUINTC_ENABLESET0_SI25_RESETVAL (0x00000000u)
/*----SI25 Tokens----*/
#define CSL_PRUINTC_ENABLESET0_SI25_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET0_SI25_SET  (0x00000001u)

#define CSL_PRUINTC_ENABLESET0_SI24_MASK (0x01000000u)
#define CSL_PRUINTC_ENABLESET0_SI24_SHIFT (0x00000018u)
#define CSL_PRUINTC_ENABLESET0_SI24_RESETVAL (0x00000000u)
/*----SI24 Tokens----*/
#define CSL_PRUINTC_ENABLESET0_SI24_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET0_SI24_SET  (0x00000001u)

#define CSL_PRUINTC_ENABLESET0_SI23_MASK (0x00800000u)
#define CSL_PRUINTC_ENABLESET0_SI23_SHIFT (0x00000017u)
#define CSL_PRUINTC_ENABLESET0_SI23_RESETVAL (0x00000000u)
/*----SI23 Tokens----*/
#define CSL_PRUINTC_ENABLESET0_SI23_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET0_SI23_SET  (0x00000001u)

#define CSL_PRUINTC_ENABLESET0_SI22_MASK (0x00400000u)
#define CSL_PRUINTC_ENABLESET0_SI22_SHIFT (0x00000016u)
#define CSL_PRUINTC_ENABLESET0_SI22_RESETVAL (0x00000000u)
/*----SI22 Tokens----*/
#define CSL_PRUINTC_ENABLESET0_SI22_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET0_SI22_SET  (0x00000001u)

#define CSL_PRUINTC_ENABLESET0_SI21_MASK (0x00200000u)
#define CSL_PRUINTC_ENABLESET0_SI21_SHIFT (0x00000015u)
#define CSL_PRUINTC_ENABLESET0_SI21_RESETVAL (0x00000000u)
/*----SI21 Tokens----*/
#define CSL_PRUINTC_ENABLESET0_SI21_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET0_SI21_SET  (0x00000001u)

#define CSL_PRUINTC_ENABLESET0_SI20_MASK (0x00100000u)
#define CSL_PRUINTC_ENABLESET0_SI20_SHIFT (0x00000014u)
#define CSL_PRUINTC_ENABLESET0_SI20_RESETVAL (0x00000000u)
/*----SI20 Tokens----*/
#define CSL_PRUINTC_ENABLESET0_SI20_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET0_SI20_SET  (0x00000001u)

#define CSL_PRUINTC_ENABLESET0_SI19_MASK (0x00080000u)
#define CSL_PRUINTC_ENABLESET0_SI19_SHIFT (0x00000013u)
#define CSL_PRUINTC_ENABLESET0_SI19_RESETVAL (0x00000000u)
/*----SI19 Tokens----*/
#define CSL_PRUINTC_ENABLESET0_SI19_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET0_SI19_SET  (0x00000001u)

#define CSL_PRUINTC_ENABLESET0_SI18_MASK (0x00040000u)
#define CSL_PRUINTC_ENABLESET0_SI18_SHIFT (0x00000012u)
#define CSL_PRUINTC_ENABLESET0_SI18_RESETVAL (0x00000000u)
/*----SI18 Tokens----*/
#define CSL_PRUINTC_ENABLESET0_SI18_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET0_SI18_SET  (0x00000001u)

#define CSL_PRUINTC_ENABLESET0_SI17_MASK (0x00020000u)
#define CSL_PRUINTC_ENABLESET0_SI17_SHIFT (0x00000011u)
#define CSL_PRUINTC_ENABLESET0_SI17_RESETVAL (0x00000000u)
/*----SI17 Tokens----*/
#define CSL_PRUINTC_ENABLESET0_SI17_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET0_SI17_SET  (0x00000001u)

#define CSL_PRUINTC_ENABLESET0_SI16_MASK (0x00010000u)
#define CSL_PRUINTC_ENABLESET0_SI16_SHIFT (0x00000010u)
#define CSL_PRUINTC_ENABLESET0_SI16_RESETVAL (0x00000000u)
/*----SI16 Tokens----*/
#define CSL_PRUINTC_ENABLESET0_SI16_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET0_SI16_SET  (0x00000001u)

#define CSL_PRUINTC_ENABLESET0_SI15_MASK (0x00008000u)
#define CSL_PRUINTC_ENABLESET0_SI15_SHIFT (0x0000000Fu)
#define CSL_PRUINTC_ENABLESET0_SI15_RESETVAL (0x00000000u)
/*----SI15 Tokens----*/
#define CSL_PRUINTC_ENABLESET0_SI15_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET0_SI15_SET  (0x00000001u)

#define CSL_PRUINTC_ENABLESET0_SI14_MASK (0x00004000u)
#define CSL_PRUINTC_ENABLESET0_SI14_SHIFT (0x0000000Eu)
#define CSL_PRUINTC_ENABLESET0_SI14_RESETVAL (0x00000000u)
/*----SI14 Tokens----*/
#define CSL_PRUINTC_ENABLESET0_SI14_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET0_SI14_SET  (0x00000001u)

#define CSL_PRUINTC_ENABLESET0_SI13_MASK (0x00002000u)
#define CSL_PRUINTC_ENABLESET0_SI13_SHIFT (0x0000000Du)
#define CSL_PRUINTC_ENABLESET0_SI13_RESETVAL (0x00000000u)
/*----SI13 Tokens----*/
#define CSL_PRUINTC_ENABLESET0_SI13_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET0_SI13_SET  (0x00000001u)

#define CSL_PRUINTC_ENABLESET0_SI12_MASK (0x00001000u)
#define CSL_PRUINTC_ENABLESET0_SI12_SHIFT (0x0000000Cu)
#define CSL_PRUINTC_ENABLESET0_SI12_RESETVAL (0x00000000u)
/*----SI12 Tokens----*/
#define CSL_PRUINTC_ENABLESET0_SI12_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET0_SI12_SET  (0x00000001u)

#define CSL_PRUINTC_ENABLESET0_SI11_MASK (0x00000800u)
#define CSL_PRUINTC_ENABLESET0_SI11_SHIFT (0x0000000Bu)
#define CSL_PRUINTC_ENABLESET0_SI11_RESETVAL (0x00000000u)
/*----SI11 Tokens----*/
#define CSL_PRUINTC_ENABLESET0_SI11_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET0_SI11_SET  (0x00000001u)

#define CSL_PRUINTC_ENABLESET0_SI10_MASK (0x00000400u)
#define CSL_PRUINTC_ENABLESET0_SI10_SHIFT (0x0000000Au)
#define CSL_PRUINTC_ENABLESET0_SI10_RESETVAL (0x00000000u)
/*----SI10 Tokens----*/
#define CSL_PRUINTC_ENABLESET0_SI10_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET0_SI10_SET  (0x00000001u)

#define CSL_PRUINTC_ENABLESET0_SI9_MASK  (0x00000200u)
#define CSL_PRUINTC_ENABLESET0_SI9_SHIFT (0x00000009u)
#define CSL_PRUINTC_ENABLESET0_SI9_RESETVAL (0x00000000u)
/*----SI9 Tokens----*/
#define CSL_PRUINTC_ENABLESET0_SI9_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET0_SI9_SET   (0x00000001u)

#define CSL_PRUINTC_ENABLESET0_SI8_MASK  (0x00000100u)
#define CSL_PRUINTC_ENABLESET0_SI8_SHIFT (0x00000008u)
#define CSL_PRUINTC_ENABLESET0_SI8_RESETVAL (0x00000000u)
/*----SI8 Tokens----*/
#define CSL_PRUINTC_ENABLESET0_SI8_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET0_SI8_SET   (0x00000001u)

#define CSL_PRUINTC_ENABLESET0_SI7_MASK  (0x00000080u)
#define CSL_PRUINTC_ENABLESET0_SI7_SHIFT (0x00000007u)
#define CSL_PRUINTC_ENABLESET0_SI7_RESETVAL (0x00000000u)
/*----SI7 Tokens----*/
#define CSL_PRUINTC_ENABLESET0_SI7_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET0_SI7_SET   (0x00000001u)

#define CSL_PRUINTC_ENABLESET0_SI6_MASK  (0x00000040u)
#define CSL_PRUINTC_ENABLESET0_SI6_SHIFT (0x00000006u)
#define CSL_PRUINTC_ENABLESET0_SI6_RESETVAL (0x00000000u)
/*----SI6 Tokens----*/
#define CSL_PRUINTC_ENABLESET0_SI6_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET0_SI6_SET   (0x00000001u)

#define CSL_PRUINTC_ENABLESET0_SI5_MASK  (0x00000020u)
#define CSL_PRUINTC_ENABLESET0_SI5_SHIFT (0x00000005u)
#define CSL_PRUINTC_ENABLESET0_SI5_RESETVAL (0x00000000u)
/*----SI5 Tokens----*/
#define CSL_PRUINTC_ENABLESET0_SI5_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET0_SI5_SET   (0x00000001u)

#define CSL_PRUINTC_ENABLESET0_SI4_MASK  (0x00000010u)
#define CSL_PRUINTC_ENABLESET0_SI4_SHIFT (0x00000004u)
#define CSL_PRUINTC_ENABLESET0_SI4_RESETVAL (0x00000000u)
/*----SI4 Tokens----*/
#define CSL_PRUINTC_ENABLESET0_SI4_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET0_SI4_SET   (0x00000001u)

#define CSL_PRUINTC_ENABLESET0_SI3_MASK  (0x00000008u)
#define CSL_PRUINTC_ENABLESET0_SI3_SHIFT (0x00000003u)
#define CSL_PRUINTC_ENABLESET0_SI3_RESETVAL (0x00000000u)
/*----SI3 Tokens----*/
#define CSL_PRUINTC_ENABLESET0_SI3_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET0_SI3_SET   (0x00000001u)

#define CSL_PRUINTC_ENABLESET0_SI2_MASK  (0x00000004u)
#define CSL_PRUINTC_ENABLESET0_SI2_SHIFT (0x00000002u)
#define CSL_PRUINTC_ENABLESET0_SI2_RESETVAL (0x00000000u)
/*----SI2 Tokens----*/
#define CSL_PRUINTC_ENABLESET0_SI2_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET0_SI2_SET   (0x00000001u)

#define CSL_PRUINTC_ENABLESET0_SI1_MASK  (0x00000002u)
#define CSL_PRUINTC_ENABLESET0_SI1_SHIFT (0x00000001u)
#define CSL_PRUINTC_ENABLESET0_SI1_RESETVAL (0x00000000u)
/*----SI1 Tokens----*/
#define CSL_PRUINTC_ENABLESET0_SI1_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET0_SI1_SET   (0x00000001u)

#define CSL_PRUINTC_ENABLESET0_SI0_MASK  (0x00000001u)
#define CSL_PRUINTC_ENABLESET0_SI0_SHIFT (0x00000000u)
#define CSL_PRUINTC_ENABLESET0_SI0_RESETVAL (0x00000000u)
/*----SI0 Tokens----*/
#define CSL_PRUINTC_ENABLESET0_SI0_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET0_SI0_SET   (0x00000001u)

#define CSL_PRUINTC_ENABLESET0_RESETVAL  (0x00000000u)

/* ENABLESET1 */

#define CSL_PRUINTC_ENABLESET1_SI63_MASK (0x80000000u)
#define CSL_PRUINTC_ENABLESET1_SI63_SHIFT (0x0000001Fu)
#define CSL_PRUINTC_ENABLESET1_SI63_RESETVAL (0x00000000u)
/*----SI63 Tokens----*/
#define CSL_PRUINTC_ENABLESET1_SI63_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET1_SI63_SET  (0x00000001u)

#define CSL_PRUINTC_ENABLESET1_SI62_MASK (0x40000000u)
#define CSL_PRUINTC_ENABLESET1_SI62_SHIFT (0x0000001Eu)
#define CSL_PRUINTC_ENABLESET1_SI62_RESETVAL (0x00000000u)
/*----SI62 Tokens----*/
#define CSL_PRUINTC_ENABLESET1_SI62_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET1_SI62_SET  (0x00000001u)

#define CSL_PRUINTC_ENABLESET1_SI61_MASK (0x20000000u)
#define CSL_PRUINTC_ENABLESET1_SI61_SHIFT (0x0000001Du)
#define CSL_PRUINTC_ENABLESET1_SI61_RESETVAL (0x00000000u)
/*----SI61 Tokens----*/
#define CSL_PRUINTC_ENABLESET1_SI61_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET1_SI61_SET  (0x00000001u)

#define CSL_PRUINTC_ENABLESET1_SI60_MASK (0x10000000u)
#define CSL_PRUINTC_ENABLESET1_SI60_SHIFT (0x0000001Cu)
#define CSL_PRUINTC_ENABLESET1_SI60_RESETVAL (0x00000000u)
/*----SI60 Tokens----*/
#define CSL_PRUINTC_ENABLESET1_SI60_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET1_SI60_SET  (0x00000001u)

#define CSL_PRUINTC_ENABLESET1_SI59_MASK (0x08000000u)
#define CSL_PRUINTC_ENABLESET1_SI59_SHIFT (0x0000001Bu)
#define CSL_PRUINTC_ENABLESET1_SI59_RESETVAL (0x00000000u)
/*----SI59 Tokens----*/
#define CSL_PRUINTC_ENABLESET1_SI59_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET1_SI59_SET  (0x00000001u)

#define CSL_PRUINTC_ENABLESET1_SI58_MASK (0x04000000u)
#define CSL_PRUINTC_ENABLESET1_SI58_SHIFT (0x0000001Au)
#define CSL_PRUINTC_ENABLESET1_SI58_RESETVAL (0x00000000u)
/*----SI58 Tokens----*/
#define CSL_PRUINTC_ENABLESET1_SI58_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET1_SI58_SET  (0x00000001u)

#define CSL_PRUINTC_ENABLESET1_SI57_MASK (0x02000000u)
#define CSL_PRUINTC_ENABLESET1_SI57_SHIFT (0x00000019u)
#define CSL_PRUINTC_ENABLESET1_SI57_RESETVAL (0x00000000u)
/*----SI57 Tokens----*/
#define CSL_PRUINTC_ENABLESET1_SI57_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET1_SI57_SET  (0x00000001u)

#define CSL_PRUINTC_ENABLESET1_SI56_MASK (0x01000000u)
#define CSL_PRUINTC_ENABLESET1_SI56_SHIFT (0x00000018u)
#define CSL_PRUINTC_ENABLESET1_SI56_RESETVAL (0x00000000u)
/*----SI56 Tokens----*/
#define CSL_PRUINTC_ENABLESET1_SI56_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET1_SI56_SET  (0x00000001u)

#define CSL_PRUINTC_ENABLESET1_SI55_MASK (0x00800000u)
#define CSL_PRUINTC_ENABLESET1_SI55_SHIFT (0x00000017u)
#define CSL_PRUINTC_ENABLESET1_SI55_RESETVAL (0x00000000u)
/*----SI55 Tokens----*/
#define CSL_PRUINTC_ENABLESET1_SI55_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET1_SI55_SET  (0x00000001u)

#define CSL_PRUINTC_ENABLESET1_SI54_MASK (0x00400000u)
#define CSL_PRUINTC_ENABLESET1_SI54_SHIFT (0x00000016u)
#define CSL_PRUINTC_ENABLESET1_SI54_RESETVAL (0x00000000u)
/*----SI54 Tokens----*/
#define CSL_PRUINTC_ENABLESET1_SI54_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET1_SI54_SET  (0x00000001u)

#define CSL_PRUINTC_ENABLESET1_SI53_MASK (0x00200000u)
#define CSL_PRUINTC_ENABLESET1_SI53_SHIFT (0x00000015u)
#define CSL_PRUINTC_ENABLESET1_SI53_RESETVAL (0x00000000u)
/*----SI53 Tokens----*/
#define CSL_PRUINTC_ENABLESET1_SI53_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET1_SI53_SET  (0x00000001u)

#define CSL_PRUINTC_ENABLESET1_SI52_MASK (0x00100000u)
#define CSL_PRUINTC_ENABLESET1_SI52_SHIFT (0x00000014u)
#define CSL_PRUINTC_ENABLESET1_SI52_RESETVAL (0x00000000u)
/*----SI52 Tokens----*/
#define CSL_PRUINTC_ENABLESET1_SI52_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET1_SI52_SET  (0x00000001u)

#define CSL_PRUINTC_ENABLESET1_SI51_MASK (0x00080000u)
#define CSL_PRUINTC_ENABLESET1_SI51_SHIFT (0x00000013u)
#define CSL_PRUINTC_ENABLESET1_SI51_RESETVAL (0x00000000u)
/*----SI51 Tokens----*/
#define CSL_PRUINTC_ENABLESET1_SI51_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET1_SI51_SET  (0x00000001u)

#define CSL_PRUINTC_ENABLESET1_SI50_MASK (0x00040000u)
#define CSL_PRUINTC_ENABLESET1_SI50_SHIFT (0x00000012u)
#define CSL_PRUINTC_ENABLESET1_SI50_RESETVAL (0x00000000u)
/*----SI50 Tokens----*/
#define CSL_PRUINTC_ENABLESET1_SI50_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET1_SI50_SET  (0x00000001u)

#define CSL_PRUINTC_ENABLESET1_SI49_MASK (0x00020000u)
#define CSL_PRUINTC_ENABLESET1_SI49_SHIFT (0x00000011u)
#define CSL_PRUINTC_ENABLESET1_SI49_RESETVAL (0x00000000u)
/*----SI49 Tokens----*/
#define CSL_PRUINTC_ENABLESET1_SI49_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET1_SI49_SET  (0x00000001u)

#define CSL_PRUINTC_ENABLESET1_SI48_MASK (0x00010000u)
#define CSL_PRUINTC_ENABLESET1_SI48_SHIFT (0x00000010u)
#define CSL_PRUINTC_ENABLESET1_SI48_RESETVAL (0x00000000u)
/*----SI48 Tokens----*/
#define CSL_PRUINTC_ENABLESET1_SI48_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET1_SI48_SET  (0x00000001u)

#define CSL_PRUINTC_ENABLESET1_SI47_MASK (0x00008000u)
#define CSL_PRUINTC_ENABLESET1_SI47_SHIFT (0x0000000Fu)
#define CSL_PRUINTC_ENABLESET1_SI47_RESETVAL (0x00000000u)
/*----SI47 Tokens----*/
#define CSL_PRUINTC_ENABLESET1_SI47_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET1_SI47_SET  (0x00000001u)

#define CSL_PRUINTC_ENABLESET1_SI46_MASK (0x00004000u)
#define CSL_PRUINTC_ENABLESET1_SI46_SHIFT (0x0000000Eu)
#define CSL_PRUINTC_ENABLESET1_SI46_RESETVAL (0x00000000u)
/*----SI46 Tokens----*/
#define CSL_PRUINTC_ENABLESET1_SI46_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET1_SI46_SET  (0x00000001u)

#define CSL_PRUINTC_ENABLESET1_SI45_MASK (0x00002000u)
#define CSL_PRUINTC_ENABLESET1_SI45_SHIFT (0x0000000Du)
#define CSL_PRUINTC_ENABLESET1_SI45_RESETVAL (0x00000000u)
/*----SI45 Tokens----*/
#define CSL_PRUINTC_ENABLESET1_SI45_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET1_SI45_SET  (0x00000001u)

#define CSL_PRUINTC_ENABLESET1_SI44_MASK (0x00001000u)
#define CSL_PRUINTC_ENABLESET1_SI44_SHIFT (0x0000000Cu)
#define CSL_PRUINTC_ENABLESET1_SI44_RESETVAL (0x00000000u)
/*----SI44 Tokens----*/
#define CSL_PRUINTC_ENABLESET1_SI44_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET1_SI44_SET  (0x00000001u)

#define CSL_PRUINTC_ENABLESET1_SI43_MASK (0x00000800u)
#define CSL_PRUINTC_ENABLESET1_SI43_SHIFT (0x0000000Bu)
#define CSL_PRUINTC_ENABLESET1_SI43_RESETVAL (0x00000000u)
/*----SI43 Tokens----*/
#define CSL_PRUINTC_ENABLESET1_SI43_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET1_SI43_SET  (0x00000001u)

#define CSL_PRUINTC_ENABLESET1_SI42_MASK (0x00000400u)
#define CSL_PRUINTC_ENABLESET1_SI42_SHIFT (0x0000000Au)
#define CSL_PRUINTC_ENABLESET1_SI42_RESETVAL (0x00000000u)
/*----SI42 Tokens----*/
#define CSL_PRUINTC_ENABLESET1_SI42_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET1_SI42_SET  (0x00000001u)

#define CSL_PRUINTC_ENABLESET1_SI41_MASK (0x00000200u)
#define CSL_PRUINTC_ENABLESET1_SI41_SHIFT (0x00000009u)
#define CSL_PRUINTC_ENABLESET1_SI41_RESETVAL (0x00000000u)
/*----SI41 Tokens----*/
#define CSL_PRUINTC_ENABLESET1_SI41_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET1_SI41_SET  (0x00000001u)

#define CSL_PRUINTC_ENABLESET1_SI40_MASK (0x00000100u)
#define CSL_PRUINTC_ENABLESET1_SI40_SHIFT (0x00000008u)
#define CSL_PRUINTC_ENABLESET1_SI40_RESETVAL (0x00000000u)
/*----SI40 Tokens----*/
#define CSL_PRUINTC_ENABLESET1_SI40_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET1_SI40_SET  (0x00000001u)

#define CSL_PRUINTC_ENABLESET1_SI39_MASK (0x00000080u)
#define CSL_PRUINTC_ENABLESET1_SI39_SHIFT (0x00000007u)
#define CSL_PRUINTC_ENABLESET1_SI39_RESETVAL (0x00000000u)
/*----SI39 Tokens----*/
#define CSL_PRUINTC_ENABLESET1_SI39_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET1_SI39_SET  (0x00000001u)

#define CSL_PRUINTC_ENABLESET1_SI38_MASK (0x00000040u)
#define CSL_PRUINTC_ENABLESET1_SI38_SHIFT (0x00000006u)
#define CSL_PRUINTC_ENABLESET1_SI38_RESETVAL (0x00000000u)
/*----SI38 Tokens----*/
#define CSL_PRUINTC_ENABLESET1_SI38_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET1_SI38_SET  (0x00000001u)

#define CSL_PRUINTC_ENABLESET1_SI37_MASK (0x00000020u)
#define CSL_PRUINTC_ENABLESET1_SI37_SHIFT (0x00000005u)
#define CSL_PRUINTC_ENABLESET1_SI37_RESETVAL (0x00000000u)
/*----SI37 Tokens----*/
#define CSL_PRUINTC_ENABLESET1_SI37_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET1_SI37_SET  (0x00000001u)

#define CSL_PRUINTC_ENABLESET1_SI36_MASK (0x00000010u)
#define CSL_PRUINTC_ENABLESET1_SI36_SHIFT (0x00000004u)
#define CSL_PRUINTC_ENABLESET1_SI36_RESETVAL (0x00000000u)
/*----SI36 Tokens----*/
#define CSL_PRUINTC_ENABLESET1_SI36_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET1_SI36_SET  (0x00000001u)

#define CSL_PRUINTC_ENABLESET1_SI35_MASK (0x00000008u)
#define CSL_PRUINTC_ENABLESET1_SI35_SHIFT (0x00000003u)
#define CSL_PRUINTC_ENABLESET1_SI35_RESETVAL (0x00000000u)
/*----SI35 Tokens----*/
#define CSL_PRUINTC_ENABLESET1_SI35_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET1_SI35_SET  (0x00000001u)

#define CSL_PRUINTC_ENABLESET1_SI34_MASK (0x00000004u)
#define CSL_PRUINTC_ENABLESET1_SI34_SHIFT (0x00000002u)
#define CSL_PRUINTC_ENABLESET1_SI34_RESETVAL (0x00000000u)
/*----SI34 Tokens----*/
#define CSL_PRUINTC_ENABLESET1_SI34_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET1_SI34_SET  (0x00000001u)

#define CSL_PRUINTC_ENABLESET1_SI33_MASK (0x00000002u)
#define CSL_PRUINTC_ENABLESET1_SI33_SHIFT (0x00000001u)
#define CSL_PRUINTC_ENABLESET1_SI33_RESETVAL (0x00000000u)
/*----SI33 Tokens----*/
#define CSL_PRUINTC_ENABLESET1_SI33_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET1_SI33_SET  (0x00000001u)

#define CSL_PRUINTC_ENABLESET1_SI32_MASK (0x00000001u)
#define CSL_PRUINTC_ENABLESET1_SI32_SHIFT (0x00000000u)
#define CSL_PRUINTC_ENABLESET1_SI32_RESETVAL (0x00000000u)
/*----SI32 Tokens----*/
#define CSL_PRUINTC_ENABLESET1_SI32_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLESET1_SI32_SET  (0x00000001u)

#define CSL_PRUINTC_ENABLESET1_RESETVAL  (0x00000000u)

/* ENABLECLR0 */

#define CSL_PRUINTC_ENABLECLR0_SI31_MASK (0x80000000u)
#define CSL_PRUINTC_ENABLECLR0_SI31_SHIFT (0x0000001Fu)
#define CSL_PRUINTC_ENABLECLR0_SI31_RESETVAL (0x00000000u)
/*----SI31 Tokens----*/
#define CSL_PRUINTC_ENABLECLR0_SI31_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR0_SI31_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR0_SI30_MASK (0x40000000u)
#define CSL_PRUINTC_ENABLECLR0_SI30_SHIFT (0x0000001Eu)
#define CSL_PRUINTC_ENABLECLR0_SI30_RESETVAL (0x00000000u)
/*----SI30 Tokens----*/
#define CSL_PRUINTC_ENABLECLR0_SI30_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR0_SI30_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR0_SI29_MASK (0x20000000u)
#define CSL_PRUINTC_ENABLECLR0_SI29_SHIFT (0x0000001Du)
#define CSL_PRUINTC_ENABLECLR0_SI29_RESETVAL (0x00000000u)
/*----SI29 Tokens----*/
#define CSL_PRUINTC_ENABLECLR0_SI29_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR0_SI29_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR0_SI28_MASK (0x10000000u)
#define CSL_PRUINTC_ENABLECLR0_SI28_SHIFT (0x0000001Cu)
#define CSL_PRUINTC_ENABLECLR0_SI28_RESETVAL (0x00000000u)
/*----SI28 Tokens----*/
#define CSL_PRUINTC_ENABLECLR0_SI28_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR0_SI28_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR0_SI27_MASK (0x08000000u)
#define CSL_PRUINTC_ENABLECLR0_SI27_SHIFT (0x0000001Bu)
#define CSL_PRUINTC_ENABLECLR0_SI27_RESETVAL (0x00000000u)
/*----SI27 Tokens----*/
#define CSL_PRUINTC_ENABLECLR0_SI27_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR0_SI27_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR0_SI26_MASK (0x04000000u)
#define CSL_PRUINTC_ENABLECLR0_SI26_SHIFT (0x0000001Au)
#define CSL_PRUINTC_ENABLECLR0_SI26_RESETVAL (0x00000000u)
/*----SI26 Tokens----*/
#define CSL_PRUINTC_ENABLECLR0_SI26_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR0_SI26_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR0_SI25_MASK (0x02000000u)
#define CSL_PRUINTC_ENABLECLR0_SI25_SHIFT (0x00000019u)
#define CSL_PRUINTC_ENABLECLR0_SI25_RESETVAL (0x00000000u)
/*----SI25 Tokens----*/
#define CSL_PRUINTC_ENABLECLR0_SI25_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR0_SI25_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR0_SI24_MASK (0x01000000u)
#define CSL_PRUINTC_ENABLECLR0_SI24_SHIFT (0x00000018u)
#define CSL_PRUINTC_ENABLECLR0_SI24_RESETVAL (0x00000000u)
/*----SI24 Tokens----*/
#define CSL_PRUINTC_ENABLECLR0_SI24_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR0_SI24_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR0_SI23_MASK (0x00800000u)
#define CSL_PRUINTC_ENABLECLR0_SI23_SHIFT (0x00000017u)
#define CSL_PRUINTC_ENABLECLR0_SI23_RESETVAL (0x00000000u)
/*----SI23 Tokens----*/
#define CSL_PRUINTC_ENABLECLR0_SI23_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR0_SI23_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR0_SI22_MASK (0x00400000u)
#define CSL_PRUINTC_ENABLECLR0_SI22_SHIFT (0x00000016u)
#define CSL_PRUINTC_ENABLECLR0_SI22_RESETVAL (0x00000000u)
/*----SI22 Tokens----*/
#define CSL_PRUINTC_ENABLECLR0_SI22_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR0_SI22_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR0_SI21_MASK (0x00200000u)
#define CSL_PRUINTC_ENABLECLR0_SI21_SHIFT (0x00000015u)
#define CSL_PRUINTC_ENABLECLR0_SI21_RESETVAL (0x00000000u)
/*----SI21 Tokens----*/
#define CSL_PRUINTC_ENABLECLR0_SI21_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR0_SI21_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR0_SI20_MASK (0x00100000u)
#define CSL_PRUINTC_ENABLECLR0_SI20_SHIFT (0x00000014u)
#define CSL_PRUINTC_ENABLECLR0_SI20_RESETVAL (0x00000000u)
/*----SI20 Tokens----*/
#define CSL_PRUINTC_ENABLECLR0_SI20_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR0_SI20_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR0_SI19_MASK (0x00080000u)
#define CSL_PRUINTC_ENABLECLR0_SI19_SHIFT (0x00000013u)
#define CSL_PRUINTC_ENABLECLR0_SI19_RESETVAL (0x00000000u)
/*----SI19 Tokens----*/
#define CSL_PRUINTC_ENABLECLR0_SI19_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR0_SI19_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR0_SI18_MASK (0x00040000u)
#define CSL_PRUINTC_ENABLECLR0_SI18_SHIFT (0x00000012u)
#define CSL_PRUINTC_ENABLECLR0_SI18_RESETVAL (0x00000000u)
/*----SI18 Tokens----*/
#define CSL_PRUINTC_ENABLECLR0_SI18_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR0_SI18_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR0_SI17_MASK (0x00020000u)
#define CSL_PRUINTC_ENABLECLR0_SI17_SHIFT (0x00000011u)
#define CSL_PRUINTC_ENABLECLR0_SI17_RESETVAL (0x00000000u)
/*----SI17 Tokens----*/
#define CSL_PRUINTC_ENABLECLR0_SI17_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR0_SI17_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR0_SI16_MASK (0x00010000u)
#define CSL_PRUINTC_ENABLECLR0_SI16_SHIFT (0x00000010u)
#define CSL_PRUINTC_ENABLECLR0_SI16_RESETVAL (0x00000000u)
/*----SI16 Tokens----*/
#define CSL_PRUINTC_ENABLECLR0_SI16_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR0_SI16_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR0_SI15_MASK (0x00008000u)
#define CSL_PRUINTC_ENABLECLR0_SI15_SHIFT (0x0000000Fu)
#define CSL_PRUINTC_ENABLECLR0_SI15_RESETVAL (0x00000000u)
/*----SI15 Tokens----*/
#define CSL_PRUINTC_ENABLECLR0_SI15_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR0_SI15_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR0_SI14_MASK (0x00004000u)
#define CSL_PRUINTC_ENABLECLR0_SI14_SHIFT (0x0000000Eu)
#define CSL_PRUINTC_ENABLECLR0_SI14_RESETVAL (0x00000000u)
/*----SI14 Tokens----*/
#define CSL_PRUINTC_ENABLECLR0_SI14_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR0_SI14_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR0_SI13_MASK (0x00002000u)
#define CSL_PRUINTC_ENABLECLR0_SI13_SHIFT (0x0000000Du)
#define CSL_PRUINTC_ENABLECLR0_SI13_RESETVAL (0x00000000u)
/*----SI13 Tokens----*/
#define CSL_PRUINTC_ENABLECLR0_SI13_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR0_SI13_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR0_SI12_MASK (0x00001000u)
#define CSL_PRUINTC_ENABLECLR0_SI12_SHIFT (0x0000000Cu)
#define CSL_PRUINTC_ENABLECLR0_SI12_RESETVAL (0x00000000u)
/*----SI12 Tokens----*/
#define CSL_PRUINTC_ENABLECLR0_SI12_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR0_SI12_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR0_SI11_MASK (0x00000800u)
#define CSL_PRUINTC_ENABLECLR0_SI11_SHIFT (0x0000000Bu)
#define CSL_PRUINTC_ENABLECLR0_SI11_RESETVAL (0x00000000u)
/*----SI11 Tokens----*/
#define CSL_PRUINTC_ENABLECLR0_SI11_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR0_SI11_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR0_SI10_MASK (0x00000400u)
#define CSL_PRUINTC_ENABLECLR0_SI10_SHIFT (0x0000000Au)
#define CSL_PRUINTC_ENABLECLR0_SI10_RESETVAL (0x00000000u)
/*----SI10 Tokens----*/
#define CSL_PRUINTC_ENABLECLR0_SI10_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR0_SI10_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR0_SI9_MASK  (0x00000200u)
#define CSL_PRUINTC_ENABLECLR0_SI9_SHIFT (0x00000009u)
#define CSL_PRUINTC_ENABLECLR0_SI9_RESETVAL (0x00000000u)
/*----SI9 Tokens----*/
#define CSL_PRUINTC_ENABLECLR0_SI9_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR0_SI9_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR0_SI8_MASK  (0x00000100u)
#define CSL_PRUINTC_ENABLECLR0_SI8_SHIFT (0x00000008u)
#define CSL_PRUINTC_ENABLECLR0_SI8_RESETVAL (0x00000000u)
/*----SI8 Tokens----*/
#define CSL_PRUINTC_ENABLECLR0_SI8_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR0_SI8_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR0_SI7_MASK  (0x00000080u)
#define CSL_PRUINTC_ENABLECLR0_SI7_SHIFT (0x00000007u)
#define CSL_PRUINTC_ENABLECLR0_SI7_RESETVAL (0x00000000u)
/*----SI7 Tokens----*/
#define CSL_PRUINTC_ENABLECLR0_SI7_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR0_SI7_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR0_SI6_MASK  (0x00000040u)
#define CSL_PRUINTC_ENABLECLR0_SI6_SHIFT (0x00000006u)
#define CSL_PRUINTC_ENABLECLR0_SI6_RESETVAL (0x00000000u)
/*----SI6 Tokens----*/
#define CSL_PRUINTC_ENABLECLR0_SI6_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR0_SI6_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR0_SI5_MASK  (0x00000020u)
#define CSL_PRUINTC_ENABLECLR0_SI5_SHIFT (0x00000005u)
#define CSL_PRUINTC_ENABLECLR0_SI5_RESETVAL (0x00000000u)
/*----SI5 Tokens----*/
#define CSL_PRUINTC_ENABLECLR0_SI5_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR0_SI5_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR0_SI4_MASK  (0x00000010u)
#define CSL_PRUINTC_ENABLECLR0_SI4_SHIFT (0x00000004u)
#define CSL_PRUINTC_ENABLECLR0_SI4_RESETVAL (0x00000000u)
/*----SI4 Tokens----*/
#define CSL_PRUINTC_ENABLECLR0_SI4_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR0_SI4_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR0_SI3_MASK  (0x00000008u)
#define CSL_PRUINTC_ENABLECLR0_SI3_SHIFT (0x00000003u)
#define CSL_PRUINTC_ENABLECLR0_SI3_RESETVAL (0x00000000u)
/*----SI3 Tokens----*/
#define CSL_PRUINTC_ENABLECLR0_SI3_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR0_SI3_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR0_SI2_MASK  (0x00000004u)
#define CSL_PRUINTC_ENABLECLR0_SI2_SHIFT (0x00000002u)
#define CSL_PRUINTC_ENABLECLR0_SI2_RESETVAL (0x00000000u)
/*----SI2 Tokens----*/
#define CSL_PRUINTC_ENABLECLR0_SI2_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR0_SI2_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR0_SI1_MASK  (0x00000002u)
#define CSL_PRUINTC_ENABLECLR0_SI1_SHIFT (0x00000001u)
#define CSL_PRUINTC_ENABLECLR0_SI1_RESETVAL (0x00000000u)
/*----SI1 Tokens----*/
#define CSL_PRUINTC_ENABLECLR0_SI1_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR0_SI1_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR0_SI0_MASK  (0x00000001u)
#define CSL_PRUINTC_ENABLECLR0_SI0_SHIFT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR0_SI0_RESETVAL (0x00000000u)
/*----SI0 Tokens----*/
#define CSL_PRUINTC_ENABLECLR0_SI0_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR0_SI0_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR0_RESETVAL  (0x00000000u)

/* ENABLECLR1 */

#define CSL_PRUINTC_ENABLECLR1_SI63_MASK (0x80000000u)
#define CSL_PRUINTC_ENABLECLR1_SI63_SHIFT (0x0000001Fu)
#define CSL_PRUINTC_ENABLECLR1_SI63_RESETVAL (0x00000000u)
/*----SI63 Tokens----*/
#define CSL_PRUINTC_ENABLECLR1_SI63_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR1_SI63_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR1_SI62_MASK (0x40000000u)
#define CSL_PRUINTC_ENABLECLR1_SI62_SHIFT (0x0000001Eu)
#define CSL_PRUINTC_ENABLECLR1_SI62_RESETVAL (0x00000000u)
/*----SI62 Tokens----*/
#define CSL_PRUINTC_ENABLECLR1_SI62_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR1_SI62_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR1_SI61_MASK (0x20000000u)
#define CSL_PRUINTC_ENABLECLR1_SI61_SHIFT (0x0000001Du)
#define CSL_PRUINTC_ENABLECLR1_SI61_RESETVAL (0x00000000u)
/*----SI61 Tokens----*/
#define CSL_PRUINTC_ENABLECLR1_SI61_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR1_SI61_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR1_SI60_MASK (0x10000000u)
#define CSL_PRUINTC_ENABLECLR1_SI60_SHIFT (0x0000001Cu)
#define CSL_PRUINTC_ENABLECLR1_SI60_RESETVAL (0x00000000u)
/*----SI60 Tokens----*/
#define CSL_PRUINTC_ENABLECLR1_SI60_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR1_SI60_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR1_SI59_MASK (0x08000000u)
#define CSL_PRUINTC_ENABLECLR1_SI59_SHIFT (0x0000001Bu)
#define CSL_PRUINTC_ENABLECLR1_SI59_RESETVAL (0x00000000u)
/*----SI59 Tokens----*/
#define CSL_PRUINTC_ENABLECLR1_SI59_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR1_SI59_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR1_SI58_MASK (0x04000000u)
#define CSL_PRUINTC_ENABLECLR1_SI58_SHIFT (0x0000001Au)
#define CSL_PRUINTC_ENABLECLR1_SI58_RESETVAL (0x00000000u)
/*----SI58 Tokens----*/
#define CSL_PRUINTC_ENABLECLR1_SI58_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR1_SI58_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR1_SI57_MASK (0x02000000u)
#define CSL_PRUINTC_ENABLECLR1_SI57_SHIFT (0x00000019u)
#define CSL_PRUINTC_ENABLECLR1_SI57_RESETVAL (0x00000000u)
/*----SI57 Tokens----*/
#define CSL_PRUINTC_ENABLECLR1_SI57_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR1_SI57_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR1_SI56_MASK (0x01000000u)
#define CSL_PRUINTC_ENABLECLR1_SI56_SHIFT (0x00000018u)
#define CSL_PRUINTC_ENABLECLR1_SI56_RESETVAL (0x00000000u)
/*----SI56 Tokens----*/
#define CSL_PRUINTC_ENABLECLR1_SI56_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR1_SI56_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR1_SI55_MASK (0x00800000u)
#define CSL_PRUINTC_ENABLECLR1_SI55_SHIFT (0x00000017u)
#define CSL_PRUINTC_ENABLECLR1_SI55_RESETVAL (0x00000000u)
/*----SI55 Tokens----*/
#define CSL_PRUINTC_ENABLECLR1_SI55_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR1_SI55_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR1_SI54_MASK (0x00400000u)
#define CSL_PRUINTC_ENABLECLR1_SI54_SHIFT (0x00000016u)
#define CSL_PRUINTC_ENABLECLR1_SI54_RESETVAL (0x00000000u)
/*----SI54 Tokens----*/
#define CSL_PRUINTC_ENABLECLR1_SI54_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR1_SI54_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR1_SI53_MASK (0x00200000u)
#define CSL_PRUINTC_ENABLECLR1_SI53_SHIFT (0x00000015u)
#define CSL_PRUINTC_ENABLECLR1_SI53_RESETVAL (0x00000000u)
/*----SI53 Tokens----*/
#define CSL_PRUINTC_ENABLECLR1_SI53_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR1_SI53_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR1_SI52_MASK (0x00100000u)
#define CSL_PRUINTC_ENABLECLR1_SI52_SHIFT (0x00000014u)
#define CSL_PRUINTC_ENABLECLR1_SI52_RESETVAL (0x00000000u)
/*----SI52 Tokens----*/
#define CSL_PRUINTC_ENABLECLR1_SI52_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR1_SI52_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR1_SI51_MASK (0x00080000u)
#define CSL_PRUINTC_ENABLECLR1_SI51_SHIFT (0x00000013u)
#define CSL_PRUINTC_ENABLECLR1_SI51_RESETVAL (0x00000000u)
/*----SI51 Tokens----*/
#define CSL_PRUINTC_ENABLECLR1_SI51_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR1_SI51_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR1_SI50_MASK (0x00040000u)
#define CSL_PRUINTC_ENABLECLR1_SI50_SHIFT (0x00000012u)
#define CSL_PRUINTC_ENABLECLR1_SI50_RESETVAL (0x00000000u)
/*----SI50 Tokens----*/
#define CSL_PRUINTC_ENABLECLR1_SI50_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR1_SI50_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR1_SI49_MASK (0x00020000u)
#define CSL_PRUINTC_ENABLECLR1_SI49_SHIFT (0x00000011u)
#define CSL_PRUINTC_ENABLECLR1_SI49_RESETVAL (0x00000000u)
/*----SI49 Tokens----*/
#define CSL_PRUINTC_ENABLECLR1_SI49_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR1_SI49_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR1_SI48_MASK (0x00010000u)
#define CSL_PRUINTC_ENABLECLR1_SI48_SHIFT (0x00000010u)
#define CSL_PRUINTC_ENABLECLR1_SI48_RESETVAL (0x00000000u)
/*----SI48 Tokens----*/
#define CSL_PRUINTC_ENABLECLR1_SI48_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR1_SI48_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR1_SI47_MASK (0x00008000u)
#define CSL_PRUINTC_ENABLECLR1_SI47_SHIFT (0x0000000Fu)
#define CSL_PRUINTC_ENABLECLR1_SI47_RESETVAL (0x00000000u)
/*----SI47 Tokens----*/
#define CSL_PRUINTC_ENABLECLR1_SI47_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR1_SI47_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR1_SI46_MASK (0x00004000u)
#define CSL_PRUINTC_ENABLECLR1_SI46_SHIFT (0x0000000Eu)
#define CSL_PRUINTC_ENABLECLR1_SI46_RESETVAL (0x00000000u)
/*----SI46 Tokens----*/
#define CSL_PRUINTC_ENABLECLR1_SI46_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR1_SI46_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR1_SI45_MASK (0x00002000u)
#define CSL_PRUINTC_ENABLECLR1_SI45_SHIFT (0x0000000Du)
#define CSL_PRUINTC_ENABLECLR1_SI45_RESETVAL (0x00000000u)
/*----SI45 Tokens----*/
#define CSL_PRUINTC_ENABLECLR1_SI45_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR1_SI45_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR1_SI44_MASK (0x00001000u)
#define CSL_PRUINTC_ENABLECLR1_SI44_SHIFT (0x0000000Cu)
#define CSL_PRUINTC_ENABLECLR1_SI44_RESETVAL (0x00000000u)
/*----SI44 Tokens----*/
#define CSL_PRUINTC_ENABLECLR1_SI44_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR1_SI44_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR1_SI43_MASK (0x00000800u)
#define CSL_PRUINTC_ENABLECLR1_SI43_SHIFT (0x0000000Bu)
#define CSL_PRUINTC_ENABLECLR1_SI43_RESETVAL (0x00000000u)
/*----SI43 Tokens----*/
#define CSL_PRUINTC_ENABLECLR1_SI43_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR1_SI43_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR1_SI42_MASK (0x00000400u)
#define CSL_PRUINTC_ENABLECLR1_SI42_SHIFT (0x0000000Au)
#define CSL_PRUINTC_ENABLECLR1_SI42_RESETVAL (0x00000000u)
/*----SI42 Tokens----*/
#define CSL_PRUINTC_ENABLECLR1_SI42_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR1_SI42_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR1_SI41_MASK (0x00000200u)
#define CSL_PRUINTC_ENABLECLR1_SI41_SHIFT (0x00000009u)
#define CSL_PRUINTC_ENABLECLR1_SI41_RESETVAL (0x00000000u)
/*----SI41 Tokens----*/
#define CSL_PRUINTC_ENABLECLR1_SI41_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR1_SI41_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR1_SI40_MASK (0x00000100u)
#define CSL_PRUINTC_ENABLECLR1_SI40_SHIFT (0x00000008u)
#define CSL_PRUINTC_ENABLECLR1_SI40_RESETVAL (0x00000000u)
/*----SI40 Tokens----*/
#define CSL_PRUINTC_ENABLECLR1_SI40_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR1_SI40_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR1_SI39_MASK (0x00000080u)
#define CSL_PRUINTC_ENABLECLR1_SI39_SHIFT (0x00000007u)
#define CSL_PRUINTC_ENABLECLR1_SI39_RESETVAL (0x00000000u)
/*----SI39 Tokens----*/
#define CSL_PRUINTC_ENABLECLR1_SI39_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR1_SI39_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR1_SI38_MASK (0x00000040u)
#define CSL_PRUINTC_ENABLECLR1_SI38_SHIFT (0x00000006u)
#define CSL_PRUINTC_ENABLECLR1_SI38_RESETVAL (0x00000000u)
/*----SI38 Tokens----*/
#define CSL_PRUINTC_ENABLECLR1_SI38_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR1_SI38_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR1_SI37_MASK (0x00000020u)
#define CSL_PRUINTC_ENABLECLR1_SI37_SHIFT (0x00000005u)
#define CSL_PRUINTC_ENABLECLR1_SI37_RESETVAL (0x00000000u)
/*----SI37 Tokens----*/
#define CSL_PRUINTC_ENABLECLR1_SI37_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR1_SI37_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR1_SI36_MASK (0x00000010u)
#define CSL_PRUINTC_ENABLECLR1_SI36_SHIFT (0x00000004u)
#define CSL_PRUINTC_ENABLECLR1_SI36_RESETVAL (0x00000000u)
/*----SI36 Tokens----*/
#define CSL_PRUINTC_ENABLECLR1_SI36_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR1_SI36_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR1_SI35_MASK (0x00000008u)
#define CSL_PRUINTC_ENABLECLR1_SI35_SHIFT (0x00000003u)
#define CSL_PRUINTC_ENABLECLR1_SI35_RESETVAL (0x00000000u)
/*----SI35 Tokens----*/
#define CSL_PRUINTC_ENABLECLR1_SI35_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR1_SI35_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR1_SI34_MASK (0x00000004u)
#define CSL_PRUINTC_ENABLECLR1_SI34_SHIFT (0x00000002u)
#define CSL_PRUINTC_ENABLECLR1_SI34_RESETVAL (0x00000000u)
/*----SI34 Tokens----*/
#define CSL_PRUINTC_ENABLECLR1_SI34_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR1_SI34_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR1_SI33_MASK (0x00000002u)
#define CSL_PRUINTC_ENABLECLR1_SI33_SHIFT (0x00000001u)
#define CSL_PRUINTC_ENABLECLR1_SI33_RESETVAL (0x00000000u)
/*----SI33 Tokens----*/
#define CSL_PRUINTC_ENABLECLR1_SI33_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR1_SI33_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR1_SI32_MASK (0x00000001u)
#define CSL_PRUINTC_ENABLECLR1_SI32_SHIFT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR1_SI32_RESETVAL (0x00000000u)
/*----SI32 Tokens----*/
#define CSL_PRUINTC_ENABLECLR1_SI32_NOEFFECT (0x00000000u)
#define CSL_PRUINTC_ENABLECLR1_SI32_CLEAR (0x00000001u)

#define CSL_PRUINTC_ENABLECLR1_RESETVAL  (0x00000000u)

/* CHANMAP0 */

#define CSL_PRUINTC_CHANMAP0_SI3_MASK    (0xFF000000u)
#define CSL_PRUINTC_CHANMAP0_SI3_SHIFT   (0x00000018u)
#define CSL_PRUINTC_CHANMAP0_SI3_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP0_SI2_MASK    (0x00FF0000u)
#define CSL_PRUINTC_CHANMAP0_SI2_SHIFT   (0x00000010u)
#define CSL_PRUINTC_CHANMAP0_SI2_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP0_SI1_MASK    (0x0000FF00u)
#define CSL_PRUINTC_CHANMAP0_SI1_SHIFT   (0x00000008u)
#define CSL_PRUINTC_CHANMAP0_SI1_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP0_SI0_MASK    (0x000000FFu)
#define CSL_PRUINTC_CHANMAP0_SI0_SHIFT   (0x00000000u)
#define CSL_PRUINTC_CHANMAP0_SI0_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP0_RESETVAL    (0x00000000u)

/* CHANMAP1 */

#define CSL_PRUINTC_CHANMAP1_SI7_MASK    (0xFF000000u)
#define CSL_PRUINTC_CHANMAP1_SI7_SHIFT   (0x00000018u)
#define CSL_PRUINTC_CHANMAP1_SI7_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP1_SI6_MASK    (0x00FF0000u)
#define CSL_PRUINTC_CHANMAP1_SI6_SHIFT   (0x00000010u)
#define CSL_PRUINTC_CHANMAP1_SI6_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP1_SI5_MASK    (0x0000FF00u)
#define CSL_PRUINTC_CHANMAP1_SI5_SHIFT   (0x00000008u)
#define CSL_PRUINTC_CHANMAP1_SI5_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP1_SI4_MASK    (0x000000FFu)
#define CSL_PRUINTC_CHANMAP1_SI4_SHIFT   (0x00000000u)
#define CSL_PRUINTC_CHANMAP1_SI4_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP1_RESETVAL    (0x00000000u)

/* CHANMAP2 */

#define CSL_PRUINTC_CHANMAP2_SI11_MASK   (0xFF000000u)
#define CSL_PRUINTC_CHANMAP2_SI11_SHIFT  (0x00000018u)
#define CSL_PRUINTC_CHANMAP2_SI11_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP2_SI10_MASK   (0x00FF0000u)
#define CSL_PRUINTC_CHANMAP2_SI10_SHIFT  (0x00000010u)
#define CSL_PRUINTC_CHANMAP2_SI10_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP2_SI9_MASK    (0x0000FF00u)
#define CSL_PRUINTC_CHANMAP2_SI9_SHIFT   (0x00000008u)
#define CSL_PRUINTC_CHANMAP2_SI9_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP2_SI8_MASK    (0x000000FFu)
#define CSL_PRUINTC_CHANMAP2_SI8_SHIFT   (0x00000000u)
#define CSL_PRUINTC_CHANMAP2_SI8_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP2_RESETVAL    (0x00000000u)

/* CHANMAP3 */

#define CSL_PRUINTC_CHANMAP3_SI15_MASK   (0xFF000000u)
#define CSL_PRUINTC_CHANMAP3_SI15_SHIFT  (0x00000018u)
#define CSL_PRUINTC_CHANMAP3_SI15_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP3_SI14_MASK   (0x00FF0000u)
#define CSL_PRUINTC_CHANMAP3_SI14_SHIFT  (0x00000010u)
#define CSL_PRUINTC_CHANMAP3_SI14_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP3_SI13_MASK   (0x0000FF00u)
#define CSL_PRUINTC_CHANMAP3_SI13_SHIFT  (0x00000008u)
#define CSL_PRUINTC_CHANMAP3_SI13_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP3_SI12_MASK   (0x000000FFu)
#define CSL_PRUINTC_CHANMAP3_SI12_SHIFT  (0x00000000u)
#define CSL_PRUINTC_CHANMAP3_SI12_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP3_RESETVAL    (0x00000000u)

/* CHANMAP4 */

#define CSL_PRUINTC_CHANMAP4_SI19_MASK   (0xFF000000u)
#define CSL_PRUINTC_CHANMAP4_SI19_SHIFT  (0x00000018u)
#define CSL_PRUINTC_CHANMAP4_SI19_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP4_SI18_MASK   (0x00FF0000u)
#define CSL_PRUINTC_CHANMAP4_SI18_SHIFT  (0x00000010u)
#define CSL_PRUINTC_CHANMAP4_SI18_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP4_SI17_MASK   (0x0000FF00u)
#define CSL_PRUINTC_CHANMAP4_SI17_SHIFT  (0x00000008u)
#define CSL_PRUINTC_CHANMAP4_SI17_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP4_SI16_MASK   (0x000000FFu)
#define CSL_PRUINTC_CHANMAP4_SI16_SHIFT  (0x00000000u)
#define CSL_PRUINTC_CHANMAP4_SI16_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP4_RESETVAL    (0x00000000u)

/* CHANMAP5 */

#define CSL_PRUINTC_CHANMAP5_SI23_MASK   (0xFF000000u)
#define CSL_PRUINTC_CHANMAP5_SI23_SHIFT  (0x00000018u)
#define CSL_PRUINTC_CHANMAP5_SI23_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP5_SI22_MASK   (0x00FF0000u)
#define CSL_PRUINTC_CHANMAP5_SI22_SHIFT  (0x00000010u)
#define CSL_PRUINTC_CHANMAP5_SI22_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP5_SI21_MASK   (0x0000FF00u)
#define CSL_PRUINTC_CHANMAP5_SI21_SHIFT  (0x00000008u)
#define CSL_PRUINTC_CHANMAP5_SI21_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP5_SI20_MASK   (0x000000FFu)
#define CSL_PRUINTC_CHANMAP5_SI20_SHIFT  (0x00000000u)
#define CSL_PRUINTC_CHANMAP5_SI20_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP5_RESETVAL    (0x00000000u)

/* CHANMAP6 */

#define CSL_PRUINTC_CHANMAP6_SI27_MASK   (0xFF000000u)
#define CSL_PRUINTC_CHANMAP6_SI27_SHIFT  (0x00000018u)
#define CSL_PRUINTC_CHANMAP6_SI27_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP6_SI26_MASK   (0x00FF0000u)
#define CSL_PRUINTC_CHANMAP6_SI26_SHIFT  (0x00000010u)
#define CSL_PRUINTC_CHANMAP6_SI26_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP6_SI25_MASK   (0x0000FF00u)
#define CSL_PRUINTC_CHANMAP6_SI25_SHIFT  (0x00000008u)
#define CSL_PRUINTC_CHANMAP6_SI25_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP6_SI24_MASK   (0x000000FFu)
#define CSL_PRUINTC_CHANMAP6_SI24_SHIFT  (0x00000000u)
#define CSL_PRUINTC_CHANMAP6_SI24_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP6_RESETVAL    (0x00000000u)

/* CHANMAP7 */

#define CSL_PRUINTC_CHANMAP7_SI31_MASK   (0xFF000000u)
#define CSL_PRUINTC_CHANMAP7_SI31_SHIFT  (0x00000018u)
#define CSL_PRUINTC_CHANMAP7_SI31_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP7_SI30_MASK   (0x00FF0000u)
#define CSL_PRUINTC_CHANMAP7_SI30_SHIFT  (0x00000010u)
#define CSL_PRUINTC_CHANMAP7_SI30_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP7_SI29_MASK   (0x0000FF00u)
#define CSL_PRUINTC_CHANMAP7_SI29_SHIFT  (0x00000008u)
#define CSL_PRUINTC_CHANMAP7_SI29_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP7_SI28_MASK   (0x000000FFu)
#define CSL_PRUINTC_CHANMAP7_SI28_SHIFT  (0x00000000u)
#define CSL_PRUINTC_CHANMAP7_SI28_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP7_RESETVAL    (0x00000000u)

/* CHANMAP8 */

#define CSL_PRUINTC_CHANMAP8_SI35_MASK   (0xFF000000u)
#define CSL_PRUINTC_CHANMAP8_SI35_SHIFT  (0x00000018u)
#define CSL_PRUINTC_CHANMAP8_SI35_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP8_SI34_MASK   (0x00FF0000u)
#define CSL_PRUINTC_CHANMAP8_SI34_SHIFT  (0x00000010u)
#define CSL_PRUINTC_CHANMAP8_SI34_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP8_SI33_MASK   (0x0000FF00u)
#define CSL_PRUINTC_CHANMAP8_SI33_SHIFT  (0x00000008u)
#define CSL_PRUINTC_CHANMAP8_SI33_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP8_SI32_MASK   (0x000000FFu)
#define CSL_PRUINTC_CHANMAP8_SI32_SHIFT  (0x00000000u)
#define CSL_PRUINTC_CHANMAP8_SI32_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP8_RESETVAL    (0x00000000u)

/* CHANMAP9 */

#define CSL_PRUINTC_CHANMAP9_SI39_MASK   (0xFF000000u)
#define CSL_PRUINTC_CHANMAP9_SI39_SHIFT  (0x00000018u)
#define CSL_PRUINTC_CHANMAP9_SI39_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP9_SI38_MASK   (0x00FF0000u)
#define CSL_PRUINTC_CHANMAP9_SI38_SHIFT  (0x00000010u)
#define CSL_PRUINTC_CHANMAP9_SI38_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP9_SI37_MASK   (0x0000FF00u)
#define CSL_PRUINTC_CHANMAP9_SI37_SHIFT  (0x00000008u)
#define CSL_PRUINTC_CHANMAP9_SI37_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP9_SI36_MASK   (0x000000FFu)
#define CSL_PRUINTC_CHANMAP9_SI36_SHIFT  (0x00000000u)
#define CSL_PRUINTC_CHANMAP9_SI36_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP9_RESETVAL    (0x00000000u)

/* CHANMAP10 */

#define CSL_PRUINTC_CHANMAP10_SI43_MASK  (0xFF000000u)
#define CSL_PRUINTC_CHANMAP10_SI43_SHIFT (0x00000018u)
#define CSL_PRUINTC_CHANMAP10_SI43_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP10_SI42_MASK  (0x00FF0000u)
#define CSL_PRUINTC_CHANMAP10_SI42_SHIFT (0x00000010u)
#define CSL_PRUINTC_CHANMAP10_SI42_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP10_SI41_MASK  (0x0000FF00u)
#define CSL_PRUINTC_CHANMAP10_SI41_SHIFT (0x00000008u)
#define CSL_PRUINTC_CHANMAP10_SI41_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP10_SI40_MASK  (0x000000FFu)
#define CSL_PRUINTC_CHANMAP10_SI40_SHIFT (0x00000000u)
#define CSL_PRUINTC_CHANMAP10_SI40_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP10_RESETVAL   (0x00000000u)

/* CHANMAP11 */

#define CSL_PRUINTC_CHANMAP11_SI47_MASK  (0xFF000000u)
#define CSL_PRUINTC_CHANMAP11_SI47_SHIFT (0x00000018u)
#define CSL_PRUINTC_CHANMAP11_SI47_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP11_SI46_MASK  (0x00FF0000u)
#define CSL_PRUINTC_CHANMAP11_SI46_SHIFT (0x00000010u)
#define CSL_PRUINTC_CHANMAP11_SI46_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP11_SI45_MASK  (0x0000FF00u)
#define CSL_PRUINTC_CHANMAP11_SI45_SHIFT (0x00000008u)
#define CSL_PRUINTC_CHANMAP11_SI45_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP11_SI44_MASK  (0x000000FFu)
#define CSL_PRUINTC_CHANMAP11_SI44_SHIFT (0x00000000u)
#define CSL_PRUINTC_CHANMAP11_SI44_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP11_RESETVAL   (0x00000000u)

/* CHANMAP12 */

#define CSL_PRUINTC_CHANMAP12_SI51_MASK  (0xFF000000u)
#define CSL_PRUINTC_CHANMAP12_SI51_SHIFT (0x00000018u)
#define CSL_PRUINTC_CHANMAP12_SI51_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP12_SI50_MASK  (0x00FF0000u)
#define CSL_PRUINTC_CHANMAP12_SI50_SHIFT (0x00000010u)
#define CSL_PRUINTC_CHANMAP12_SI50_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP12_SI49_MASK  (0x0000FF00u)
#define CSL_PRUINTC_CHANMAP12_SI49_SHIFT (0x00000008u)
#define CSL_PRUINTC_CHANMAP12_SI49_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP12_SI48_MASK  (0x000000FFu)
#define CSL_PRUINTC_CHANMAP12_SI48_SHIFT (0x00000000u)
#define CSL_PRUINTC_CHANMAP12_SI48_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP12_RESETVAL   (0x00000000u)

/* CHANMAP13 */

#define CSL_PRUINTC_CHANMAP13_SI55_MASK  (0xFF000000u)
#define CSL_PRUINTC_CHANMAP13_SI55_SHIFT (0x00000018u)
#define CSL_PRUINTC_CHANMAP13_SI55_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP13_SI54_MASK  (0x00FF0000u)
#define CSL_PRUINTC_CHANMAP13_SI54_SHIFT (0x00000010u)
#define CSL_PRUINTC_CHANMAP13_SI54_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP13_SI53_MASK  (0x0000FF00u)
#define CSL_PRUINTC_CHANMAP13_SI53_SHIFT (0x00000008u)
#define CSL_PRUINTC_CHANMAP13_SI53_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP13_SI52_MASK  (0x000000FFu)
#define CSL_PRUINTC_CHANMAP13_SI52_SHIFT (0x00000000u)
#define CSL_PRUINTC_CHANMAP13_SI52_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP13_RESETVAL   (0x00000000u)

/* CHANMAP14 */

#define CSL_PRUINTC_CHANMAP14_SI59_MASK  (0xFF000000u)
#define CSL_PRUINTC_CHANMAP14_SI59_SHIFT (0x00000018u)
#define CSL_PRUINTC_CHANMAP14_SI59_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP14_SI58_MASK  (0x00FF0000u)
#define CSL_PRUINTC_CHANMAP14_SI58_SHIFT (0x00000010u)
#define CSL_PRUINTC_CHANMAP14_SI58_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP14_SI57_MASK  (0x0000FF00u)
#define CSL_PRUINTC_CHANMAP14_SI57_SHIFT (0x00000008u)
#define CSL_PRUINTC_CHANMAP14_SI57_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP14_SI56_MASK  (0x000000FFu)
#define CSL_PRUINTC_CHANMAP14_SI56_SHIFT (0x00000000u)
#define CSL_PRUINTC_CHANMAP14_SI56_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP14_RESETVAL   (0x00000000u)

/* CHANMAP15 */

#define CSL_PRUINTC_CHANMAP15_SI63_MASK  (0xFF000000u)
#define CSL_PRUINTC_CHANMAP15_SI63_SHIFT (0x00000018u)
#define CSL_PRUINTC_CHANMAP15_SI63_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP15_SI62_MASK  (0x00FF0000u)
#define CSL_PRUINTC_CHANMAP15_SI62_SHIFT (0x00000010u)
#define CSL_PRUINTC_CHANMAP15_SI62_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP15_SI61_MASK  (0x0000FF00u)
#define CSL_PRUINTC_CHANMAP15_SI61_SHIFT (0x00000008u)
#define CSL_PRUINTC_CHANMAP15_SI61_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP15_SI60_MASK  (0x000000FFu)
#define CSL_PRUINTC_CHANMAP15_SI60_SHIFT (0x00000000u)
#define CSL_PRUINTC_CHANMAP15_SI60_RESETVAL (0x00000000u)

#define CSL_PRUINTC_CHANMAP15_RESETVAL   (0x00000000u)

/* HOSTMAP0 */

#define CSL_PRUINTC_HOSTMAP0_CHAN3_MASK  (0xFF000000u)
#define CSL_PRUINTC_HOSTMAP0_CHAN3_SHIFT (0x00000018u)
#define CSL_PRUINTC_HOSTMAP0_CHAN3_RESETVAL (0x00000000u)

#define CSL_PRUINTC_HOSTMAP0_CHAN2_MASK  (0x00FF0000u)
#define CSL_PRUINTC_HOSTMAP0_CHAN2_SHIFT (0x00000010u)
#define CSL_PRUINTC_HOSTMAP0_CHAN2_RESETVAL (0x00000000u)

#define CSL_PRUINTC_HOSTMAP0_CHAN1_MASK  (0x0000FF00u)
#define CSL_PRUINTC_HOSTMAP0_CHAN1_SHIFT (0x00000008u)
#define CSL_PRUINTC_HOSTMAP0_CHAN1_RESETVAL (0x00000000u)

#define CSL_PRUINTC_HOSTMAP0_CHAN0_MASK  (0x000000FFu)
#define CSL_PRUINTC_HOSTMAP0_CHAN0_SHIFT (0x00000000u)
#define CSL_PRUINTC_HOSTMAP0_CHAN0_RESETVAL (0x00000000u)

#define CSL_PRUINTC_HOSTMAP0_RESETVAL    (0x00000000u)

/* HOSTMAP1 */

#define CSL_PRUINTC_HOSTMAP1_CHAN7_MASK  (0xFF000000u)
#define CSL_PRUINTC_HOSTMAP1_CHAN7_SHIFT (0x00000018u)
#define CSL_PRUINTC_HOSTMAP1_CHAN7_RESETVAL (0x00000000u)

#define CSL_PRUINTC_HOSTMAP1_CHAN6_MASK  (0x00FF0000u)
#define CSL_PRUINTC_HOSTMAP1_CHAN6_SHIFT (0x00000010u)
#define CSL_PRUINTC_HOSTMAP1_CHAN6_RESETVAL (0x00000000u)

#define CSL_PRUINTC_HOSTMAP1_CHAN5_MASK  (0x0000FF00u)
#define CSL_PRUINTC_HOSTMAP1_CHAN5_SHIFT (0x00000008u)
#define CSL_PRUINTC_HOSTMAP1_CHAN5_RESETVAL (0x00000000u)

#define CSL_PRUINTC_HOSTMAP1_CHAN4_MASK  (0x000000FFu)
#define CSL_PRUINTC_HOSTMAP1_CHAN4_SHIFT (0x00000000u)
#define CSL_PRUINTC_HOSTMAP1_CHAN4_RESETVAL (0x00000000u)

#define CSL_PRUINTC_HOSTMAP1_RESETVAL    (0x00000000u)

/* HOSTMAP2 */


#define CSL_PRUINTC_HOSTMAP2_CHAN9_MASK  (0x0000FF00u)
#define CSL_PRUINTC_HOSTMAP2_CHAN9_SHIFT (0x00000008u)
#define CSL_PRUINTC_HOSTMAP2_CHAN9_RESETVAL (0x00000000u)

#define CSL_PRUINTC_HOSTMAP2_CHAN8_MASK  (0x000000FFu)
#define CSL_PRUINTC_HOSTMAP2_CHAN8_SHIFT (0x00000000u)
#define CSL_PRUINTC_HOSTMAP2_CHAN8_RESETVAL (0x00000000u)

#define CSL_PRUINTC_HOSTMAP2_RESETVAL    (0x00000000u)

/* HSTINTPRIIDX0 */

#define CSL_PRUINTC_HSTINTPRIIDX0_NONE_MASK (0x80000000u)
#define CSL_PRUINTC_HSTINTPRIIDX0_NONE_SHIFT (0x0000001Fu)
#define CSL_PRUINTC_HSTINTPRIIDX0_NONE_RESETVAL (0x00000001u)


#define CSL_PRUINTC_HSTINTPRIIDX0_INDEX_MASK (0x000003FFu)
#define CSL_PRUINTC_HSTINTPRIIDX0_INDEX_SHIFT (0x00000000u)
#define CSL_PRUINTC_HSTINTPRIIDX0_INDEX_RESETVAL (0x00000000u)

#define CSL_PRUINTC_HSTINTPRIIDX0_RESETVAL (0x80000000u)

/* HSTINTPRIIDX1 */

#define CSL_PRUINTC_HSTINTPRIIDX1_NONE_MASK (0x80000000u)
#define CSL_PRUINTC_HSTINTPRIIDX1_NONE_SHIFT (0x0000001Fu)
#define CSL_PRUINTC_HSTINTPRIIDX1_NONE_RESETVAL (0x00000001u)


#define CSL_PRUINTC_HSTINTPRIIDX1_INDEX_MASK (0x000003FFu)
#define CSL_PRUINTC_HSTINTPRIIDX1_INDEX_SHIFT (0x00000000u)
#define CSL_PRUINTC_HSTINTPRIIDX1_INDEX_RESETVAL (0x00000000u)

#define CSL_PRUINTC_HSTINTPRIIDX1_RESETVAL (0x80000000u)

/* HSTINTPRIIDX2 */

#define CSL_PRUINTC_HSTINTPRIIDX2_NONE_MASK (0x80000000u)
#define CSL_PRUINTC_HSTINTPRIIDX2_NONE_SHIFT (0x0000001Fu)
#define CSL_PRUINTC_HSTINTPRIIDX2_NONE_RESETVAL (0x00000001u)


#define CSL_PRUINTC_HSTINTPRIIDX2_INDEX_MASK (0x000003FFu)
#define CSL_PRUINTC_HSTINTPRIIDX2_INDEX_SHIFT (0x00000000u)
#define CSL_PRUINTC_HSTINTPRIIDX2_INDEX_RESETVAL (0x00000000u)

#define CSL_PRUINTC_HSTINTPRIIDX2_RESETVAL (0x80000000u)

/* HSTINTPRIIDX3 */

#define CSL_PRUINTC_HSTINTPRIIDX3_NONE_MASK (0x80000000u)
#define CSL_PRUINTC_HSTINTPRIIDX3_NONE_SHIFT (0x0000001Fu)
#define CSL_PRUINTC_HSTINTPRIIDX3_NONE_RESETVAL (0x00000001u)


#define CSL_PRUINTC_HSTINTPRIIDX3_INDEX_MASK (0x000003FFu)
#define CSL_PRUINTC_HSTINTPRIIDX3_INDEX_SHIFT (0x00000000u)
#define CSL_PRUINTC_HSTINTPRIIDX3_INDEX_RESETVAL (0x00000000u)

#define CSL_PRUINTC_HSTINTPRIIDX3_RESETVAL (0x80000000u)

/* HSTINTPRIIDX4 */

#define CSL_PRUINTC_HSTINTPRIIDX4_NONE_MASK (0x80000000u)
#define CSL_PRUINTC_HSTINTPRIIDX4_NONE_SHIFT (0x0000001Fu)
#define CSL_PRUINTC_HSTINTPRIIDX4_NONE_RESETVAL (0x00000001u)


#define CSL_PRUINTC_HSTINTPRIIDX4_INDEX_MASK (0x000003FFu)
#define CSL_PRUINTC_HSTINTPRIIDX4_INDEX_SHIFT (0x00000000u)
#define CSL_PRUINTC_HSTINTPRIIDX4_INDEX_RESETVAL (0x00000000u)

#define CSL_PRUINTC_HSTINTPRIIDX4_RESETVAL (0x80000000u)

/* HSTINTPRIIDX5 */

#define CSL_PRUINTC_HSTINTPRIIDX5_NONE_MASK (0x80000000u)
#define CSL_PRUINTC_HSTINTPRIIDX5_NONE_SHIFT (0x0000001Fu)
#define CSL_PRUINTC_HSTINTPRIIDX5_NONE_RESETVAL (0x00000001u)


#define CSL_PRUINTC_HSTINTPRIIDX5_INDEX_MASK (0x000003FFu)
#define CSL_PRUINTC_HSTINTPRIIDX5_INDEX_SHIFT (0x00000000u)
#define CSL_PRUINTC_HSTINTPRIIDX5_INDEX_RESETVAL (0x00000000u)

#define CSL_PRUINTC_HSTINTPRIIDX5_RESETVAL (0x80000000u)

/* HSTINTPRIIDX6 */

#define CSL_PRUINTC_HSTINTPRIIDX6_NONE_MASK (0x80000000u)
#define CSL_PRUINTC_HSTINTPRIIDX6_NONE_SHIFT (0x0000001Fu)
#define CSL_PRUINTC_HSTINTPRIIDX6_NONE_RESETVAL (0x00000001u)


#define CSL_PRUINTC_HSTINTPRIIDX6_INDEX_MASK (0x000003FFu)
#define CSL_PRUINTC_HSTINTPRIIDX6_INDEX_SHIFT (0x00000000u)
#define CSL_PRUINTC_HSTINTPRIIDX6_INDEX_RESETVAL (0x00000000u)

#define CSL_PRUINTC_HSTINTPRIIDX6_RESETVAL (0x80000000u)

/* HSTINTPRIIDX7 */

#define CSL_PRUINTC_HSTINTPRIIDX7_NONE_MASK (0x80000000u)
#define CSL_PRUINTC_HSTINTPRIIDX7_NONE_SHIFT (0x0000001Fu)
#define CSL_PRUINTC_HSTINTPRIIDX7_NONE_RESETVAL (0x00000001u)


#define CSL_PRUINTC_HSTINTPRIIDX7_INDEX_MASK (0x000003FFu)
#define CSL_PRUINTC_HSTINTPRIIDX7_INDEX_SHIFT (0x00000000u)
#define CSL_PRUINTC_HSTINTPRIIDX7_INDEX_RESETVAL (0x00000000u)

#define CSL_PRUINTC_HSTINTPRIIDX7_RESETVAL (0x80000000u)

/* HSTINTPRIIDX8 */

#define CSL_PRUINTC_HSTINTPRIIDX8_NONE_MASK (0x80000000u)
#define CSL_PRUINTC_HSTINTPRIIDX8_NONE_SHIFT (0x0000001Fu)
#define CSL_PRUINTC_HSTINTPRIIDX8_NONE_RESETVAL (0x00000001u)


#define CSL_PRUINTC_HSTINTPRIIDX8_INDEX_MASK (0x000003FFu)
#define CSL_PRUINTC_HSTINTPRIIDX8_INDEX_SHIFT (0x00000000u)
#define CSL_PRUINTC_HSTINTPRIIDX8_INDEX_RESETVAL (0x00000000u)

#define CSL_PRUINTC_HSTINTPRIIDX8_RESETVAL (0x80000000u)

/* HSTINTPRIIDX9 */

#define CSL_PRUINTC_HSTINTPRIIDX9_NONE_MASK (0x80000000u)
#define CSL_PRUINTC_HSTINTPRIIDX9_NONE_SHIFT (0x0000001Fu)
#define CSL_PRUINTC_HSTINTPRIIDX9_NONE_RESETVAL (0x00000001u)


#define CSL_PRUINTC_HSTINTPRIIDX9_INDEX_MASK (0x000003FFu)
#define CSL_PRUINTC_HSTINTPRIIDX9_INDEX_SHIFT (0x00000000u)
#define CSL_PRUINTC_HSTINTPRIIDX9_INDEX_RESETVAL (0x00000000u)

#define CSL_PRUINTC_HSTINTPRIIDX9_RESETVAL (0x80000000u)

/* POLARITY0 */

#define CSL_PRUINTC_POLARITY0_SI31_MASK  (0x80000000u)
#define CSL_PRUINTC_POLARITY0_SI31_SHIFT (0x0000001Fu)
#define CSL_PRUINTC_POLARITY0_SI31_RESETVAL (0x00000001u)
/*----SI31 Tokens----*/
#define CSL_PRUINTC_POLARITY0_SI31_LOW   (0x00000000u)
#define CSL_PRUINTC_POLARITY0_SI31_HIGH  (0x00000001u)

#define CSL_PRUINTC_POLARITY0_SI30_MASK  (0x40000000u)
#define CSL_PRUINTC_POLARITY0_SI30_SHIFT (0x0000001Eu)
#define CSL_PRUINTC_POLARITY0_SI30_RESETVAL (0x00000001u)
/*----SI30 Tokens----*/
#define CSL_PRUINTC_POLARITY0_SI30_LOW   (0x00000000u)
#define CSL_PRUINTC_POLARITY0_SI30_HIGH  (0x00000001u)

#define CSL_PRUINTC_POLARITY0_SI29_MASK  (0x20000000u)
#define CSL_PRUINTC_POLARITY0_SI29_SHIFT (0x0000001Du)
#define CSL_PRUINTC_POLARITY0_SI29_RESETVAL (0x00000001u)
/*----SI29 Tokens----*/
#define CSL_PRUINTC_POLARITY0_SI29_LOW   (0x00000000u)
#define CSL_PRUINTC_POLARITY0_SI29_HIGH  (0x00000001u)

#define CSL_PRUINTC_POLARITY0_SI28_MASK  (0x10000000u)
#define CSL_PRUINTC_POLARITY0_SI28_SHIFT (0x0000001Cu)
#define CSL_PRUINTC_POLARITY0_SI28_RESETVAL (0x00000001u)
/*----SI28 Tokens----*/
#define CSL_PRUINTC_POLARITY0_SI28_LOW   (0x00000000u)
#define CSL_PRUINTC_POLARITY0_SI28_HIGH  (0x00000001u)

#define CSL_PRUINTC_POLARITY0_SI27_MASK  (0x08000000u)
#define CSL_PRUINTC_POLARITY0_SI27_SHIFT (0x0000001Bu)
#define CSL_PRUINTC_POLARITY0_SI27_RESETVAL (0x00000001u)
/*----SI27 Tokens----*/
#define CSL_PRUINTC_POLARITY0_SI27_LOW   (0x00000000u)
#define CSL_PRUINTC_POLARITY0_SI27_HIGH  (0x00000001u)

#define CSL_PRUINTC_POLARITY0_SI26_MASK  (0x04000000u)
#define CSL_PRUINTC_POLARITY0_SI26_SHIFT (0x0000001Au)
#define CSL_PRUINTC_POLARITY0_SI26_RESETVAL (0x00000001u)
/*----SI26 Tokens----*/
#define CSL_PRUINTC_POLARITY0_SI26_LOW   (0x00000000u)
#define CSL_PRUINTC_POLARITY0_SI26_HIGH  (0x00000001u)

#define CSL_PRUINTC_POLARITY0_SI25_MASK  (0x02000000u)
#define CSL_PRUINTC_POLARITY0_SI25_SHIFT (0x00000019u)
#define CSL_PRUINTC_POLARITY0_SI25_RESETVAL (0x00000001u)
/*----SI25 Tokens----*/
#define CSL_PRUINTC_POLARITY0_SI25_LOW   (0x00000000u)
#define CSL_PRUINTC_POLARITY0_SI25_HIGH  (0x00000001u)

#define CSL_PRUINTC_POLARITY0_SI24_MASK  (0x01000000u)
#define CSL_PRUINTC_POLARITY0_SI24_SHIFT (0x00000018u)
#define CSL_PRUINTC_POLARITY0_SI24_RESETVAL (0x00000001u)
/*----SI24 Tokens----*/
#define CSL_PRUINTC_POLARITY0_SI24_LOW   (0x00000000u)
#define CSL_PRUINTC_POLARITY0_SI24_HIGH  (0x00000001u)

#define CSL_PRUINTC_POLARITY0_SI23_MASK  (0x00800000u)
#define CSL_PRUINTC_POLARITY0_SI23_SHIFT (0x00000017u)
#define CSL_PRUINTC_POLARITY0_SI23_RESETVAL (0x00000001u)
/*----SI23 Tokens----*/
#define CSL_PRUINTC_POLARITY0_SI23_LOW   (0x00000000u)
#define CSL_PRUINTC_POLARITY0_SI23_HIGH  (0x00000001u)

#define CSL_PRUINTC_POLARITY0_SI22_MASK  (0x00400000u)
#define CSL_PRUINTC_POLARITY0_SI22_SHIFT (0x00000016u)
#define CSL_PRUINTC_POLARITY0_SI22_RESETVAL (0x00000001u)
/*----SI22 Tokens----*/
#define CSL_PRUINTC_POLARITY0_SI22_LOW   (0x00000000u)
#define CSL_PRUINTC_POLARITY0_SI22_HIGH  (0x00000001u)

#define CSL_PRUINTC_POLARITY0_SI21_MASK  (0x00200000u)
#define CSL_PRUINTC_POLARITY0_SI21_SHIFT (0x00000015u)
#define CSL_PRUINTC_POLARITY0_SI21_RESETVAL (0x00000001u)
/*----SI21 Tokens----*/
#define CSL_PRUINTC_POLARITY0_SI21_LOW   (0x00000000u)
#define CSL_PRUINTC_POLARITY0_SI21_HIGH  (0x00000001u)

#define CSL_PRUINTC_POLARITY0_SI20_MASK  (0x00100000u)
#define CSL_PRUINTC_POLARITY0_SI20_SHIFT (0x00000014u)
#define CSL_PRUINTC_POLARITY0_SI20_RESETVAL (0x00000001u)
/*----SI20 Tokens----*/
#define CSL_PRUINTC_POLARITY0_SI20_LOW   (0x00000000u)
#define CSL_PRUINTC_POLARITY0_SI20_HIGH  (0x00000001u)

#define CSL_PRUINTC_POLARITY0_SI19_MASK  (0x00080000u)
#define CSL_PRUINTC_POLARITY0_SI19_SHIFT (0x00000013u)
#define CSL_PRUINTC_POLARITY0_SI19_RESETVAL (0x00000001u)
/*----SI19 Tokens----*/
#define CSL_PRUINTC_POLARITY0_SI19_LOW   (0x00000000u)
#define CSL_PRUINTC_POLARITY0_SI19_HIGH  (0x00000001u)

#define CSL_PRUINTC_POLARITY0_SI18_MASK  (0x00040000u)
#define CSL_PRUINTC_POLARITY0_SI18_SHIFT (0x00000012u)
#define CSL_PRUINTC_POLARITY0_SI18_RESETVAL (0x00000001u)
/*----SI18 Tokens----*/
#define CSL_PRUINTC_POLARITY0_SI18_LOW   (0x00000000u)
#define CSL_PRUINTC_POLARITY0_SI18_HIGH  (0x00000001u)

#define CSL_PRUINTC_POLARITY0_SI17_MASK  (0x00020000u)
#define CSL_PRUINTC_POLARITY0_SI17_SHIFT (0x00000011u)
#define CSL_PRUINTC_POLARITY0_SI17_RESETVAL (0x00000001u)
/*----SI17 Tokens----*/
#define CSL_PRUINTC_POLARITY0_SI17_LOW   (0x00000000u)
#define CSL_PRUINTC_POLARITY0_SI17_HIGH  (0x00000001u)

#define CSL_PRUINTC_POLARITY0_SI16_MASK  (0x00010000u)
#define CSL_PRUINTC_POLARITY0_SI16_SHIFT (0x00000010u)
#define CSL_PRUINTC_POLARITY0_SI16_RESETVAL (0x00000001u)
/*----SI16 Tokens----*/
#define CSL_PRUINTC_POLARITY0_SI16_LOW   (0x00000000u)
#define CSL_PRUINTC_POLARITY0_SI16_HIGH  (0x00000001u)

#define CSL_PRUINTC_POLARITY0_SI15_MASK  (0x00008000u)
#define CSL_PRUINTC_POLARITY0_SI15_SHIFT (0x0000000Fu)
#define CSL_PRUINTC_POLARITY0_SI15_RESETVAL (0x00000001u)
/*----SI15 Tokens----*/
#define CSL_PRUINTC_POLARITY0_SI15_LOW   (0x00000000u)
#define CSL_PRUINTC_POLARITY0_SI15_HIGH  (0x00000001u)

#define CSL_PRUINTC_POLARITY0_SI14_MASK  (0x00004000u)
#define CSL_PRUINTC_POLARITY0_SI14_SHIFT (0x0000000Eu)
#define CSL_PRUINTC_POLARITY0_SI14_RESETVAL (0x00000001u)
/*----SI14 Tokens----*/
#define CSL_PRUINTC_POLARITY0_SI14_LOW   (0x00000000u)
#define CSL_PRUINTC_POLARITY0_SI14_HIGH  (0x00000001u)

#define CSL_PRUINTC_POLARITY0_SI13_MASK  (0x00002000u)
#define CSL_PRUINTC_POLARITY0_SI13_SHIFT (0x0000000Du)
#define CSL_PRUINTC_POLARITY0_SI13_RESETVAL (0x00000001u)
/*----SI13 Tokens----*/
#define CSL_PRUINTC_POLARITY0_SI13_LOW   (0x00000000u)
#define CSL_PRUINTC_POLARITY0_SI13_HIGH  (0x00000001u)

#define CSL_PRUINTC_POLARITY0_SI12_MASK  (0x00001000u)
#define CSL_PRUINTC_POLARITY0_SI12_SHIFT (0x0000000Cu)
#define CSL_PRUINTC_POLARITY0_SI12_RESETVAL (0x00000001u)
/*----SI12 Tokens----*/
#define CSL_PRUINTC_POLARITY0_SI12_LOW   (0x00000000u)
#define CSL_PRUINTC_POLARITY0_SI12_HIGH  (0x00000001u)

#define CSL_PRUINTC_POLARITY0_SI11_MASK  (0x00000800u)
#define CSL_PRUINTC_POLARITY0_SI11_SHIFT (0x0000000Bu)
#define CSL_PRUINTC_POLARITY0_SI11_RESETVAL (0x00000001u)
/*----SI11 Tokens----*/
#define CSL_PRUINTC_POLARITY0_SI11_LOW   (0x00000000u)
#define CSL_PRUINTC_POLARITY0_SI11_HIGH  (0x00000001u)

#define CSL_PRUINTC_POLARITY0_SI10_MASK  (0x00000400u)
#define CSL_PRUINTC_POLARITY0_SI10_SHIFT (0x0000000Au)
#define CSL_PRUINTC_POLARITY0_SI10_RESETVAL (0x00000001u)
/*----SI10 Tokens----*/
#define CSL_PRUINTC_POLARITY0_SI10_LOW   (0x00000000u)
#define CSL_PRUINTC_POLARITY0_SI10_HIGH  (0x00000001u)

#define CSL_PRUINTC_POLARITY0_SI9_MASK   (0x00000200u)
#define CSL_PRUINTC_POLARITY0_SI9_SHIFT  (0x00000009u)
#define CSL_PRUINTC_POLARITY0_SI9_RESETVAL (0x00000001u)
/*----SI9 Tokens----*/
#define CSL_PRUINTC_POLARITY0_SI9_LOW    (0x00000000u)
#define CSL_PRUINTC_POLARITY0_SI9_HIGH   (0x00000001u)

#define CSL_PRUINTC_POLARITY0_SI8_MASK   (0x00000100u)
#define CSL_PRUINTC_POLARITY0_SI8_SHIFT  (0x00000008u)
#define CSL_PRUINTC_POLARITY0_SI8_RESETVAL (0x00000001u)
/*----SI8 Tokens----*/
#define CSL_PRUINTC_POLARITY0_SI8_LOW    (0x00000000u)
#define CSL_PRUINTC_POLARITY0_SI8_HIGH   (0x00000001u)

#define CSL_PRUINTC_POLARITY0_SI7_MASK   (0x00000080u)
#define CSL_PRUINTC_POLARITY0_SI7_SHIFT  (0x00000007u)
#define CSL_PRUINTC_POLARITY0_SI7_RESETVAL (0x00000001u)
/*----SI7 Tokens----*/
#define CSL_PRUINTC_POLARITY0_SI7_LOW    (0x00000000u)
#define CSL_PRUINTC_POLARITY0_SI7_HIGH   (0x00000001u)

#define CSL_PRUINTC_POLARITY0_SI6_MASK   (0x00000040u)
#define CSL_PRUINTC_POLARITY0_SI6_SHIFT  (0x00000006u)
#define CSL_PRUINTC_POLARITY0_SI6_RESETVAL (0x00000001u)
/*----SI6 Tokens----*/
#define CSL_PRUINTC_POLARITY0_SI6_LOW    (0x00000000u)
#define CSL_PRUINTC_POLARITY0_SI6_HIGH   (0x00000001u)

#define CSL_PRUINTC_POLARITY0_SI5_MASK   (0x00000020u)
#define CSL_PRUINTC_POLARITY0_SI5_SHIFT  (0x00000005u)
#define CSL_PRUINTC_POLARITY0_SI5_RESETVAL (0x00000001u)
/*----SI5 Tokens----*/
#define CSL_PRUINTC_POLARITY0_SI5_LOW    (0x00000000u)
#define CSL_PRUINTC_POLARITY0_SI5_HIGH   (0x00000001u)

#define CSL_PRUINTC_POLARITY0_SI4_MASK   (0x00000010u)
#define CSL_PRUINTC_POLARITY0_SI4_SHIFT  (0x00000004u)
#define CSL_PRUINTC_POLARITY0_SI4_RESETVAL (0x00000001u)
/*----SI4 Tokens----*/
#define CSL_PRUINTC_POLARITY0_SI4_LOW    (0x00000000u)
#define CSL_PRUINTC_POLARITY0_SI4_HIGH   (0x00000001u)

#define CSL_PRUINTC_POLARITY0_SI3_MASK   (0x00000008u)
#define CSL_PRUINTC_POLARITY0_SI3_SHIFT  (0x00000003u)
#define CSL_PRUINTC_POLARITY0_SI3_RESETVAL (0x00000001u)
/*----SI3 Tokens----*/
#define CSL_PRUINTC_POLARITY0_SI3_LOW    (0x00000000u)
#define CSL_PRUINTC_POLARITY0_SI3_HIGH   (0x00000001u)

#define CSL_PRUINTC_POLARITY0_SI2_MASK   (0x00000004u)
#define CSL_PRUINTC_POLARITY0_SI2_SHIFT  (0x00000002u)
#define CSL_PRUINTC_POLARITY0_SI2_RESETVAL (0x00000001u)
/*----SI2 Tokens----*/
#define CSL_PRUINTC_POLARITY0_SI2_LOW    (0x00000000u)
#define CSL_PRUINTC_POLARITY0_SI2_HIGH   (0x00000001u)

#define CSL_PRUINTC_POLARITY0_SI1_MASK   (0x00000002u)
#define CSL_PRUINTC_POLARITY0_SI1_SHIFT  (0x00000001u)
#define CSL_PRUINTC_POLARITY0_SI1_RESETVAL (0x00000001u)
/*----SI1 Tokens----*/
#define CSL_PRUINTC_POLARITY0_SI1_LOW    (0x00000000u)
#define CSL_PRUINTC_POLARITY0_SI1_HIGH   (0x00000001u)

#define CSL_PRUINTC_POLARITY0_SI0_MASK   (0x00000001u)
#define CSL_PRUINTC_POLARITY0_SI0_SHIFT  (0x00000000u)
#define CSL_PRUINTC_POLARITY0_SI0_RESETVAL (0x00000001u)
/*----SI0 Tokens----*/
#define CSL_PRUINTC_POLARITY0_SI0_LOW    (0x00000000u)
#define CSL_PRUINTC_POLARITY0_SI0_HIGH   (0x00000001u)

#define CSL_PRUINTC_POLARITY0_RESETVAL   (0xFFFFFFFFu)

/* POLARITY1 */

#define CSL_PRUINTC_POLARITY1_SI63_MASK  (0x80000000u)
#define CSL_PRUINTC_POLARITY1_SI63_SHIFT (0x0000001Fu)
#define CSL_PRUINTC_POLARITY1_SI63_RESETVAL (0x00000001u)
/*----SI63 Tokens----*/
#define CSL_PRUINTC_POLARITY1_SI63_LOW   (0x00000000u)
#define CSL_PRUINTC_POLARITY1_SI63_HIGH  (0x00000001u)

#define CSL_PRUINTC_POLARITY1_SI62_MASK  (0x40000000u)
#define CSL_PRUINTC_POLARITY1_SI62_SHIFT (0x0000001Eu)
#define CSL_PRUINTC_POLARITY1_SI62_RESETVAL (0x00000001u)
/*----SI62 Tokens----*/
#define CSL_PRUINTC_POLARITY1_SI62_LOW   (0x00000000u)
#define CSL_PRUINTC_POLARITY1_SI62_HIGH  (0x00000001u)

#define CSL_PRUINTC_POLARITY1_SI61_MASK  (0x20000000u)
#define CSL_PRUINTC_POLARITY1_SI61_SHIFT (0x0000001Du)
#define CSL_PRUINTC_POLARITY1_SI61_RESETVAL (0x00000001u)
/*----SI61 Tokens----*/
#define CSL_PRUINTC_POLARITY1_SI61_LOW   (0x00000000u)
#define CSL_PRUINTC_POLARITY1_SI61_HIGH  (0x00000001u)

#define CSL_PRUINTC_POLARITY1_SI60_MASK  (0x10000000u)
#define CSL_PRUINTC_POLARITY1_SI60_SHIFT (0x0000001Cu)
#define CSL_PRUINTC_POLARITY1_SI60_RESETVAL (0x00000001u)
/*----SI60 Tokens----*/
#define CSL_PRUINTC_POLARITY1_SI60_LOW   (0x00000000u)
#define CSL_PRUINTC_POLARITY1_SI60_HIGH  (0x00000001u)

#define CSL_PRUINTC_POLARITY1_SI59_MASK  (0x08000000u)
#define CSL_PRUINTC_POLARITY1_SI59_SHIFT (0x0000001Bu)
#define CSL_PRUINTC_POLARITY1_SI59_RESETVAL (0x00000001u)
/*----SI59 Tokens----*/
#define CSL_PRUINTC_POLARITY1_SI59_LOW   (0x00000000u)
#define CSL_PRUINTC_POLARITY1_SI59_HIGH  (0x00000001u)

#define CSL_PRUINTC_POLARITY1_SI58_MASK  (0x04000000u)
#define CSL_PRUINTC_POLARITY1_SI58_SHIFT (0x0000001Au)
#define CSL_PRUINTC_POLARITY1_SI58_RESETVAL (0x00000001u)
/*----SI58 Tokens----*/
#define CSL_PRUINTC_POLARITY1_SI58_LOW   (0x00000000u)
#define CSL_PRUINTC_POLARITY1_SI58_HIGH  (0x00000001u)

#define CSL_PRUINTC_POLARITY1_SI57_MASK  (0x02000000u)
#define CSL_PRUINTC_POLARITY1_SI57_SHIFT (0x00000019u)
#define CSL_PRUINTC_POLARITY1_SI57_RESETVAL (0x00000001u)
/*----SI57 Tokens----*/
#define CSL_PRUINTC_POLARITY1_SI57_LOW   (0x00000000u)
#define CSL_PRUINTC_POLARITY1_SI57_HIGH  (0x00000001u)

#define CSL_PRUINTC_POLARITY1_SI56_MASK  (0x01000000u)
#define CSL_PRUINTC_POLARITY1_SI56_SHIFT (0x00000018u)
#define CSL_PRUINTC_POLARITY1_SI56_RESETVAL (0x00000001u)
/*----SI56 Tokens----*/
#define CSL_PRUINTC_POLARITY1_SI56_LOW   (0x00000000u)
#define CSL_PRUINTC_POLARITY1_SI56_HIGH  (0x00000001u)

#define CSL_PRUINTC_POLARITY1_SI55_MASK  (0x00800000u)
#define CSL_PRUINTC_POLARITY1_SI55_SHIFT (0x00000017u)
#define CSL_PRUINTC_POLARITY1_SI55_RESETVAL (0x00000001u)
/*----SI55 Tokens----*/
#define CSL_PRUINTC_POLARITY1_SI55_LOW   (0x00000000u)
#define CSL_PRUINTC_POLARITY1_SI55_HIGH  (0x00000001u)

#define CSL_PRUINTC_POLARITY1_SI54_MASK  (0x00400000u)
#define CSL_PRUINTC_POLARITY1_SI54_SHIFT (0x00000016u)
#define CSL_PRUINTC_POLARITY1_SI54_RESETVAL (0x00000001u)
/*----SI54 Tokens----*/
#define CSL_PRUINTC_POLARITY1_SI54_LOW   (0x00000000u)
#define CSL_PRUINTC_POLARITY1_SI54_HIGH  (0x00000001u)

#define CSL_PRUINTC_POLARITY1_SI53_MASK  (0x00200000u)
#define CSL_PRUINTC_POLARITY1_SI53_SHIFT (0x00000015u)
#define CSL_PRUINTC_POLARITY1_SI53_RESETVAL (0x00000001u)
/*----SI53 Tokens----*/
#define CSL_PRUINTC_POLARITY1_SI53_LOW   (0x00000000u)
#define CSL_PRUINTC_POLARITY1_SI53_HIGH  (0x00000001u)

#define CSL_PRUINTC_POLARITY1_SI52_MASK  (0x00100000u)
#define CSL_PRUINTC_POLARITY1_SI52_SHIFT (0x00000014u)
#define CSL_PRUINTC_POLARITY1_SI52_RESETVAL (0x00000001u)
/*----SI52 Tokens----*/
#define CSL_PRUINTC_POLARITY1_SI52_LOW   (0x00000000u)
#define CSL_PRUINTC_POLARITY1_SI52_HIGH  (0x00000001u)

#define CSL_PRUINTC_POLARITY1_SI51_MASK  (0x00080000u)
#define CSL_PRUINTC_POLARITY1_SI51_SHIFT (0x00000013u)
#define CSL_PRUINTC_POLARITY1_SI51_RESETVAL (0x00000001u)
/*----SI51 Tokens----*/
#define CSL_PRUINTC_POLARITY1_SI51_LOW   (0x00000000u)
#define CSL_PRUINTC_POLARITY1_SI51_HIGH  (0x00000001u)

#define CSL_PRUINTC_POLARITY1_SI50_MASK  (0x00040000u)
#define CSL_PRUINTC_POLARITY1_SI50_SHIFT (0x00000012u)
#define CSL_PRUINTC_POLARITY1_SI50_RESETVAL (0x00000001u)
/*----SI50 Tokens----*/
#define CSL_PRUINTC_POLARITY1_SI50_LOW   (0x00000000u)
#define CSL_PRUINTC_POLARITY1_SI50_HIGH  (0x00000001u)

#define CSL_PRUINTC_POLARITY1_SI49_MASK  (0x00020000u)
#define CSL_PRUINTC_POLARITY1_SI49_SHIFT (0x00000011u)
#define CSL_PRUINTC_POLARITY1_SI49_RESETVAL (0x00000001u)
/*----SI49 Tokens----*/
#define CSL_PRUINTC_POLARITY1_SI49_LOW   (0x00000000u)
#define CSL_PRUINTC_POLARITY1_SI49_HIGH  (0x00000001u)

#define CSL_PRUINTC_POLARITY1_SI48_MASK  (0x00010000u)
#define CSL_PRUINTC_POLARITY1_SI48_SHIFT (0x00000010u)
#define CSL_PRUINTC_POLARITY1_SI48_RESETVAL (0x00000001u)
/*----SI48 Tokens----*/
#define CSL_PRUINTC_POLARITY1_SI48_LOW   (0x00000000u)
#define CSL_PRUINTC_POLARITY1_SI48_HIGH  (0x00000001u)

#define CSL_PRUINTC_POLARITY1_SI47_MASK  (0x00008000u)
#define CSL_PRUINTC_POLARITY1_SI47_SHIFT (0x0000000Fu)
#define CSL_PRUINTC_POLARITY1_SI47_RESETVAL (0x00000001u)
/*----SI47 Tokens----*/
#define CSL_PRUINTC_POLARITY1_SI47_LOW   (0x00000000u)
#define CSL_PRUINTC_POLARITY1_SI47_HIGH  (0x00000001u)

#define CSL_PRUINTC_POLARITY1_SI46_MASK  (0x00004000u)
#define CSL_PRUINTC_POLARITY1_SI46_SHIFT (0x0000000Eu)
#define CSL_PRUINTC_POLARITY1_SI46_RESETVAL (0x00000001u)
/*----SI46 Tokens----*/
#define CSL_PRUINTC_POLARITY1_SI46_LOW   (0x00000000u)
#define CSL_PRUINTC_POLARITY1_SI46_HIGH  (0x00000001u)

#define CSL_PRUINTC_POLARITY1_SI45_MASK  (0x00002000u)
#define CSL_PRUINTC_POLARITY1_SI45_SHIFT (0x0000000Du)
#define CSL_PRUINTC_POLARITY1_SI45_RESETVAL (0x00000001u)
/*----SI45 Tokens----*/
#define CSL_PRUINTC_POLARITY1_SI45_LOW   (0x00000000u)
#define CSL_PRUINTC_POLARITY1_SI45_HIGH  (0x00000001u)

#define CSL_PRUINTC_POLARITY1_SI44_MASK  (0x00001000u)
#define CSL_PRUINTC_POLARITY1_SI44_SHIFT (0x0000000Cu)
#define CSL_PRUINTC_POLARITY1_SI44_RESETVAL (0x00000001u)
/*----SI44 Tokens----*/
#define CSL_PRUINTC_POLARITY1_SI44_LOW   (0x00000000u)
#define CSL_PRUINTC_POLARITY1_SI44_HIGH  (0x00000001u)

#define CSL_PRUINTC_POLARITY1_SI43_MASK  (0x00000800u)
#define CSL_PRUINTC_POLARITY1_SI43_SHIFT (0x0000000Bu)
#define CSL_PRUINTC_POLARITY1_SI43_RESETVAL (0x00000001u)
/*----SI43 Tokens----*/
#define CSL_PRUINTC_POLARITY1_SI43_LOW   (0x00000000u)
#define CSL_PRUINTC_POLARITY1_SI43_HIGH  (0x00000001u)

#define CSL_PRUINTC_POLARITY1_SI42_MASK  (0x00000400u)
#define CSL_PRUINTC_POLARITY1_SI42_SHIFT (0x0000000Au)
#define CSL_PRUINTC_POLARITY1_SI42_RESETVAL (0x00000001u)
/*----SI42 Tokens----*/
#define CSL_PRUINTC_POLARITY1_SI42_LOW   (0x00000000u)
#define CSL_PRUINTC_POLARITY1_SI42_HIGH  (0x00000001u)

#define CSL_PRUINTC_POLARITY1_SI41_MASK  (0x00000200u)
#define CSL_PRUINTC_POLARITY1_SI41_SHIFT (0x00000009u)
#define CSL_PRUINTC_POLARITY1_SI41_RESETVAL (0x00000001u)
/*----SI41 Tokens----*/
#define CSL_PRUINTC_POLARITY1_SI41_LOW   (0x00000000u)
#define CSL_PRUINTC_POLARITY1_SI41_HIGH  (0x00000001u)

#define CSL_PRUINTC_POLARITY1_SI40_MASK  (0x00000100u)
#define CSL_PRUINTC_POLARITY1_SI40_SHIFT (0x00000008u)
#define CSL_PRUINTC_POLARITY1_SI40_RESETVAL (0x00000001u)
/*----SI40 Tokens----*/
#define CSL_PRUINTC_POLARITY1_SI40_LOW   (0x00000000u)
#define CSL_PRUINTC_POLARITY1_SI40_HIGH  (0x00000001u)

#define CSL_PRUINTC_POLARITY1_SI39_MASK  (0x00000080u)
#define CSL_PRUINTC_POLARITY1_SI39_SHIFT (0x00000007u)
#define CSL_PRUINTC_POLARITY1_SI39_RESETVAL (0x00000001u)
/*----SI39 Tokens----*/
#define CSL_PRUINTC_POLARITY1_SI39_LOW   (0x00000000u)
#define CSL_PRUINTC_POLARITY1_SI39_HIGH  (0x00000001u)

#define CSL_PRUINTC_POLARITY1_SI38_MASK  (0x00000040u)
#define CSL_PRUINTC_POLARITY1_SI38_SHIFT (0x00000006u)
#define CSL_PRUINTC_POLARITY1_SI38_RESETVAL (0x00000001u)
/*----SI38 Tokens----*/
#define CSL_PRUINTC_POLARITY1_SI38_LOW   (0x00000000u)
#define CSL_PRUINTC_POLARITY1_SI38_HIGH  (0x00000001u)

#define CSL_PRUINTC_POLARITY1_SI37_MASK  (0x00000020u)
#define CSL_PRUINTC_POLARITY1_SI37_SHIFT (0x00000005u)
#define CSL_PRUINTC_POLARITY1_SI37_RESETVAL (0x00000001u)
/*----SI37 Tokens----*/
#define CSL_PRUINTC_POLARITY1_SI37_LOW   (0x00000000u)
#define CSL_PRUINTC_POLARITY1_SI37_HIGH  (0x00000001u)

#define CSL_PRUINTC_POLARITY1_SI36_MASK  (0x00000010u)
#define CSL_PRUINTC_POLARITY1_SI36_SHIFT (0x00000004u)
#define CSL_PRUINTC_POLARITY1_SI36_RESETVAL (0x00000001u)
/*----SI36 Tokens----*/
#define CSL_PRUINTC_POLARITY1_SI36_LOW   (0x00000000u)
#define CSL_PRUINTC_POLARITY1_SI36_HIGH  (0x00000001u)

#define CSL_PRUINTC_POLARITY1_SI35_MASK  (0x00000008u)
#define CSL_PRUINTC_POLARITY1_SI35_SHIFT (0x00000003u)
#define CSL_PRUINTC_POLARITY1_SI35_RESETVAL (0x00000001u)
/*----SI35 Tokens----*/
#define CSL_PRUINTC_POLARITY1_SI35_LOW   (0x00000000u)
#define CSL_PRUINTC_POLARITY1_SI35_HIGH  (0x00000001u)

#define CSL_PRUINTC_POLARITY1_SI34_MASK  (0x00000004u)
#define CSL_PRUINTC_POLARITY1_SI34_SHIFT (0x00000002u)
#define CSL_PRUINTC_POLARITY1_SI34_RESETVAL (0x00000001u)
/*----SI34 Tokens----*/
#define CSL_PRUINTC_POLARITY1_SI34_LOW   (0x00000000u)
#define CSL_PRUINTC_POLARITY1_SI34_HIGH  (0x00000001u)

#define CSL_PRUINTC_POLARITY1_SI33_MASK  (0x00000002u)
#define CSL_PRUINTC_POLARITY1_SI33_SHIFT (0x00000001u)
#define CSL_PRUINTC_POLARITY1_SI33_RESETVAL (0x00000001u)
/*----SI33 Tokens----*/
#define CSL_PRUINTC_POLARITY1_SI33_LOW   (0x00000000u)
#define CSL_PRUINTC_POLARITY1_SI33_HIGH  (0x00000001u)

#define CSL_PRUINTC_POLARITY1_SI32_MASK  (0x00000001u)
#define CSL_PRUINTC_POLARITY1_SI32_SHIFT (0x00000000u)
#define CSL_PRUINTC_POLARITY1_SI32_RESETVAL (0x00000001u)
/*----SI32 Tokens----*/
#define CSL_PRUINTC_POLARITY1_SI32_LOW   (0x00000000u)
#define CSL_PRUINTC_POLARITY1_SI32_HIGH  (0x00000001u)

#define CSL_PRUINTC_POLARITY1_RESETVAL   (0xFFFFFFFFu)

/* TYPE0 */

#define CSL_PRUINTC_TYPE0_SI31_MASK      (0x80000000u)
#define CSL_PRUINTC_TYPE0_SI31_SHIFT     (0x0000001Fu)
#define CSL_PRUINTC_TYPE0_SI31_RESETVAL  (0x00000000u)
/*----SI31 Tokens----*/
#define CSL_PRUINTC_TYPE0_SI31_LEVEL     (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI31_PULSE     (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI31_EDGE      (0x00000001u)

#define CSL_PRUINTC_TYPE0_SI30_MASK      (0x40000000u)
#define CSL_PRUINTC_TYPE0_SI30_SHIFT     (0x0000001Eu)
#define CSL_PRUINTC_TYPE0_SI30_RESETVAL  (0x00000000u)
/*----SI30 Tokens----*/
#define CSL_PRUINTC_TYPE0_SI30_LEVEL     (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI30_PULSE     (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI30_EDGE      (0x00000001u)

#define CSL_PRUINTC_TYPE0_SI29_MASK      (0x20000000u)
#define CSL_PRUINTC_TYPE0_SI29_SHIFT     (0x0000001Du)
#define CSL_PRUINTC_TYPE0_SI29_RESETVAL  (0x00000000u)
/*----SI29 Tokens----*/
#define CSL_PRUINTC_TYPE0_SI29_LEVEL     (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI29_PULSE     (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI29_EDGE      (0x00000001u)

#define CSL_PRUINTC_TYPE0_SI28_MASK      (0x10000000u)
#define CSL_PRUINTC_TYPE0_SI28_SHIFT     (0x0000001Cu)
#define CSL_PRUINTC_TYPE0_SI28_RESETVAL  (0x00000000u)
/*----SI28 Tokens----*/
#define CSL_PRUINTC_TYPE0_SI28_LEVEL     (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI28_PULSE     (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI28_EDGE      (0x00000001u)

#define CSL_PRUINTC_TYPE0_SI27_MASK      (0x08000000u)
#define CSL_PRUINTC_TYPE0_SI27_SHIFT     (0x0000001Bu)
#define CSL_PRUINTC_TYPE0_SI27_RESETVAL  (0x00000000u)
/*----SI27 Tokens----*/
#define CSL_PRUINTC_TYPE0_SI27_LEVEL     (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI27_PULSE     (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI27_EDGE      (0x00000001u)

#define CSL_PRUINTC_TYPE0_SI26_MASK      (0x04000000u)
#define CSL_PRUINTC_TYPE0_SI26_SHIFT     (0x0000001Au)
#define CSL_PRUINTC_TYPE0_SI26_RESETVAL  (0x00000000u)
/*----SI26 Tokens----*/
#define CSL_PRUINTC_TYPE0_SI26_LEVEL     (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI26_PULSE     (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI26_EDGE      (0x00000001u)

#define CSL_PRUINTC_TYPE0_SI25_MASK      (0x02000000u)
#define CSL_PRUINTC_TYPE0_SI25_SHIFT     (0x00000019u)
#define CSL_PRUINTC_TYPE0_SI25_RESETVAL  (0x00000000u)
/*----SI25 Tokens----*/
#define CSL_PRUINTC_TYPE0_SI25_LEVEL     (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI25_PULSE     (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI25_EDGE      (0x00000001u)

#define CSL_PRUINTC_TYPE0_SI24_MASK      (0x01000000u)
#define CSL_PRUINTC_TYPE0_SI24_SHIFT     (0x00000018u)
#define CSL_PRUINTC_TYPE0_SI24_RESETVAL  (0x00000000u)
/*----SI24 Tokens----*/
#define CSL_PRUINTC_TYPE0_SI24_LEVEL     (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI24_PULSE     (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI24_EDGE      (0x00000001u)

#define CSL_PRUINTC_TYPE0_SI23_MASK      (0x00800000u)
#define CSL_PRUINTC_TYPE0_SI23_SHIFT     (0x00000017u)
#define CSL_PRUINTC_TYPE0_SI23_RESETVAL  (0x00000000u)
/*----SI23 Tokens----*/
#define CSL_PRUINTC_TYPE0_SI23_LEVEL     (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI23_PULSE     (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI23_EDGE      (0x00000001u)

#define CSL_PRUINTC_TYPE0_SI22_MASK      (0x00400000u)
#define CSL_PRUINTC_TYPE0_SI22_SHIFT     (0x00000016u)
#define CSL_PRUINTC_TYPE0_SI22_RESETVAL  (0x00000000u)
/*----SI22 Tokens----*/
#define CSL_PRUINTC_TYPE0_SI22_LEVEL     (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI22_PULSE     (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI22_EDGE      (0x00000001u)

#define CSL_PRUINTC_TYPE0_SI21_MASK      (0x00200000u)
#define CSL_PRUINTC_TYPE0_SI21_SHIFT     (0x00000015u)
#define CSL_PRUINTC_TYPE0_SI21_RESETVAL  (0x00000000u)
/*----SI21 Tokens----*/
#define CSL_PRUINTC_TYPE0_SI21_LEVEL     (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI21_PULSE     (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI21_EDGE      (0x00000001u)

#define CSL_PRUINTC_TYPE0_SI20_MASK      (0x00100000u)
#define CSL_PRUINTC_TYPE0_SI20_SHIFT     (0x00000014u)
#define CSL_PRUINTC_TYPE0_SI20_RESETVAL  (0x00000000u)
/*----SI20 Tokens----*/
#define CSL_PRUINTC_TYPE0_SI20_LEVEL     (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI20_PULSE     (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI20_EDGE      (0x00000001u)

#define CSL_PRUINTC_TYPE0_SI19_MASK      (0x00080000u)
#define CSL_PRUINTC_TYPE0_SI19_SHIFT     (0x00000013u)
#define CSL_PRUINTC_TYPE0_SI19_RESETVAL  (0x00000000u)
/*----SI19 Tokens----*/
#define CSL_PRUINTC_TYPE0_SI19_LEVEL     (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI19_PULSE     (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI19_EDGE      (0x00000001u)

#define CSL_PRUINTC_TYPE0_SI18_MASK      (0x00040000u)
#define CSL_PRUINTC_TYPE0_SI18_SHIFT     (0x00000012u)
#define CSL_PRUINTC_TYPE0_SI18_RESETVAL  (0x00000000u)
/*----SI18 Tokens----*/
#define CSL_PRUINTC_TYPE0_SI18_LEVEL     (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI18_PULSE     (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI18_EDGE      (0x00000001u)

#define CSL_PRUINTC_TYPE0_SI17_MASK      (0x00020000u)
#define CSL_PRUINTC_TYPE0_SI17_SHIFT     (0x00000011u)
#define CSL_PRUINTC_TYPE0_SI17_RESETVAL  (0x00000000u)
/*----SI17 Tokens----*/
#define CSL_PRUINTC_TYPE0_SI17_LEVEL     (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI17_PULSE     (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI17_EDGE      (0x00000001u)

#define CSL_PRUINTC_TYPE0_SI16_MASK      (0x00010000u)
#define CSL_PRUINTC_TYPE0_SI16_SHIFT     (0x00000010u)
#define CSL_PRUINTC_TYPE0_SI16_RESETVAL  (0x00000000u)
/*----SI16 Tokens----*/
#define CSL_PRUINTC_TYPE0_SI16_LEVEL     (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI16_PULSE     (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI16_EDGE      (0x00000001u)

#define CSL_PRUINTC_TYPE0_SI15_MASK      (0x00008000u)
#define CSL_PRUINTC_TYPE0_SI15_SHIFT     (0x0000000Fu)
#define CSL_PRUINTC_TYPE0_SI15_RESETVAL  (0x00000000u)
/*----SI15 Tokens----*/
#define CSL_PRUINTC_TYPE0_SI15_LEVEL     (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI15_PULSE     (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI15_EDGE      (0x00000001u)

#define CSL_PRUINTC_TYPE0_SI14_MASK      (0x00004000u)
#define CSL_PRUINTC_TYPE0_SI14_SHIFT     (0x0000000Eu)
#define CSL_PRUINTC_TYPE0_SI14_RESETVAL  (0x00000000u)
/*----SI14 Tokens----*/
#define CSL_PRUINTC_TYPE0_SI14_LEVEL     (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI14_PULSE     (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI14_EDGE      (0x00000001u)

#define CSL_PRUINTC_TYPE0_SI13_MASK      (0x00002000u)
#define CSL_PRUINTC_TYPE0_SI13_SHIFT     (0x0000000Du)
#define CSL_PRUINTC_TYPE0_SI13_RESETVAL  (0x00000000u)
/*----SI13 Tokens----*/
#define CSL_PRUINTC_TYPE0_SI13_LEVEL     (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI13_PULSE     (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI13_EDGE      (0x00000001u)

#define CSL_PRUINTC_TYPE0_SI12_MASK      (0x00001000u)
#define CSL_PRUINTC_TYPE0_SI12_SHIFT     (0x0000000Cu)
#define CSL_PRUINTC_TYPE0_SI12_RESETVAL  (0x00000000u)
/*----SI12 Tokens----*/
#define CSL_PRUINTC_TYPE0_SI12_LEVEL     (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI12_PULSE     (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI12_EDGE      (0x00000001u)

#define CSL_PRUINTC_TYPE0_SI11_MASK      (0x00000800u)
#define CSL_PRUINTC_TYPE0_SI11_SHIFT     (0x0000000Bu)
#define CSL_PRUINTC_TYPE0_SI11_RESETVAL  (0x00000000u)
/*----SI11 Tokens----*/
#define CSL_PRUINTC_TYPE0_SI11_LEVEL     (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI11_PULSE     (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI11_EDGE      (0x00000001u)

#define CSL_PRUINTC_TYPE0_SI10_MASK      (0x00000400u)
#define CSL_PRUINTC_TYPE0_SI10_SHIFT     (0x0000000Au)
#define CSL_PRUINTC_TYPE0_SI10_RESETVAL  (0x00000000u)
/*----SI10 Tokens----*/
#define CSL_PRUINTC_TYPE0_SI10_LEVEL     (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI10_PULSE     (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI10_EDGE      (0x00000001u)

#define CSL_PRUINTC_TYPE0_SI9_MASK       (0x00000200u)
#define CSL_PRUINTC_TYPE0_SI9_SHIFT      (0x00000009u)
#define CSL_PRUINTC_TYPE0_SI9_RESETVAL   (0x00000000u)
/*----SI9 Tokens----*/
#define CSL_PRUINTC_TYPE0_SI9_LEVEL      (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI9_PULSE      (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI9_EDGE       (0x00000001u)

#define CSL_PRUINTC_TYPE0_SI8_MASK       (0x00000100u)
#define CSL_PRUINTC_TYPE0_SI8_SHIFT      (0x00000008u)
#define CSL_PRUINTC_TYPE0_SI8_RESETVAL   (0x00000000u)
/*----SI8 Tokens----*/
#define CSL_PRUINTC_TYPE0_SI8_LEVEL      (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI8_PULSE      (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI8_EDGE       (0x00000001u)

#define CSL_PRUINTC_TYPE0_SI7_MASK       (0x00000080u)
#define CSL_PRUINTC_TYPE0_SI7_SHIFT      (0x00000007u)
#define CSL_PRUINTC_TYPE0_SI7_RESETVAL   (0x00000000u)
/*----SI7 Tokens----*/
#define CSL_PRUINTC_TYPE0_SI7_LEVEL      (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI7_PULSE      (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI7_EDGE       (0x00000001u)

#define CSL_PRUINTC_TYPE0_SI6_MASK       (0x00000040u)
#define CSL_PRUINTC_TYPE0_SI6_SHIFT      (0x00000006u)
#define CSL_PRUINTC_TYPE0_SI6_RESETVAL   (0x00000000u)
/*----SI6 Tokens----*/
#define CSL_PRUINTC_TYPE0_SI6_LEVEL      (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI6_PULSE      (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI6_EDGE       (0x00000001u)

#define CSL_PRUINTC_TYPE0_SI5_MASK       (0x00000020u)
#define CSL_PRUINTC_TYPE0_SI5_SHIFT      (0x00000005u)
#define CSL_PRUINTC_TYPE0_SI5_RESETVAL   (0x00000000u)
/*----SI5 Tokens----*/
#define CSL_PRUINTC_TYPE0_SI5_LEVEL      (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI5_PULSE      (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI5_EDGE       (0x00000001u)

#define CSL_PRUINTC_TYPE0_SI4_MASK       (0x00000010u)
#define CSL_PRUINTC_TYPE0_SI4_SHIFT      (0x00000004u)
#define CSL_PRUINTC_TYPE0_SI4_RESETVAL   (0x00000000u)
/*----SI4 Tokens----*/
#define CSL_PRUINTC_TYPE0_SI4_LEVEL      (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI4_PULSE      (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI4_EDGE       (0x00000001u)

#define CSL_PRUINTC_TYPE0_SI3_MASK       (0x00000008u)
#define CSL_PRUINTC_TYPE0_SI3_SHIFT      (0x00000003u)
#define CSL_PRUINTC_TYPE0_SI3_RESETVAL   (0x00000000u)
/*----SI3 Tokens----*/
#define CSL_PRUINTC_TYPE0_SI3_LEVEL      (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI3_PULSE      (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI3_EDGE       (0x00000001u)

#define CSL_PRUINTC_TYPE0_SI2_MASK       (0x00000004u)
#define CSL_PRUINTC_TYPE0_SI2_SHIFT      (0x00000002u)
#define CSL_PRUINTC_TYPE0_SI2_RESETVAL   (0x00000000u)
/*----SI2 Tokens----*/
#define CSL_PRUINTC_TYPE0_SI2_LEVEL      (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI2_PULSE      (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI2_EDGE       (0x00000001u)

#define CSL_PRUINTC_TYPE0_SI1_MASK       (0x00000002u)
#define CSL_PRUINTC_TYPE0_SI1_SHIFT      (0x00000001u)
#define CSL_PRUINTC_TYPE0_SI1_RESETVAL   (0x00000000u)
/*----SI1 Tokens----*/
#define CSL_PRUINTC_TYPE0_SI1_LEVEL      (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI1_PULSE      (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI1_EDGE       (0x00000001u)

#define CSL_PRUINTC_TYPE0_SI0_MASK       (0x00000001u)
#define CSL_PRUINTC_TYPE0_SI0_SHIFT      (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI0_RESETVAL   (0x00000000u)
/*----SI0 Tokens----*/
#define CSL_PRUINTC_TYPE0_SI0_LEVEL      (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI0_PULSE      (0x00000000u)
#define CSL_PRUINTC_TYPE0_SI0_EDGE       (0x00000001u)

#define CSL_PRUINTC_TYPE0_RESETVAL       (0x00000000u)

/* TYPE1 */

#define CSL_PRUINTC_TYPE1_SI63_MASK      (0x80000000u)
#define CSL_PRUINTC_TYPE1_SI63_SHIFT     (0x0000001Fu)
#define CSL_PRUINTC_TYPE1_SI63_RESETVAL  (0x00000000u)
/*----SI63 Tokens----*/
#define CSL_PRUINTC_TYPE1_SI63_LEVEL     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI63_PULSE     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI63_EDGE      (0x00000001u)

#define CSL_PRUINTC_TYPE1_SI62_MASK      (0x40000000u)
#define CSL_PRUINTC_TYPE1_SI62_SHIFT     (0x0000001Eu)
#define CSL_PRUINTC_TYPE1_SI62_RESETVAL  (0x00000000u)
/*----SI62 Tokens----*/
#define CSL_PRUINTC_TYPE1_SI62_LEVEL     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI62_PULSE     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI62_EDGE      (0x00000001u)

#define CSL_PRUINTC_TYPE1_SI61_MASK      (0x20000000u)
#define CSL_PRUINTC_TYPE1_SI61_SHIFT     (0x0000001Du)
#define CSL_PRUINTC_TYPE1_SI61_RESETVAL  (0x00000000u)
/*----SI61 Tokens----*/
#define CSL_PRUINTC_TYPE1_SI61_LEVEL     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI61_PULSE     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI61_EDGE      (0x00000001u)

#define CSL_PRUINTC_TYPE1_SI60_MASK      (0x10000000u)
#define CSL_PRUINTC_TYPE1_SI60_SHIFT     (0x0000001Cu)
#define CSL_PRUINTC_TYPE1_SI60_RESETVAL  (0x00000000u)
/*----SI60 Tokens----*/
#define CSL_PRUINTC_TYPE1_SI60_LEVEL     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI60_PULSE     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI60_EDGE      (0x00000001u)

#define CSL_PRUINTC_TYPE1_SI59_MASK      (0x08000000u)
#define CSL_PRUINTC_TYPE1_SI59_SHIFT     (0x0000001Bu)
#define CSL_PRUINTC_TYPE1_SI59_RESETVAL  (0x00000000u)
/*----SI59 Tokens----*/
#define CSL_PRUINTC_TYPE1_SI59_LEVEL     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI59_PULSE     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI59_EDGE      (0x00000001u)

#define CSL_PRUINTC_TYPE1_SI58_MASK      (0x04000000u)
#define CSL_PRUINTC_TYPE1_SI58_SHIFT     (0x0000001Au)
#define CSL_PRUINTC_TYPE1_SI58_RESETVAL  (0x00000000u)
/*----SI58 Tokens----*/
#define CSL_PRUINTC_TYPE1_SI58_LEVEL     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI58_PULSE     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI58_EDGE      (0x00000001u)

#define CSL_PRUINTC_TYPE1_SI57_MASK      (0x02000000u)
#define CSL_PRUINTC_TYPE1_SI57_SHIFT     (0x00000019u)
#define CSL_PRUINTC_TYPE1_SI57_RESETVAL  (0x00000000u)
/*----SI57 Tokens----*/
#define CSL_PRUINTC_TYPE1_SI57_LEVEL     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI57_PULSE     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI57_EDGE      (0x00000001u)

#define CSL_PRUINTC_TYPE1_SI56_MASK      (0x01000000u)
#define CSL_PRUINTC_TYPE1_SI56_SHIFT     (0x00000018u)
#define CSL_PRUINTC_TYPE1_SI56_RESETVAL  (0x00000000u)
/*----SI56 Tokens----*/
#define CSL_PRUINTC_TYPE1_SI56_LEVEL     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI56_PULSE     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI56_EDGE      (0x00000001u)

#define CSL_PRUINTC_TYPE1_SI55_MASK      (0x00800000u)
#define CSL_PRUINTC_TYPE1_SI55_SHIFT     (0x00000017u)
#define CSL_PRUINTC_TYPE1_SI55_RESETVAL  (0x00000000u)
/*----SI55 Tokens----*/
#define CSL_PRUINTC_TYPE1_SI55_LEVEL     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI55_PULSE     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI55_EDGE      (0x00000001u)

#define CSL_PRUINTC_TYPE1_SI54_MASK      (0x00400000u)
#define CSL_PRUINTC_TYPE1_SI54_SHIFT     (0x00000016u)
#define CSL_PRUINTC_TYPE1_SI54_RESETVAL  (0x00000000u)
/*----SI54 Tokens----*/
#define CSL_PRUINTC_TYPE1_SI54_LEVEL     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI54_PULSE     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI54_EDGE      (0x00000001u)

#define CSL_PRUINTC_TYPE1_SI53_MASK      (0x00200000u)
#define CSL_PRUINTC_TYPE1_SI53_SHIFT     (0x00000015u)
#define CSL_PRUINTC_TYPE1_SI53_RESETVAL  (0x00000000u)
/*----SI53 Tokens----*/
#define CSL_PRUINTC_TYPE1_SI53_LEVEL     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI53_PULSE     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI53_EDGE      (0x00000001u)

#define CSL_PRUINTC_TYPE1_SI52_MASK      (0x00100000u)
#define CSL_PRUINTC_TYPE1_SI52_SHIFT     (0x00000014u)
#define CSL_PRUINTC_TYPE1_SI52_RESETVAL  (0x00000000u)
/*----SI52 Tokens----*/
#define CSL_PRUINTC_TYPE1_SI52_LEVEL     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI52_PULSE     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI52_EDGE      (0x00000001u)

#define CSL_PRUINTC_TYPE1_SI51_MASK      (0x00080000u)
#define CSL_PRUINTC_TYPE1_SI51_SHIFT     (0x00000013u)
#define CSL_PRUINTC_TYPE1_SI51_RESETVAL  (0x00000000u)
/*----SI51 Tokens----*/
#define CSL_PRUINTC_TYPE1_SI51_LEVEL     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI51_PULSE     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI51_EDGE      (0x00000001u)

#define CSL_PRUINTC_TYPE1_SI50_MASK      (0x00040000u)
#define CSL_PRUINTC_TYPE1_SI50_SHIFT     (0x00000012u)
#define CSL_PRUINTC_TYPE1_SI50_RESETVAL  (0x00000000u)
/*----SI50 Tokens----*/
#define CSL_PRUINTC_TYPE1_SI50_LEVEL     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI50_PULSE     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI50_EDGE      (0x00000001u)

#define CSL_PRUINTC_TYPE1_SI49_MASK      (0x00020000u)
#define CSL_PRUINTC_TYPE1_SI49_SHIFT     (0x00000011u)
#define CSL_PRUINTC_TYPE1_SI49_RESETVAL  (0x00000000u)
/*----SI49 Tokens----*/
#define CSL_PRUINTC_TYPE1_SI49_LEVEL     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI49_PULSE     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI49_EDGE      (0x00000001u)

#define CSL_PRUINTC_TYPE1_SI48_MASK      (0x00010000u)
#define CSL_PRUINTC_TYPE1_SI48_SHIFT     (0x00000010u)
#define CSL_PRUINTC_TYPE1_SI48_RESETVAL  (0x00000000u)
/*----SI48 Tokens----*/
#define CSL_PRUINTC_TYPE1_SI48_LEVEL     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI48_PULSE     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI48_EDGE      (0x00000001u)

#define CSL_PRUINTC_TYPE1_SI47_MASK      (0x00008000u)
#define CSL_PRUINTC_TYPE1_SI47_SHIFT     (0x0000000Fu)
#define CSL_PRUINTC_TYPE1_SI47_RESETVAL  (0x00000000u)
/*----SI47 Tokens----*/
#define CSL_PRUINTC_TYPE1_SI47_LEVEL     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI47_PULSE     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI47_EDGE      (0x00000001u)

#define CSL_PRUINTC_TYPE1_SI46_MASK      (0x00004000u)
#define CSL_PRUINTC_TYPE1_SI46_SHIFT     (0x0000000Eu)
#define CSL_PRUINTC_TYPE1_SI46_RESETVAL  (0x00000000u)
/*----SI46 Tokens----*/
#define CSL_PRUINTC_TYPE1_SI46_LEVEL     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI46_PULSE     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI46_EDGE      (0x00000001u)

#define CSL_PRUINTC_TYPE1_SI45_MASK      (0x00002000u)
#define CSL_PRUINTC_TYPE1_SI45_SHIFT     (0x0000000Du)
#define CSL_PRUINTC_TYPE1_SI45_RESETVAL  (0x00000000u)
/*----SI45 Tokens----*/
#define CSL_PRUINTC_TYPE1_SI45_LEVEL     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI45_PULSE     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI45_EDGE      (0x00000001u)

#define CSL_PRUINTC_TYPE1_SI44_MASK      (0x00001000u)
#define CSL_PRUINTC_TYPE1_SI44_SHIFT     (0x0000000Cu)
#define CSL_PRUINTC_TYPE1_SI44_RESETVAL  (0x00000000u)
/*----SI44 Tokens----*/
#define CSL_PRUINTC_TYPE1_SI44_LEVEL     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI44_PULSE     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI44_EDGE      (0x00000001u)

#define CSL_PRUINTC_TYPE1_SI43_MASK      (0x00000800u)
#define CSL_PRUINTC_TYPE1_SI43_SHIFT     (0x0000000Bu)
#define CSL_PRUINTC_TYPE1_SI43_RESETVAL  (0x00000000u)
/*----SI43 Tokens----*/
#define CSL_PRUINTC_TYPE1_SI43_LEVEL     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI43_PULSE     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI43_EDGE      (0x00000001u)

#define CSL_PRUINTC_TYPE1_SI42_MASK      (0x00000400u)
#define CSL_PRUINTC_TYPE1_SI42_SHIFT     (0x0000000Au)
#define CSL_PRUINTC_TYPE1_SI42_RESETVAL  (0x00000000u)
/*----SI42 Tokens----*/
#define CSL_PRUINTC_TYPE1_SI42_LEVEL     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI42_PULSE     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI42_EDGE      (0x00000001u)

#define CSL_PRUINTC_TYPE1_SI41_MASK      (0x00000200u)
#define CSL_PRUINTC_TYPE1_SI41_SHIFT     (0x00000009u)
#define CSL_PRUINTC_TYPE1_SI41_RESETVAL  (0x00000000u)
/*----SI41 Tokens----*/
#define CSL_PRUINTC_TYPE1_SI41_LEVEL     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI41_PULSE     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI41_EDGE      (0x00000001u)

#define CSL_PRUINTC_TYPE1_SI40_MASK      (0x00000100u)
#define CSL_PRUINTC_TYPE1_SI40_SHIFT     (0x00000008u)
#define CSL_PRUINTC_TYPE1_SI40_RESETVAL  (0x00000000u)
/*----SI40 Tokens----*/
#define CSL_PRUINTC_TYPE1_SI40_LEVEL     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI40_PULSE     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI40_EDGE      (0x00000001u)

#define CSL_PRUINTC_TYPE1_SI39_MASK      (0x00000080u)
#define CSL_PRUINTC_TYPE1_SI39_SHIFT     (0x00000007u)
#define CSL_PRUINTC_TYPE1_SI39_RESETVAL  (0x00000000u)
/*----SI39 Tokens----*/
#define CSL_PRUINTC_TYPE1_SI39_LEVEL     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI39_PULSE     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI39_EDGE      (0x00000001u)

#define CSL_PRUINTC_TYPE1_SI38_MASK      (0x00000040u)
#define CSL_PRUINTC_TYPE1_SI38_SHIFT     (0x00000006u)
#define CSL_PRUINTC_TYPE1_SI38_RESETVAL  (0x00000000u)
/*----SI38 Tokens----*/
#define CSL_PRUINTC_TYPE1_SI38_LEVEL     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI38_PULSE     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI38_EDGE      (0x00000001u)

#define CSL_PRUINTC_TYPE1_SI37_MASK      (0x00000020u)
#define CSL_PRUINTC_TYPE1_SI37_SHIFT     (0x00000005u)
#define CSL_PRUINTC_TYPE1_SI37_RESETVAL  (0x00000000u)
/*----SI37 Tokens----*/
#define CSL_PRUINTC_TYPE1_SI37_LEVEL     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI37_PULSE     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI37_EDGE      (0x00000001u)

#define CSL_PRUINTC_TYPE1_SI36_MASK      (0x00000010u)
#define CSL_PRUINTC_TYPE1_SI36_SHIFT     (0x00000004u)
#define CSL_PRUINTC_TYPE1_SI36_RESETVAL  (0x00000000u)
/*----SI36 Tokens----*/
#define CSL_PRUINTC_TYPE1_SI36_LEVEL     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI36_PULSE     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI36_EDGE      (0x00000001u)

#define CSL_PRUINTC_TYPE1_SI35_MASK      (0x00000008u)
#define CSL_PRUINTC_TYPE1_SI35_SHIFT     (0x00000003u)
#define CSL_PRUINTC_TYPE1_SI35_RESETVAL  (0x00000000u)
/*----SI35 Tokens----*/
#define CSL_PRUINTC_TYPE1_SI35_LEVEL     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI35_PULSE     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI35_EDGE      (0x00000001u)

#define CSL_PRUINTC_TYPE1_SI34_MASK      (0x00000004u)
#define CSL_PRUINTC_TYPE1_SI34_SHIFT     (0x00000002u)
#define CSL_PRUINTC_TYPE1_SI34_RESETVAL  (0x00000000u)
/*----SI34 Tokens----*/
#define CSL_PRUINTC_TYPE1_SI34_LEVEL     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI34_PULSE     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI34_EDGE      (0x00000001u)

#define CSL_PRUINTC_TYPE1_SI33_MASK      (0x00000002u)
#define CSL_PRUINTC_TYPE1_SI33_SHIFT     (0x00000001u)
#define CSL_PRUINTC_TYPE1_SI33_RESETVAL  (0x00000000u)
/*----SI33 Tokens----*/
#define CSL_PRUINTC_TYPE1_SI33_LEVEL     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI33_PULSE     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI33_EDGE      (0x00000001u)

#define CSL_PRUINTC_TYPE1_SI32_MASK      (0x00000001u)
#define CSL_PRUINTC_TYPE1_SI32_SHIFT     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI32_RESETVAL  (0x00000000u)
/*----SI32 Tokens----*/
#define CSL_PRUINTC_TYPE1_SI32_LEVEL     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI32_PULSE     (0x00000000u)
#define CSL_PRUINTC_TYPE1_SI32_EDGE      (0x00000001u)

#define CSL_PRUINTC_TYPE1_RESETVAL       (0x00000000u)

/* HSTINTNSTLVL0 */

#define CSL_PRUINTC_HSTINTNSTLVL0_OVERRIDE_MASK (0x80000000u)
#define CSL_PRUINTC_HSTINTNSTLVL0_OVERRIDE_SHIFT (0x0000001Fu)
#define CSL_PRUINTC_HSTINTNSTLVL0_OVERRIDE_RESETVAL (0x00000000u)
/*----OVERRIDE Tokens----*/
#define CSL_PRUINTC_HSTINTNSTLVL0_OVERRIDE_DISABLE (0x00000000u)
#define CSL_PRUINTC_HSTINTNSTLVL0_OVERRIDE_ENABLE (0x00000001u)


#define CSL_PRUINTC_HSTINTNSTLVL0_LEVEL_MASK (0x000001FFu)
#define CSL_PRUINTC_HSTINTNSTLVL0_LEVEL_SHIFT (0x00000000u)
#define CSL_PRUINTC_HSTINTNSTLVL0_LEVEL_RESETVAL (0x00000000u)

#define CSL_PRUINTC_HSTINTNSTLVL0_RESETVAL (0x00000000u)

/* HSTINTNSTLVL1 */

#define CSL_PRUINTC_HSTINTNSTLVL1_OVERRIDE_MASK (0x80000000u)
#define CSL_PRUINTC_HSTINTNSTLVL1_OVERRIDE_SHIFT (0x0000001Fu)
#define CSL_PRUINTC_HSTINTNSTLVL1_OVERRIDE_RESETVAL (0x00000000u)
/*----OVERRIDE Tokens----*/
#define CSL_PRUINTC_HSTINTNSTLVL1_OVERRIDE_DISABLE (0x00000000u)
#define CSL_PRUINTC_HSTINTNSTLVL1_OVERRIDE_ENABLE (0x00000001u)


#define CSL_PRUINTC_HSTINTNSTLVL1_LEVEL_MASK (0x000001FFu)
#define CSL_PRUINTC_HSTINTNSTLVL1_LEVEL_SHIFT (0x00000000u)
#define CSL_PRUINTC_HSTINTNSTLVL1_LEVEL_RESETVAL (0x00000000u)

#define CSL_PRUINTC_HSTINTNSTLVL1_RESETVAL (0x00000000u)

/* HSTINTNSTLVL2 */

#define CSL_PRUINTC_HSTINTNSTLVL2_OVERRIDE_MASK (0x80000000u)
#define CSL_PRUINTC_HSTINTNSTLVL2_OVERRIDE_SHIFT (0x0000001Fu)
#define CSL_PRUINTC_HSTINTNSTLVL2_OVERRIDE_RESETVAL (0x00000000u)
/*----OVERRIDE Tokens----*/
#define CSL_PRUINTC_HSTINTNSTLVL2_OVERRIDE_DISABLE (0x00000000u)
#define CSL_PRUINTC_HSTINTNSTLVL2_OVERRIDE_ENABLE (0x00000001u)


#define CSL_PRUINTC_HSTINTNSTLVL2_LEVEL_MASK (0x000001FFu)
#define CSL_PRUINTC_HSTINTNSTLVL2_LEVEL_SHIFT (0x00000000u)
#define CSL_PRUINTC_HSTINTNSTLVL2_LEVEL_RESETVAL (0x00000000u)

#define CSL_PRUINTC_HSTINTNSTLVL2_RESETVAL (0x00000000u)

/* HSTINTNSTLVL3 */

#define CSL_PRUINTC_HSTINTNSTLVL3_OVERRIDE_MASK (0x80000000u)
#define CSL_PRUINTC_HSTINTNSTLVL3_OVERRIDE_SHIFT (0x0000001Fu)
#define CSL_PRUINTC_HSTINTNSTLVL3_OVERRIDE_RESETVAL (0x00000000u)
/*----OVERRIDE Tokens----*/
#define CSL_PRUINTC_HSTINTNSTLVL3_OVERRIDE_DISABLE (0x00000000u)
#define CSL_PRUINTC_HSTINTNSTLVL3_OVERRIDE_ENABLE (0x00000001u)


#define CSL_PRUINTC_HSTINTNSTLVL3_LEVEL_MASK (0x000001FFu)
#define CSL_PRUINTC_HSTINTNSTLVL3_LEVEL_SHIFT (0x00000000u)
#define CSL_PRUINTC_HSTINTNSTLVL3_LEVEL_RESETVAL (0x00000000u)

#define CSL_PRUINTC_HSTINTNSTLVL3_RESETVAL (0x00000000u)

/* HSTINTNSTLVL4 */

#define CSL_PRUINTC_HSTINTNSTLVL4_OVERRIDE_MASK (0x80000000u)
#define CSL_PRUINTC_HSTINTNSTLVL4_OVERRIDE_SHIFT (0x0000001Fu)
#define CSL_PRUINTC_HSTINTNSTLVL4_OVERRIDE_RESETVAL (0x00000000u)
/*----OVERRIDE Tokens----*/
#define CSL_PRUINTC_HSTINTNSTLVL4_OVERRIDE_DISABLE (0x00000000u)
#define CSL_PRUINTC_HSTINTNSTLVL4_OVERRIDE_ENABLE (0x00000001u)


#define CSL_PRUINTC_HSTINTNSTLVL4_LEVEL_MASK (0x000001FFu)
#define CSL_PRUINTC_HSTINTNSTLVL4_LEVEL_SHIFT (0x00000000u)
#define CSL_PRUINTC_HSTINTNSTLVL4_LEVEL_RESETVAL (0x00000000u)

#define CSL_PRUINTC_HSTINTNSTLVL4_RESETVAL (0x00000000u)

/* HSTINTNSTLVL5 */

#define CSL_PRUINTC_HSTINTNSTLVL5_OVERRIDE_MASK (0x80000000u)
#define CSL_PRUINTC_HSTINTNSTLVL5_OVERRIDE_SHIFT (0x0000001Fu)
#define CSL_PRUINTC_HSTINTNSTLVL5_OVERRIDE_RESETVAL (0x00000000u)
/*----OVERRIDE Tokens----*/
#define CSL_PRUINTC_HSTINTNSTLVL5_OVERRIDE_DISABLE (0x00000000u)
#define CSL_PRUINTC_HSTINTNSTLVL5_OVERRIDE_ENABLE (0x00000001u)


#define CSL_PRUINTC_HSTINTNSTLVL5_LEVEL_MASK (0x000001FFu)
#define CSL_PRUINTC_HSTINTNSTLVL5_LEVEL_SHIFT (0x00000000u)
#define CSL_PRUINTC_HSTINTNSTLVL5_LEVEL_RESETVAL (0x00000000u)

#define CSL_PRUINTC_HSTINTNSTLVL5_RESETVAL (0x00000000u)

/* HSTINTNSTLVL6 */

#define CSL_PRUINTC_HSTINTNSTLVL6_OVERRIDE_MASK (0x80000000u)
#define CSL_PRUINTC_HSTINTNSTLVL6_OVERRIDE_SHIFT (0x0000001Fu)
#define CSL_PRUINTC_HSTINTNSTLVL6_OVERRIDE_RESETVAL (0x00000000u)
/*----OVERRIDE Tokens----*/
#define CSL_PRUINTC_HSTINTNSTLVL6_OVERRIDE_DISABLE (0x00000000u)
#define CSL_PRUINTC_HSTINTNSTLVL6_OVERRIDE_ENABLE (0x00000001u)


#define CSL_PRUINTC_HSTINTNSTLVL6_LEVEL_MASK (0x000001FFu)
#define CSL_PRUINTC_HSTINTNSTLVL6_LEVEL_SHIFT (0x00000000u)
#define CSL_PRUINTC_HSTINTNSTLVL6_LEVEL_RESETVAL (0x00000000u)

#define CSL_PRUINTC_HSTINTNSTLVL6_RESETVAL (0x00000000u)

/* HSTINTNSTLVL7 */

#define CSL_PRUINTC_HSTINTNSTLVL7_OVERRIDE_MASK (0x80000000u)
#define CSL_PRUINTC_HSTINTNSTLVL7_OVERRIDE_SHIFT (0x0000001Fu)
#define CSL_PRUINTC_HSTINTNSTLVL7_OVERRIDE_RESETVAL (0x00000000u)
/*----OVERRIDE Tokens----*/
#define CSL_PRUINTC_HSTINTNSTLVL7_OVERRIDE_DISABLE (0x00000000u)
#define CSL_PRUINTC_HSTINTNSTLVL7_OVERRIDE_ENABLE (0x00000001u)


#define CSL_PRUINTC_HSTINTNSTLVL7_LEVEL_MASK (0x000001FFu)
#define CSL_PRUINTC_HSTINTNSTLVL7_LEVEL_SHIFT (0x00000000u)
#define CSL_PRUINTC_HSTINTNSTLVL7_LEVEL_RESETVAL (0x00000000u)

#define CSL_PRUINTC_HSTINTNSTLVL7_RESETVAL (0x00000000u)

/* HSTINTNSTLVL8 */

#define CSL_PRUINTC_HSTINTNSTLVL8_OVERRIDE_MASK (0x80000000u)
#define CSL_PRUINTC_HSTINTNSTLVL8_OVERRIDE_SHIFT (0x0000001Fu)
#define CSL_PRUINTC_HSTINTNSTLVL8_OVERRIDE_RESETVAL (0x00000000u)
/*----OVERRIDE Tokens----*/
#define CSL_PRUINTC_HSTINTNSTLVL8_OVERRIDE_DISABLE (0x00000000u)
#define CSL_PRUINTC_HSTINTNSTLVL8_OVERRIDE_ENABLE (0x00000001u)


#define CSL_PRUINTC_HSTINTNSTLVL8_LEVEL_MASK (0x000001FFu)
#define CSL_PRUINTC_HSTINTNSTLVL8_LEVEL_SHIFT (0x00000000u)
#define CSL_PRUINTC_HSTINTNSTLVL8_LEVEL_RESETVAL (0x00000000u)

#define CSL_PRUINTC_HSTINTNSTLVL8_RESETVAL (0x00000000u)

/* HSTINTNSTLVL9 */

#define CSL_PRUINTC_HSTINTNSTLVL9_OVERRIDE_MASK (0x80000000u)
#define CSL_PRUINTC_HSTINTNSTLVL9_OVERRIDE_SHIFT (0x0000001Fu)
#define CSL_PRUINTC_HSTINTNSTLVL9_OVERRIDE_RESETVAL (0x00000000u)
/*----OVERRIDE Tokens----*/
#define CSL_PRUINTC_HSTINTNSTLVL9_OVERRIDE_DISABLE (0x00000000u)
#define CSL_PRUINTC_HSTINTNSTLVL9_OVERRIDE_ENABLE (0x00000001u)


#define CSL_PRUINTC_HSTINTNSTLVL9_LEVEL_MASK (0x000001FFu)
#define CSL_PRUINTC_HSTINTNSTLVL9_LEVEL_SHIFT (0x00000000u)
#define CSL_PRUINTC_HSTINTNSTLVL9_LEVEL_RESETVAL (0x00000000u)

#define CSL_PRUINTC_HSTINTNSTLVL9_RESETVAL (0x00000000u)

/* HSTINTEN */


#define CSL_PRUINTC_HSTINTEN_INT9_MASK   (0x00000200u)
#define CSL_PRUINTC_HSTINTEN_INT9_SHIFT  (0x00000009u)
#define CSL_PRUINTC_HSTINTEN_INT9_RESETVAL (0x00000000u)
/*----INT9 Tokens----*/
#define CSL_PRUINTC_HSTINTEN_INT9_DISABLE (0x00000000u)
#define CSL_PRUINTC_HSTINTEN_INT9_ENABLE (0x00000001u)

#define CSL_PRUINTC_HSTINTEN_INT8_MASK   (0x00000100u)
#define CSL_PRUINTC_HSTINTEN_INT8_SHIFT  (0x00000008u)
#define CSL_PRUINTC_HSTINTEN_INT8_RESETVAL (0x00000000u)
/*----INT8 Tokens----*/
#define CSL_PRUINTC_HSTINTEN_INT8_DISABLE (0x00000000u)
#define CSL_PRUINTC_HSTINTEN_INT8_ENABLE (0x00000001u)

#define CSL_PRUINTC_HSTINTEN_INT7_MASK   (0x00000080u)
#define CSL_PRUINTC_HSTINTEN_INT7_SHIFT  (0x00000007u)
#define CSL_PRUINTC_HSTINTEN_INT7_RESETVAL (0x00000000u)
/*----INT7 Tokens----*/
#define CSL_PRUINTC_HSTINTEN_INT7_DISABLE (0x00000000u)
#define CSL_PRUINTC_HSTINTEN_INT7_ENABLE (0x00000001u)

#define CSL_PRUINTC_HSTINTEN_INT6_MASK   (0x00000040u)
#define CSL_PRUINTC_HSTINTEN_INT6_SHIFT  (0x00000006u)
#define CSL_PRUINTC_HSTINTEN_INT6_RESETVAL (0x00000000u)
/*----INT6 Tokens----*/
#define CSL_PRUINTC_HSTINTEN_INT6_DISABLE (0x00000000u)
#define CSL_PRUINTC_HSTINTEN_INT6_ENABLE (0x00000001u)

#define CSL_PRUINTC_HSTINTEN_INT5_MASK   (0x00000020u)
#define CSL_PRUINTC_HSTINTEN_INT5_SHIFT  (0x00000005u)
#define CSL_PRUINTC_HSTINTEN_INT5_RESETVAL (0x00000000u)
/*----INT5 Tokens----*/
#define CSL_PRUINTC_HSTINTEN_INT5_DISABLE (0x00000000u)
#define CSL_PRUINTC_HSTINTEN_INT5_ENABLE (0x00000001u)

#define CSL_PRUINTC_HSTINTEN_INT4_MASK   (0x00000010u)
#define CSL_PRUINTC_HSTINTEN_INT4_SHIFT  (0x00000004u)
#define CSL_PRUINTC_HSTINTEN_INT4_RESETVAL (0x00000000u)
/*----INT4 Tokens----*/
#define CSL_PRUINTC_HSTINTEN_INT4_DISABLE (0x00000000u)
#define CSL_PRUINTC_HSTINTEN_INT4_ENABLE (0x00000001u)

#define CSL_PRUINTC_HSTINTEN_INT3_MASK   (0x00000008u)
#define CSL_PRUINTC_HSTINTEN_INT3_SHIFT  (0x00000003u)
#define CSL_PRUINTC_HSTINTEN_INT3_RESETVAL (0x00000000u)
/*----INT3 Tokens----*/
#define CSL_PRUINTC_HSTINTEN_INT3_DISABLE (0x00000000u)
#define CSL_PRUINTC_HSTINTEN_INT3_ENABLE (0x00000001u)

#define CSL_PRUINTC_HSTINTEN_INT2_MASK   (0x00000004u)
#define CSL_PRUINTC_HSTINTEN_INT2_SHIFT  (0x00000002u)
#define CSL_PRUINTC_HSTINTEN_INT2_RESETVAL (0x00000000u)
/*----INT2 Tokens----*/
#define CSL_PRUINTC_HSTINTEN_INT2_DISABLE (0x00000000u)
#define CSL_PRUINTC_HSTINTEN_INT2_ENABLE (0x00000001u)

#define CSL_PRUINTC_HSTINTEN_INT1_MASK   (0x00000002u)
#define CSL_PRUINTC_HSTINTEN_INT1_SHIFT  (0x00000001u)
#define CSL_PRUINTC_HSTINTEN_INT1_RESETVAL (0x00000000u)
/*----INT1 Tokens----*/
#define CSL_PRUINTC_HSTINTEN_INT1_DISABLE (0x00000000u)
#define CSL_PRUINTC_HSTINTEN_INT1_ENABLE (0x00000001u)

#define CSL_PRUINTC_HSTINTEN_INT0_MASK   (0x00000001u)
#define CSL_PRUINTC_HSTINTEN_INT0_SHIFT  (0x00000000u)
#define CSL_PRUINTC_HSTINTEN_INT0_RESETVAL (0x00000000u)
/*----INT0 Tokens----*/
#define CSL_PRUINTC_HSTINTEN_INT0_DISABLE (0x00000000u)
#define CSL_PRUINTC_HSTINTEN_INT0_ENABLE (0x00000001u)

#define CSL_PRUINTC_HSTINTEN_RESETVAL    (0x00000000u)

#ifdef __cplusplus
}
#endif

#endif
